/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import javax.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import org.apache.webbeans.configurator.AnnotatedParameterConfiguratorImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;

public class AnnotatedMethodConfiguratorImpl<T>
implements AnnotatedMethodConfigurator<T> {
    private final AnnotatedMethodImpl<T> annotatedMethod;
    private final List<AnnotatedParameterConfigurator<T>> annotatedParameterConfigurators;

    public AnnotatedMethodConfiguratorImpl(AnnotatedMethodImpl<T> annotatedMethod) {
        this.annotatedMethod = annotatedMethod;
        this.annotatedParameterConfigurators = annotatedMethod.getParameters().stream().map(m -> new AnnotatedParameterConfiguratorImpl(m)).collect(Collectors.toList());
    }

    public AnnotatedMethod<T> getAnnotated() {
        return this.annotatedMethod;
    }

    public AnnotatedMethodConfigurator<T> add(Annotation annotation) {
        this.annotatedMethod.addAnnotation(annotation);
        return this;
    }

    public AnnotatedMethodConfigurator<T> remove(Predicate<Annotation> annotation) {
        this.annotatedMethod.getAnnotations().removeIf(annotation);
        return this;
    }

    public AnnotatedMethodConfigurator<T> removeAll() {
        this.annotatedMethod.getAnnotations().clear();
        return this;
    }

    public List<AnnotatedParameterConfigurator<T>> params() {
        return this.annotatedParameterConfigurators;
    }
}

