/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.logger;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import org.apache.webbeans.logger.JULLoggerFactory;
import org.apache.webbeans.logger.WebBeansLoggerFactory;

public final class WebBeansLoggerFacade {
    public static final String OPENWEBBEANS_LOGGING_FACTORY_PROP = "openwebbeans.logging.factory";
    private static final WebBeansLoggerFactory FACTORY;
    static final ResourceBundle WB_BUNDLE;

    public static Logger getLogger(Class<?> clazz) {
        return FACTORY.getLogger(clazz);
    }

    public static Logger getLogger(Class<?> clazz, Locale desiredLocale) {
        return FACTORY.getLogger(clazz, desiredLocale);
    }

    public static String constructMessage(String messageKey, Object ... args) {
        MessageFormat msgFrmt = new MessageFormat(WebBeansLoggerFacade.getTokenString(messageKey), Locale.getDefault());
        String formattedString = msgFrmt.format(args);
        return formattedString;
    }

    public static String getTokenString(String messageKey) {
        String strVal;
        if (WB_BUNDLE == null) {
            throw new IllegalStateException("ResourceBundle can not be null");
        }
        try {
            strVal = WB_BUNDLE.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            strVal = null;
        }
        if (strVal == null) {
            return messageKey;
        }
        return strVal;
    }

    public static Object[] args(Object ... values) {
        return values;
    }

    static {
        WB_BUNDLE = ResourceBundle.getBundle("openwebbeans/Messages");
        String factoryClassname = System.getProperty(OPENWEBBEANS_LOGGING_FACTORY_PROP);
        WebBeansLoggerFactory factory = null;
        Exception error = null;
        if (factoryClassname != null) {
            try {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                if (classloader == null) {
                    classloader = WebBeansLoggerFacade.class.getClassLoader();
                }
                Class<?> factoryClazz = classloader.loadClass(factoryClassname);
                factory = (WebBeansLoggerFactory)factoryClazz.newInstance();
            }
            catch (Exception e) {
                error = e;
            }
        }
        FACTORY = factory != null ? factory : StreamSupport.stream(ServiceLoader.load(WebBeansLoggerFactory.class).spliterator(), false).max(Comparator.comparing(it -> Optional.ofNullable(it.getClass().getAnnotation(Priority.class)).map(Priority::value).orElse(0))).orElseGet(JULLoggerFactory::new);
        if (error != null && FACTORY.getLogger(WebBeansLoggerFacade.class).isLoggable(Level.SEVERE)) {
            FACTORY.getLogger(WebBeansLoggerFacade.class).log(Level.SEVERE, "ERROR_0028", error);
        }
    }
}

