/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class Unsafe {
    private Object unsafe;
    private Object internalUnsafe;
    private Method unsafeAllocateInstance;
    private final AtomicReference<Method> unsafeDefineClass = new AtomicReference();

    public Unsafe() {
        Class<?> unsafeClass = this.getUnsafeClass();
        this.unsafe = AccessController.doPrivileged(() -> {
            try {
                Field field = unsafeClass.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                WebBeansLoggerFacade.getLogger(Unsafe.class).info("Cannot get sun.misc.Unsafe - will use newInstance() instead!");
                return null;
            }
        });
        this.internalUnsafe = AccessController.doPrivileged(() -> {
            try {
                Field theInternalUnsafe = unsafeClass.getDeclaredField("theInternalUnsafe");
                theInternalUnsafe.setAccessible(true);
                return theInternalUnsafe.get(null).getClass();
            }
            catch (Exception notJ11OrMore) {
                return this.unsafe;
            }
        });
        if (this.unsafe != null) {
            this.unsafeAllocateInstance = AccessController.doPrivileged(() -> {
                try {
                    Method mtd = this.unsafe.getClass().getDeclaredMethod("allocateInstance", Class.class);
                    mtd.setAccessible(true);
                    return mtd;
                }
                catch (Exception e) {
                    return null;
                }
            });
            try {
                Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
                rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).setAccessible(true);
                rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class).setAccessible(true);
            }
            catch (Exception e) {
                try {
                    Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
                    Method objectFieldOffset = this.unsafe.getClass().getDeclaredMethod("objectFieldOffset", Field.class);
                    Method putBoolean = this.unsafe.getClass().getDeclaredMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
                    objectFieldOffset.setAccessible(true);
                    long accOffset = (Long)Long.class.cast(objectFieldOffset.invoke(this.unsafe, AccessibleObject.class.getDeclaredField("override")));
                    putBoolean.invoke(this.unsafe, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE), accOffset, true);
                    putBoolean.invoke(this.unsafe, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), accOffset, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes) throws ProxyGenerationException {
        Class<?> clazz = classLoader.getClass();
        AccessibleObject defineClassMethod = null;
        do {
            try {
                defineClassMethod = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (defineClassMethod == null && clazz != Object.class);
        if (defineClassMethod != null && !defineClassMethod.isAccessible()) {
            try {
                ((Method)defineClassMethod).setAccessible(true);
            }
            catch (RuntimeException re) {
                defineClassMethod = null;
            }
        }
        try {
            Class definedClass = defineClassMethod != null ? (Class)((Method)defineClassMethod).invoke(classLoader, proxyName, proxyBytes, 0, proxyBytes.length) : (Class)this.unsafeDefineClass().invoke(this.unsafe, proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null);
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (InvocationTargetException le) {
            if (LinkageError.class.isInstance(le.getCause())) {
                try {
                    return Class.forName(proxyName.replace('/', '.'), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ProxyGenerationException(le.getCause());
        }
        catch (Throwable e) {
            throw new ProxyGenerationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method unsafeDefineClass() {
        Method value = this.unsafeDefineClass.get();
        if (value == null) {
            Unsafe unsafe = this;
            synchronized (unsafe) {
                Class<?> unsafeClass = this.internalUnsafe.getClass();
                value = AccessController.doPrivileged(() -> {
                    try {
                        return unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot get Unsafe.defineClass or equivalent", e);
                    }
                });
                this.unsafeDefineClass.compareAndSet(null, value);
            }
        }
        return value;
    }

    public <T> T unsafeNewInstance(Class<T> clazz) {
        try {
            if (this.unsafeAllocateInstance != null) {
                return (T)this.unsafeAllocateInstance.invoke(this.unsafe, clazz);
            }
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException() != null ? e.getTargetException() : e;
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), throwable);
        }
    }

    private Class<?> getUnsafeClass() {
        try {
            return AccessController.doPrivileged(() -> (Class)Stream.of(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()).flatMap(classloader -> Stream.of("sun.misc.Unsafe", "jdk.internal.misc.Unsafe").flatMap(name -> {
                try {
                    return Stream.of(classloader.loadClass((String)name));
                }
                catch (ClassNotFoundException e) {
                    return Stream.empty();
                }
            })).findFirst().orElseThrow(() -> new IllegalStateException("Cannot get Unsafe")));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get Unsafe class", e);
        }
    }
}

