/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.xml.DefaultBeanArchiveInformation;
import org.apache.webbeans.xml.ElementIterator;
import org.apache.webbeans.xml.WebBeansErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanArchiveService
implements BeanArchiveService {
    public static final String WEB_INF_BEANS_XML = "WEB-INF/beans.xml";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(BeanArchiveService.class);
    private Map<String, BeanArchiveService.BeanArchiveInformation> beanArchiveInformations = new HashMap<String, BeanArchiveService.BeanArchiveInformation>();
    private UrlSet registeredBeanArchives = new UrlSet();

    public BeanArchiveService.BeanArchiveInformation getBeanArchiveInformation(URL beanArchiveUrl) {
        String beanArchiveLocation = beanArchiveUrl.toExternalForm();
        BeanArchiveService.BeanArchiveInformation bdaInfo = this.beanArchiveInformations.get(beanArchiveLocation);
        if (bdaInfo == null && !beanArchiveLocation.contains(".xml")) {
            String strippedBeanArchiveUrl = this.stripProtocol(beanArchiveLocation);
            if (strippedBeanArchiveUrl.contains(WEB_INF_BEANS_XML)) {
                strippedBeanArchiveUrl = strippedBeanArchiveUrl.replace(WEB_INF_BEANS_XML, WEB_INF_CLASSES);
            }
            for (Map.Entry<String, BeanArchiveService.BeanArchiveInformation> entry : this.beanArchiveInformations.entrySet()) {
                if (!this.stripProtocol(entry.getKey()).startsWith(strippedBeanArchiveUrl)) continue;
                bdaInfo = entry.getValue();
                break;
            }
        }
        if (bdaInfo == null) {
            bdaInfo = this.readBeansXml(beanArchiveUrl, beanArchiveLocation);
            this.beanArchiveInformations.put(beanArchiveLocation, bdaInfo);
            this.registeredBeanArchives.add(beanArchiveUrl);
        }
        return bdaInfo;
    }

    public Set<URL> getRegisteredBeanArchives() {
        return this.registeredBeanArchives;
    }

    protected DefaultBeanArchiveInformation createBeanArchiveInformation() {
        return new DefaultBeanArchiveInformation();
    }

    private BeanArchiveService.BeanArchiveInformation readBeansXml(URL beansXmlUrl, String beansXmlLocation) {
        if (beansXmlUrl == null) {
            throw new WebBeansConfigurationException("beans.xml URL must be given!");
        }
        if (!beansXmlLocation.endsWith(".xml")) {
            DefaultBeanArchiveInformation bdaInfo = this.createBeanArchiveInformation();
            bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ANNOTATED);
            return bdaInfo;
        }
        InputStream xmlStream = null;
        try {
            xmlStream = beansXmlUrl.openStream();
            BeanArchiveService.BeanArchiveInformation beanArchiveInformation = this.readBeansXml(xmlStream);
            return beanArchiveInformation;
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException("Error while parsing the beans.xml file " + beansXmlLocation, e);
        }
        finally {
            try {
                xmlStream.close();
            }
            catch (IOException ioe) {
                throw new WebBeansDeploymentException("Error while closing the input stream!", ioe);
            }
        }
    }

    protected String stripProtocol(String urlPath) {
        int pos = urlPath.lastIndexOf(":/");
        if (pos > 0) {
            return urlPath.substring(pos + 1);
        }
        return urlPath;
    }

    protected BeanArchiveService.BeanArchiveInformation readBeansXml(InputStream xmlStream) throws IOException {
        DefaultBeanArchiveInformation bdaInfo = this.createBeanArchiveInformation();
        if (xmlStream.available() > 0) {
            Element webBeansRoot = this.getBeansRootElement(xmlStream);
            if (webBeansRoot != null) {
                if (!"beans".equalsIgnoreCase(webBeansRoot.getLocalName())) {
                    throw new WebBeansConfigurationException("beans.xml must have a <beans> root element, but has: " + webBeansRoot.getLocalName());
                }
                bdaInfo.setVersion(this.getTrimmedAttribute(webBeansRoot, "version"));
                String beanDiscoveryMode = this.getTrimmedAttribute(webBeansRoot, "bean-discovery-mode");
                bdaInfo.setBeanDiscoveryMode(beanDiscoveryMode != null ? BeanArchiveService.BeanDiscoveryMode.valueOf((String)beanDiscoveryMode.toUpperCase()) : null);
                this.readBeanChildren(bdaInfo, webBeansRoot);
            }
            if (bdaInfo.getVersion() != null && !"1.0".equals(bdaInfo.getVersion()) && bdaInfo.getBeanDiscoveryMode() == null) {
                throw new WebBeansConfigurationException("beans.xml with version 1.1 and higher must declare a bean-discovery-mode!");
            }
            if (bdaInfo.getBeanDiscoveryMode() == null) {
                bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ALL);
            }
        }
        if (bdaInfo.getBeanDiscoveryMode() == null) {
            bdaInfo.setBeanDiscoveryMode(BeanArchiveService.BeanDiscoveryMode.ANNOTATED);
        }
        return bdaInfo;
    }

    private void readBeanChildren(DefaultBeanArchiveInformation bdaInfo, Element webBeansRoot) {
        ElementIterator elit = new ElementIterator(webBeansRoot);
        while (elit.hasNext()) {
            Element child = elit.next();
            if ("decorators".equalsIgnoreCase(child.getLocalName())) {
                this.fillDecorators(bdaInfo, child);
                continue;
            }
            if ("interceptors".equalsIgnoreCase(child.getLocalName())) {
                this.fillInterceptors(bdaInfo, child);
                continue;
            }
            if ("alternatives".equalsIgnoreCase(child.getLocalName())) {
                this.fillAlternatives(bdaInfo, child);
                continue;
            }
            if (!"scan".equalsIgnoreCase(child.getLocalName())) continue;
            this.fillExcludes(bdaInfo, child);
        }
    }

    private void fillDecorators(DefaultBeanArchiveInformation bdaInfo, Element decoratorsElement) {
        ElementIterator elit = new ElementIterator(decoratorsElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if (!"class".equalsIgnoreCase(child.getLocalName())) continue;
            String clazz = child.getTextContent().trim();
            if (clazz.isEmpty()) {
                throw new WebBeansConfigurationException("decorators <class> element must not be empty!");
            }
            bdaInfo.getDecorators().add(clazz);
        }
    }

    private void fillInterceptors(DefaultBeanArchiveInformation bdaInfo, Element interceptorsElement) {
        ElementIterator elit = new ElementIterator(interceptorsElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if (!"class".equalsIgnoreCase(child.getLocalName())) continue;
            String clazz = child.getTextContent().trim();
            if (clazz.isEmpty()) {
                throw new WebBeansConfigurationException("interceptors <class> element must not be empty!");
            }
            bdaInfo.getInterceptors().add(clazz);
        }
    }

    private void fillAlternatives(DefaultBeanArchiveInformation bdaInfo, Element alternativesElement) {
        ElementIterator elit = new ElementIterator(alternativesElement);
        while (elit.hasNext()) {
            Element child = elit.next();
            if ("class".equalsIgnoreCase(child.getLocalName())) {
                String clazz = child.getTextContent().trim();
                if (clazz.isEmpty()) {
                    throw new WebBeansConfigurationException("alternatives <class> element must not be empty!");
                }
                bdaInfo.getAlternativeClasses().add(clazz);
            }
            if (!"stereotype".equalsIgnoreCase(child.getLocalName())) continue;
            String stereotype = child.getTextContent().trim();
            if (stereotype.isEmpty()) {
                throw new WebBeansConfigurationException("alternatives <stereotype> element must not be empty!");
            }
            bdaInfo.getAlternativeStereotypes().add(stereotype);
        }
    }

    private void fillExcludes(DefaultBeanArchiveInformation bdaInfo, Element scanElement) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        NodeList childNodes = scanElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element child;
            Node nd = childNodes.item(i);
            if (!Element.class.isInstance(nd) || !"exclude".equalsIgnoreCase((child = (Element)Element.class.cast(nd)).getLocalName())) continue;
            String name = this.getTrimmedAttribute(child, "name");
            NodeList children = child.getChildNodes();
            boolean skip = false;
            for (int j = 0; j < children.getLength(); ++j) {
                Node ndChild = children.item(j);
                if (!Element.class.isInstance(ndChild)) continue;
                Element condition = (Element)Element.class.cast(ndChild);
                String localName = condition.getLocalName();
                if ("if-class-available".equalsIgnoreCase(localName)) {
                    if (DefaultBeanArchiveService.isClassAvailable(loader, this.getTrimmedAttribute(condition, "name"))) continue;
                    skip = true;
                    break;
                }
                if ("if-class-not-available".equalsIgnoreCase(localName)) {
                    if (!DefaultBeanArchiveService.isClassAvailable(loader, this.getTrimmedAttribute(condition, "name"))) continue;
                    skip = true;
                    break;
                }
                if (!"if-system-property ".equalsIgnoreCase(localName)) continue;
                String value = this.getTrimmedAttribute(condition, "value");
                String systProp = System.getProperty(this.getTrimmedAttribute(condition, "name"));
                if ((value != null || systProp != null) && value.equals(systProp)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            if (name.endsWith(".*")) {
                bdaInfo.addClassExclude(name.substring(0, name.length() - 2));
                continue;
            }
            if (name.endsWith(".**")) {
                bdaInfo.addPackageExclude(name.substring(0, name.length() - 3));
                continue;
            }
            bdaInfo.addClassExclude(name);
        }
    }

    private static boolean isClassAvailable(ClassLoader loader, String name) {
        try {
            loader.loadClass(name);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public void release() {
        this.beanArchiveInformations.clear();
    }

    protected Element getBeansRootElement(InputStream xmlStream) throws WebBeansException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new WebBeansErrorHandler());
            Element root = documentBuilder.parse(xmlStream).getDocumentElement();
            return root;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "FATAL_0002", e);
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString("EXCEPT_0013"), e);
        }
    }

    protected String getTrimmedAttribute(Element element, String attributeName) {
        String val = element.getAttribute(attributeName);
        if (val != null && !(val = val.trim()).isEmpty()) {
            return val;
        }
        return null;
    }
}

