/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class ClassUtil {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPERS_MAP;
    public static final Map<Class<?>, Object> DEFAULT_VALUES_MAP;
    public static final Type[] NO_TYPES;
    private static volatile Set<String> objectMethodNames;

    private ClassUtil() {
        throw new UnsupportedOperationException();
    }

    public static Class<?> getClassFromName(String name) {
        try {
            ClassLoader loader = WebBeansUtil.getCurrentClassLoader();
            Class<?> clazz = Class.forName(name, true, loader);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            try {
                ClassLoader loader = ClassUtil.class.getClassLoader();
                Class<?> clazz = Class.forName(name, true, loader);
                return clazz;
            }
            catch (ClassNotFoundException e1) {
                try {
                    ClassLoader loader = ClassLoader.getSystemClassLoader();
                    Class<?> clazz = Class.forName(name, true, loader);
                    return clazz;
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
            }
        }
    }

    public static boolean isInnerClazz(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isMemberClass();
    }

    public static boolean isSame(Type type1, Type type2) {
        if (type1 instanceof Class && ((Class)type1).isPrimitive()) {
            type1 = PRIMITIVE_TO_WRAPPERS_MAP.get(type1);
        }
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            type2 = PRIMITIVE_TO_WRAPPERS_MAP.get(type2);
        }
        return type1 == type2;
    }

    public static Class<?> getPrimitiveWrapper(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        return PRIMITIVE_TO_WRAPPERS_MAP.get(clazz);
    }

    public static Object getDefaultValue(Class<?> type) {
        return DEFAULT_VALUES_MAP.get(type);
    }

    public static Class<?> getClass(Type type) {
        return ClassUtil.getClazz(type);
    }

    public static boolean isMethodHasCheckedException(Method method) {
        Asserts.nullCheckForMethod(method);
        Class<?>[] et = method.getExceptionTypes();
        if (et.length > 0) {
            for (Class<?> type : et) {
                if (Error.class.isAssignableFrom(type) || RuntimeException.class.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object callInstanceMethod(Method method, Object instance, Object[] args) {
        Asserts.nullCheckForMethod(method);
        Asserts.assertNotNull(instance, "instance parameter can not be null");
        try {
            if (args == null) {
                args = new Object[]{};
            }
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new WebBeansException("Exception occurs in the method call with method : " + method.getName() + " in class : " + instance.getClass().getName(), e);
        }
    }

    private static Set<String> getObjectMethodNames() {
        if (objectMethodNames == null) {
            Method[] methods;
            HashSet<String> list = new HashSet<String>();
            Class<Object> clazz = Object.class;
            for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
                list.add(method.getName());
            }
            objectMethodNames = list;
        }
        return objectMethodNames;
    }

    public static List<Method> getNonPrivateMethods(Class<?> topClass, boolean excludeFinalMethods) {
        HashMap<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
        ArrayList<Method> allMethods = new ArrayList<Method>(10);
        Class<?> clazz = topClass;
        if (!clazz.isAnnotation() && clazz.isInterface()) {
            ClassUtil.addNonPrivateMethods(topClass, excludeFinalMethods, methodMap, allMethods, clazz);
            for (Class<?> parent : clazz.getInterfaces()) {
                ClassUtil.addNonPrivateMethods(topClass, excludeFinalMethods, methodMap, allMethods, parent);
            }
        } else {
            while (clazz != null) {
                ClassUtil.addNonPrivateMethods(topClass, excludeFinalMethods, methodMap, allMethods, clazz);
                clazz = clazz.getSuperclass();
            }
        }
        return allMethods;
    }

    private static void addNonPrivateMethods(Class<?> topClass, boolean excludeFinalMethods, Map<String, List<Method>> methodMap, List<Method> allMethods, Class<?> clazz) {
        ArrayList<Method> temp = new ArrayList<Method>(Arrays.asList(clazz.getMethods()));
        for (Method method : clazz.getDeclaredMethods()) {
            if (temp.contains(method)) continue;
            temp.add(method);
        }
        for (Method method : temp) {
            int modifiers;
            if (allMethods.contains(method) || method.isBridge() || Modifier.isPrivate(modifiers = method.getModifiers()) || Modifier.isStatic(modifiers) || excludeFinalMethods && Modifier.isFinal(modifiers) || "finalize".equals(method.getName()) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !clazz.getPackage().getName().equals(topClass.getPackage().getName())) continue;
            List<Method> methods = methodMap.get(method.getName());
            if (methods == null) {
                methods = new ArrayList<Method>();
                methods.add(method);
                allMethods.add(method);
                methodMap.put(method.getName(), methods);
                continue;
            }
            if (ClassUtil.isOverridden(methods, method)) continue;
            methods.add(method);
            allMethods.add(method);
        }
    }

    public static List<Method> getAbstractMethods(Class<?> clazz) {
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            return Collections.emptyList();
        }
        List<Method> methods = ClassUtil.getNonPrivateMethods(clazz, true);
        if (!methods.isEmpty()) {
            Iterator<Method> iterator = methods.iterator();
            while (iterator.hasNext()) {
                if (Modifier.isAbstract(iterator.next().getModifiers())) continue;
                iterator.remove();
            }
        }
        return methods;
    }

    public static boolean isMethodDeclared(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static boolean isOverridden(List<Method> subclassMethods, Method superclassMethod) {
        for (Method m : subclassMethods) {
            if (!ClassUtil.isOverridden(m, superclassMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectMethod(String methodName) {
        return ClassUtil.getObjectMethodNames().contains(methodName);
    }

    public static boolean isParametrizedType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof ParameterizedType;
    }

    public static boolean isWildCardType(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof WildcardType;
    }

    public static boolean isUnboundedTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof TypeVariable) {
            TypeVariable wc = (TypeVariable)type;
            Type[] upper = wc.getBounds();
            if (upper.length > 1) {
                return false;
            }
            Type arg = upper[0];
            if (!(arg instanceof Class)) {
                return false;
            }
            Class clazz = (Class)arg;
            return clazz.equals(Object.class);
        }
        return false;
    }

    public static boolean isTypeVariable(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        return type instanceof TypeVariable;
    }

    public static boolean isConcrete(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Integer modifier = clazz.getModifiers();
        return !Modifier.isAbstract(modifier) && !Modifier.isInterface(modifier);
    }

    public static boolean isClassAssignableFrom(Class<?> lhs, Class<?> rhs) {
        Asserts.assertNotNull(lhs, "lhs parameter can not be null");
        Asserts.assertNotNull(rhs, "rhs parameter can not be null");
        if (lhs.isPrimitive()) {
            lhs = ClassUtil.getPrimitiveWrapper(lhs);
        }
        if (rhs.isPrimitive()) {
            rhs = ClassUtil.getPrimitiveWrapper(rhs);
        }
        return lhs.isAssignableFrom(rhs);
    }

    public static boolean checkRequiredTypeIsWildCard(Type beanTypeArg, Type requiredTypeArg) {
        TypeVariable tvBeanTypeArg;
        Type tvBound;
        WildcardType wctRequiredTypeArg = (WildcardType)requiredTypeArg;
        Type upperBoundRequiredTypeArg = wctRequiredTypeArg.getUpperBounds()[0];
        Type[] lowerBoundRequiredTypeArgs = wctRequiredTypeArg.getLowerBounds();
        if (beanTypeArg instanceof Class) {
            Class clazzBeanTypeArg = (Class)beanTypeArg;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzBeanTypeArg)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzBeanTypeArg.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        } else if (ClassUtil.isTypeVariable(beanTypeArg) && (tvBound = (tvBeanTypeArg = (TypeVariable)beanTypeArg).getBounds()[0]) instanceof Class) {
            Class clazzTvBound = (Class)tvBound;
            if (upperBoundRequiredTypeArg instanceof Class) {
                Class clazzLowerBoundTypeArg;
                Class clazzUpperBoundTypeArg = (Class)upperBoundRequiredTypeArg;
                if (clazzUpperBoundTypeArg != Object.class && clazzTvBound != Object.class && !clazzUpperBoundTypeArg.isAssignableFrom(clazzTvBound)) {
                    return false;
                }
                if (lowerBoundRequiredTypeArgs.length > 0 && lowerBoundRequiredTypeArgs[0] instanceof Class && (clazzLowerBoundTypeArg = (Class)lowerBoundRequiredTypeArgs[0]) != Object.class && !clazzTvBound.isAssignableFrom(clazzLowerBoundTypeArg)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Type[] getActualTypeArguments(Type type) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return NO_TYPES;
    }

    public static Class<?> getClazz(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return Array.newInstance(ClassUtil.getClazz(arrayType.getGenericComponentType()), 0).getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] bounds = wildcardType.getUpperBounds();
            if (bounds.length > 1) {
                throw new WebBeansConfigurationException("Illegal use of wild card type with more than one upper bound: " + wildcardType);
            }
            if (bounds.length == 0) {
                return Object.class;
            }
            return ClassUtil.getClass(bounds[0]);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            if (typeVariable.getBounds().length > 1) {
                throw new WebBeansConfigurationException("Illegal use of type variable with more than one bound: " + typeVariable);
            }
            Type[] bounds = typeVariable.getBounds();
            if (bounds.length == 0) {
                return Object.class;
            }
            return ClassUtil.getClass(bounds[0]);
        }
        throw new WebBeansConfigurationException("Unsupported type " + type);
    }

    public static boolean checkParametrizedType(ParameterizedType pType) {
        Type[] types;
        Asserts.assertNotNull(pType, "pType argument can not be null");
        for (Type type : types = pType.getActualTypeArguments()) {
            if (type instanceof ParameterizedType) {
                return ClassUtil.checkParametrizedType((ParameterizedType)type);
            }
            if (!(type instanceof TypeVariable) && !(type instanceof WildcardType)) continue;
            return false;
        }
        return true;
    }

    public static Class<?> getRawTypeForInjectionPoint(InjectionPoint injectionPoint) {
        Class rawType = null;
        Type type = injectionPoint.getType();
        if (type instanceof Class) {
            rawType = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            rawType = (Class)pt.getRawType();
        }
        return rawType;
    }

    public static boolean isOverridden(Method subClassMethod, Method superClassMethod) {
        if (ClassUtil.isSuperClass(superClassMethod.getDeclaringClass(), subClassMethod.getDeclaringClass()) && subClassMethod.getName().equals(superClassMethod.getName()) && Arrays.equals(subClassMethod.getParameterTypes(), superClassMethod.getParameterTypes())) {
            int modifiers = superClassMethod.getModifiers();
            if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) {
                return false;
            }
            if (!Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers)) {
                Class<?> superClass = superClassMethod.getDeclaringClass();
                Class<?> subClass = subClassMethod.getDeclaringClass();
                if (!subClass.getPackage().getName().equals(superClass.getPackage().getName())) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isSuperClass(Class<?> superClass, Class<?> subClass) {
        return superClass.isAssignableFrom(subClass) && !superClass.equals(subClass);
    }

    public static boolean isRawClassEquals(Type ipType, Type apiType) {
        Class ipClass = ClassUtil.getRawPrimitiveType(ipType);
        Class apiClass = ClassUtil.getRawPrimitiveType(apiType);
        if (ipClass == null || apiClass == null) {
            return false;
        }
        return ipClass.equals(apiClass);
    }

    private static Class getRawPrimitiveType(Type type) {
        if (type instanceof Class) {
            if (((Class)type).isPrimitive()) {
                return ClassUtil.getPrimitiveWrapper((Class)type);
            }
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getRawPrimitiveType(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    static {
        HashMap<Class<Object>, Class<Void>> primitiveToWrappersMap = new HashMap<Class<Object>, Class<Void>>();
        primitiveToWrappersMap.put(Integer.TYPE, Integer.class);
        primitiveToWrappersMap.put(Float.TYPE, Float.class);
        primitiveToWrappersMap.put(Double.TYPE, Double.class);
        primitiveToWrappersMap.put(Character.TYPE, Character.class);
        primitiveToWrappersMap.put(Long.TYPE, Long.class);
        primitiveToWrappersMap.put(Byte.TYPE, Byte.class);
        primitiveToWrappersMap.put(Short.TYPE, Short.class);
        primitiveToWrappersMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrappersMap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPERS_MAP = Collections.unmodifiableMap(primitiveToWrappersMap);
        HashMap<Class<Serializable>, Serializable> defaultValuesMap = new HashMap<Class<Serializable>, Serializable>();
        defaultValuesMap.put(Integer.TYPE, Integer.valueOf(0));
        defaultValuesMap.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValuesMap.put(Double.TYPE, Double.valueOf(0.0));
        defaultValuesMap.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultValuesMap.put(Long.TYPE, Long.valueOf(0L));
        defaultValuesMap.put(Byte.TYPE, Byte.valueOf((byte)0));
        defaultValuesMap.put(Short.TYPE, Short.valueOf((short)0));
        defaultValuesMap.put(Boolean.TYPE, Boolean.FALSE);
        DEFAULT_VALUES_MAP = Collections.unmodifiableMap(defaultValuesMap);
        NO_TYPES = new Type[0];
        objectMethodNames = null;
    }
}

