/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.GenericsUtil;

abstract class AbstractAnnotated
implements Annotated {
    private final Type baseType;
    private Set<Type> typeClosures = null;
    private Set<Annotation> annotations = new HashSet<Annotation>();
    private final WebBeansContext webBeansContext;

    protected AbstractAnnotated(WebBeansContext webBeansContext, Type baseType) {
        if (webBeansContext == null) {
            throw new NullPointerException("no WebBeansContext");
        }
        if (baseType == null) {
            throw new NullPointerException("no base type");
        }
        this.baseType = baseType;
        this.webBeansContext = webBeansContext;
    }

    protected void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    protected WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected void setAnnotations(Annotation[] annotations) {
        this.annotations.clear();
        Collections.addAll(this.annotations, annotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return (T)ann;
        }
        return null;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public Set<Type> getTypeClosure() {
        if (this.typeClosures == null) {
            this.initTypeClosure();
        }
        return this.typeClosures;
    }

    protected abstract Class<?> getOwningClass();

    protected abstract Class<?> getDeclaringClass();

    private synchronized void initTypeClosure() {
        if (this.typeClosures == null) {
            this.typeClosures = this.extractTypeClojure(this.baseType);
            Set<String> ignoredInterfaces = this.webBeansContext.getOpenWebBeansConfiguration().getIgnoredInterfaces();
            if (!ignoredInterfaces.isEmpty()) {
                Iterator<Type> i = this.typeClosures.iterator();
                while (i.hasNext()) {
                    Type t = i.next();
                    if (!(t instanceof Class) || !ignoredInterfaces.contains(((Class)t).getName())) continue;
                    i.remove();
                }
            }
        }
    }

    protected Set<Type> extractTypeClojure(Type baseType) {
        return GenericsUtil.getTypeClosure(baseType, this.getOwningClass());
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        for (Annotation ann : this.annotations) {
            if (!ann.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Base Type : " + this.baseType.toString() + "," + "Type Closures : " + this.typeClosures + "," + "Annotations : " + this.annotations.toString();
    }
}

