/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.intercept.ApplicationScopedBeanIntereptorHandler;
import org.apache.webbeans.intercept.DependentScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.OpenWebBeansClassLoaderProvider;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class JavassistProxyFactory {
    private ConcurrentMap<OwbBean<?>, Class<?>> buildInBeanProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<OwbBean<?>, Class<?>> normalScopedBeanProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<OwbBean<?>, Class<?>> dependentScopedBeanProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<OwbBean<?>, Class<?>> interceptorProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<ResourceBean<?, ?>, Class<?>> resourceBeanProxyClasses = new ConcurrentHashMap();
    private ConcurrentMap<OwbBean<?>, ConcurrentMap<Class<?>, Class<?>>> ejbProxyClasses = new ConcurrentHashMap();

    public Map<OwbBean<?>, Class<?>> getInterceptorProxyClasses() {
        return this.interceptorProxyClasses;
    }

    @Deprecated
    public static JavassistProxyFactory getInstance() {
        return WebBeansContext.getInstance().getJavassistProxyFactory();
    }

    public void clear() {
        this.normalScopedBeanProxyClasses.clear();
        this.dependentScopedBeanProxyClasses.clear();
        this.interceptorProxyClasses.clear();
        this.ejbProxyClasses.clear();
    }

    public Class<?> getEjbBeanProxyClass(OwbBean<?> bean, Class<?> iface) {
        Class proxyClass = null;
        ConcurrentMap typeToProxyClassMap = (ConcurrentMap)this.ejbProxyClasses.get(bean);
        if (typeToProxyClassMap != null) {
            proxyClass = (Class)typeToProxyClassMap.get(iface);
        }
        return proxyClass;
    }

    public Class<?> getResourceBeanProxyClass(ResourceBean<?, ?> resourceBean) {
        Class<?> proxyClass = null;
        try {
            ProxyFactory fact;
            Class<?> oldClazz;
            proxyClass = (Class<?>)this.resourceBeanProxyClasses.get(resourceBean);
            if (proxyClass == null && (oldClazz = this.resourceBeanProxyClasses.putIfAbsent(resourceBean, proxyClass = this.getProxyClass(fact = this.createProxyFactory(resourceBean)))) != null) {
                return oldClazz;
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return proxyClass;
    }

    public Class<?> defineEjbBeanProxyClass(OwbBean<?> bean, Class<?> iface, ProxyFactory factory) {
        Class<?> proxyClass = null;
        ConcurrentHashMap typeToProxyClassMap = (ConcurrentHashMap)this.ejbProxyClasses.get(bean);
        if (typeToProxyClassMap == null) {
            typeToProxyClassMap = new ConcurrentHashMap();
            ConcurrentHashMap existingMap = this.ejbProxyClasses.putIfAbsent(bean, typeToProxyClassMap);
            ConcurrentHashMap concurrentHashMap = typeToProxyClassMap = existingMap != null ? existingMap : typeToProxyClassMap;
        }
        if ((proxyClass = (Class<?>)typeToProxyClassMap.get(iface)) == null) {
            proxyClass = SecurityUtil.doPrivilegedCreateClass(factory);
            typeToProxyClassMap.putIfAbsent(iface, proxyClass);
        }
        return proxyClass;
    }

    public Class<?> createAbstractDecoratorProxyClass(OwbBean<?> bean) {
        Class<?> clazz = null;
        try {
            ProxyFactory fact = this.createProxyFactory(bean);
            clazz = SecurityUtil.doPrivilegedCreateClass(fact);
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return clazz;
    }

    public Object createNormalScopedBeanProxy(OwbBean<?> bean, CreationalContext<?> creationalContext) {
        Object result = null;
        try {
            Class<?> proxyClass = (Class<?>)this.normalScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                ProxyFactory fact = this.createProxyFactory(bean);
                proxyClass = this.getProxyClass(fact);
                this.normalScopedBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            result = proxyClass.newInstance();
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                if (bean.getScope().equals(ApplicationScoped.class)) {
                    ((ProxyObject)result).setHandler((MethodHandler)new ApplicationScopedBeanIntereptorHandler(bean, creationalContext));
                } else {
                    ((ProxyObject)result).setHandler((MethodHandler)new NormalScopedBeanInterceptorHandler(bean, creationalContext));
                }
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public Object createBuildInBeanProxy(OwbBean<?> bean) {
        Object result = null;
        try {
            Class<?> proxyClass = (Class<?>)this.buildInBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                ProxyFactory fact = this.createProxyFactory(bean);
                proxyClass = this.getProxyClass(fact);
                this.buildInBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            result = proxyClass.newInstance();
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public Object createDependentScopedBeanProxy(OwbBean<?> bean, Object actualInstance, CreationalContext<?> creastionalContext) {
        Object result = null;
        List<InterceptorData> interceptors = null;
        List<Decorator<?>> decorators = null;
        InjectionTargetBean injectionTargetBean = null;
        if (bean instanceof InjectionTargetBean) {
            injectionTargetBean = (InjectionTargetBean)bean;
            interceptors = injectionTargetBean.getInterceptorStack();
            decorators = injectionTargetBean.getDecoratorStack();
        }
        if (interceptors == null && decorators == null) {
            return actualInstance;
        }
        boolean notInInterceptorClassAndLifecycle = false;
        if (interceptors != null) {
            for (InterceptorData id : interceptors) {
                if (!id.isDefinedInInterceptorClass() && id.isLifecycleInterceptor()) continue;
                notInInterceptorClassAndLifecycle = true;
                break;
            }
        }
        if (!notInInterceptorClassAndLifecycle && decorators.isEmpty()) {
            CreationalContextImpl ccImpl;
            if (creastionalContext instanceof CreationalContextImpl && (ccImpl = (CreationalContextImpl)creastionalContext).getBean() != null && ccImpl.getBean().equals(bean)) {
                ccImpl.addDependent(actualInstance, bean, actualInstance);
            }
            return actualInstance;
        }
        try {
            Class<?> proxyClass = (Class<?>)this.dependentScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                ProxyFactory fact = this.createProxyFactory(bean);
                proxyClass = this.getProxyClass(fact);
                this.dependentScopedBeanProxyClasses.putIfAbsent(bean, proxyClass);
            }
            result = proxyClass.newInstance();
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                ((ProxyObject)result).setHandler((MethodHandler)new DependentScopedBeanInterceptorHandler(bean, actualInstance, creastionalContext));
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getProxyClass(ProxyFactory factory) {
        ProxyFactory.ClassLoaderProvider classLoaderProvider = ProxyFactory.classLoaderProvider;
        Class<?> clazz = null;
        try {
            clazz = SecurityUtil.doPrivilegedCreateClass(factory);
        }
        catch (RuntimeException e) {
            if (classLoaderProvider instanceof OpenWebBeansClassLoaderProvider) {
                ((OpenWebBeansClassLoaderProvider)classLoaderProvider).useCurrentClassLoader();
            }
            clazz = SecurityUtil.doPrivilegedCreateClass(factory);
        }
        finally {
            if (classLoaderProvider instanceof OpenWebBeansClassLoaderProvider) {
                ((OpenWebBeansClassLoaderProvider)classLoaderProvider).reset();
            }
        }
        return clazz;
    }

    public ProxyFactory createProxyFactory(Bean<?> bean) throws Exception {
        Set types = bean.getTypes();
        HashSet interfaceList = new HashSet();
        Class<?> superClass = null;
        for (Type generic : types) {
            Class<?> type = ClassUtil.getClazz(generic);
            if (type.isInterface()) {
                interfaceList.add(type);
                continue;
            }
            if (superClass != null && (!superClass.isAssignableFrom(type) || type == Object.class)) continue;
            superClass = type;
        }
        if (!interfaceList.contains(Serializable.class)) {
            interfaceList.add(Serializable.class);
        }
        Class[] interfaceArray = new Class[interfaceList.size()];
        interfaceArray = interfaceList.toArray(interfaceArray);
        ProxyFactory fact = new ProxyFactory();
        fact.setInterfaces(interfaceArray);
        fact.setSuperclass(superClass);
        return fact;
    }

    public static WebBeansAnnotation createNewAnnotationProxy(Class<? extends Annotation> annotationType) {
        WebBeansAnnotation result = null;
        try {
            ProxyFactory pf = new ProxyFactory();
            pf.setInterfaces(new Class[]{annotationType, Annotation.class});
            pf.setSuperclass(WebBeansAnnotation.class);
            result = (WebBeansAnnotation)pf.create(new Class[]{Class.class}, new Object[]{annotationType});
            ((ProxyObject)result).setHandler((MethodHandler)new WebBeansAnnotation(annotationType));
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public static boolean isProxyInstance(Object o) {
        return o instanceof ProxyObject;
    }
}

