/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.util.Asserts;

public final class AnnotatedElementFactory {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(AnnotatedElementFactory.class);
    private ConcurrentMap<Class<?>, AnnotatedType<?>> annotatedTypeCache = new ConcurrentHashMap();
    private ConcurrentMap<Constructor<?>, AnnotatedConstructor<?>> annotatedConstructorCache = new ConcurrentHashMap();
    private ConcurrentMap<Method, AnnotatedMethod<?>> annotatedMethodCache = new ConcurrentHashMap();
    private ConcurrentMap<Field, AnnotatedField<?>> annotatedFieldCache = new ConcurrentHashMap();
    private WebBeansContext webBeansContext;

    @Deprecated
    public static AnnotatedElementFactory getInstance() {
        return WebBeansContext.getInstance().getAnnotatedElementFactory();
    }

    public AnnotatedElementFactory(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        AnnotatedTypeImpl<X> annotatedType;
        Asserts.assertNotNull(annotatedClass, "annotatedClass is null");
        if (this.annotatedTypeCache.containsKey(annotatedClass)) {
            annotatedType = (AnnotatedTypeImpl<X>)this.annotatedTypeCache.get(annotatedClass);
        } else {
            try {
                annotatedType = new AnnotatedTypeImpl<X>(this.webBeansContext, annotatedClass);
                AnnotatedTypeImpl<X> oldType = this.annotatedTypeCache.putIfAbsent(annotatedClass, annotatedType);
                if (oldType != null) {
                    annotatedType = oldType;
                }
            }
            catch (Exception e) {
                if (e instanceof ClassNotFoundException || e instanceof ArrayStoreException) {
                    if (this.logger.wblWillLogError()) {
                        this.logger.error("ERROR_0027", e, annotatedClass.getName(), e.getCause());
                    }
                    annotatedType = null;
                }
                throw new RuntimeException(e);
            }
            catch (NoClassDefFoundError ncdfe) {
                if (this.logger.wblWillLogError()) {
                    this.logger.error("ERROR_0027", ncdfe, annotatedClass.getName(), ncdfe.getCause());
                }
                annotatedType = null;
            }
        }
        return annotatedType;
    }

    public <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor, AnnotatedType<X> declaringClass) {
        AnnotatedConstructorImpl<X> annConstructor;
        Asserts.assertNotNull(constructor, "constructor is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedConstructorCache.containsKey(constructor)) {
            annConstructor = (AnnotatedConstructorImpl<X>)this.annotatedConstructorCache.get(constructor);
        } else {
            annConstructor = new AnnotatedConstructorImpl<X>(this.webBeansContext, constructor, declaringClass);
            AnnotatedConstructorImpl<X> old = this.annotatedConstructorCache.putIfAbsent(constructor, annConstructor);
            if (old != null) {
                annConstructor = old;
            }
        }
        return annConstructor;
    }

    public <X> AnnotatedField<X> newAnnotatedField(Field field, AnnotatedType<X> declaringClass) {
        AnnotatedFieldImpl<X> annotField;
        Asserts.assertNotNull(field, "field is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        if (this.annotatedFieldCache.containsKey(field)) {
            annotField = (AnnotatedFieldImpl<X>)this.annotatedFieldCache.get(field);
        } else {
            annotField = new AnnotatedFieldImpl<X>(this.webBeansContext, field, declaringClass);
            AnnotatedFieldImpl<X> old = this.annotatedFieldCache.putIfAbsent(field, annotField);
            if (old != null) {
                annotField = old;
            }
        }
        return annotField;
    }

    public <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, AnnotatedType<X> declaringType) {
        AnnotatedMethodImpl<X> annotMethod;
        Asserts.assertNotNull(method, "method is null");
        Asserts.assertNotNull(declaringType, "declaringType is null");
        if (this.annotatedMethodCache.containsKey(method)) {
            annotMethod = (AnnotatedMethodImpl<X>)this.annotatedMethodCache.get(method);
        } else {
            annotMethod = new AnnotatedMethodImpl<X>(this.webBeansContext, method, declaringType);
            AnnotatedMethodImpl<X> old = this.annotatedMethodCache.putIfAbsent(method, annotMethod);
            if (old != null) {
                annotMethod = old;
            }
        }
        return annotMethod;
    }

    public void clear() {
        this.annotatedTypeCache.clear();
        this.annotatedConstructorCache.clear();
        this.annotatedFieldCache.clear();
        this.annotatedMethodCache.clear();
    }
}

