/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.creational.DependentCreationalContext;
import org.apache.webbeans.inject.Injectable;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class AbstractInjectable
implements Injectable {
    protected OwbBean<?> injectionOwnerBean;
    protected CreationalContext<?> injectionOwnerCreationalContext;
    protected Member injectionMember;
    public static ThreadLocal<Object> instanceUnderInjection = new ThreadLocal();
    public static ThreadLocal<List<DependentCreationalContext<Object>>> dependentInstanceOfProducerMethods = new ThreadLocal();

    protected AbstractInjectable(OwbBean<?> injectionOwnerBean, CreationalContext<?> injectionOwnerCreationalContext) {
        this.injectionOwnerBean = injectionOwnerBean;
        this.injectionOwnerCreationalContext = injectionOwnerCreationalContext;
    }

    public <T> Object inject(InjectionPoint injectionPoint) {
        InjectionResolver instance = this.injectionOwnerBean.getWebBeansContext().getBeanManagerImpl().getInjectionResolver();
        Bean<?> injectedBean = instance.getInjectionPointBean(injectionPoint);
        if (this.isInstanceProviderInjection(injectionPoint)) {
            InstanceBean.local.set(injectionPoint);
        } else if (this.isEventProviderInjection(injectionPoint)) {
            EventBean.local.set(injectionPoint);
        }
        boolean dependentProducer = false;
        if (WebBeansUtil.isDependent(injectedBean)) {
            if (!InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(injectionPoint.getType()))) {
                InjectionPointBean.local.set(injectionPoint);
            }
            if (!injectionPoint.isTransient() && injectedBean instanceof AbstractProducerBean && this.injectionOwnerBean.isPassivationCapable()) {
                dependentProducer = true;
            }
        }
        Object injected = this.injectionOwnerBean.getWebBeansContext().getBeanManagerImpl().getInjectableReference(injectionPoint, this.injectionOwnerCreationalContext);
        if (dependentProducer && injected != null && !Serializable.class.isAssignableFrom(injected.getClass())) {
            throw new IllegalProductException("If a producer method or field of scope @Dependent returns an serializable object for injection into an injection point " + injectionPoint + " that requires a passivation capable dependency");
        }
        if (!WebBeansUtil.isStaticInjection(injectionPoint) && WebBeansUtil.isDependent(injectedBean) && instanceUnderInjection.get() != null) {
            ((CreationalContextImpl)this.injectionOwnerCreationalContext).addDependent(instanceUnderInjection.get(), injectedBean, injected);
        }
        return injected;
    }

    protected List<InjectionPoint> getInjectedPoints(Member member) {
        List<InjectionPoint> injectedFields = this.injectionOwnerBean.getInjectionPoint(member);
        return injectedFields;
    }

    private boolean isInstanceProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && Provider.class.isAssignableFrom(clazz = (Class)(pt = (ParameterizedType)type).getRawType());
    }

    private boolean isEventProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && (clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Event.class);
    }

    public OwbBean<?> getInjectionOwnerComponent() {
        return this.injectionOwnerBean;
    }
}

