/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.IBeanHasParent;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;

public abstract class AbstractOwbBean<T>
implements OwbBean<T> {
    private WebBeansLogger logger = null;
    protected String name;
    protected Annotation implScopeType;
    protected Class<? extends Annotation> scopeClass;
    protected Set<Annotation> implQualifiers = new HashSet<Annotation>();
    protected Set<Type> apiTypes = new HashSet<Type>();
    protected WebBeansType webBeansType;
    protected Class<T> returnType;
    protected Set<Annotation> stereoTypes = new HashSet<Annotation>();
    protected Set<Class<? extends Annotation>> stereoTypeClasses = null;
    protected boolean specializedBean;
    protected boolean enabled = true;
    protected boolean serializable;
    protected boolean nullable = true;
    protected Set<InjectionPoint> injectionPoints = new HashSet<InjectionPoint>();
    protected String passivatingId = null;
    private final WebBeansContext webBeansContext;

    protected AbstractOwbBean(WebBeansType webBeansType, Class<T> returnType, WebBeansContext webBeansContext) {
        this.webBeansType = webBeansType;
        this.returnType = returnType;
        this.webBeansContext = webBeansContext;
    }

    protected AbstractOwbBean(WebBeansType webBeanType, WebBeansContext webBeansContext) {
        this(webBeanType, null, webBeansContext);
    }

    @Override
    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    protected BeanManagerImpl getManager() {
        return this.webBeansContext.getBeanManagerImpl();
    }

    public T create(CreationalContext<T> creationalContext) {
        Object instance;
        try {
            InjectionTargetWrapper wrapper;
            if (!(creationalContext instanceof CreationalContextImpl)) {
                creationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, this);
            }
            if ((wrapper = this.getManager().getInjectionTargetWrapper(this)) != null) {
                instance = wrapper.produce(creationalContext);
                wrapper.inject(instance, creationalContext);
                wrapper.postConstruct(instance);
            } else {
                instance = this.createInstance(creationalContext);
                if (this instanceof AbstractInjectionTargetBean) {
                    ((AbstractInjectionTargetBean)this).afterConstructor(instance, creationalContext);
                }
            }
        }
        catch (Exception re) {
            Throwable throwable = this.getRootException(re);
            if (!(throwable instanceof RuntimeException)) {
                throw new CreationException(throwable);
            }
            throw (RuntimeException)throwable;
        }
        return instance;
    }

    private Throwable getRootException(Throwable throwable) {
        if (throwable.getCause() == null || throwable.getCause() == throwable) {
            return throwable;
        }
        return this.getRootException(throwable.getCause());
    }

    protected abstract T createInstance(CreationalContext<T> var1);

    @Override
    public T createNewInstance(CreationalContext<T> creationalContext) {
        return this.createInstance(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            InjectionTargetWrapper<T> wrapper = this.getManager().getInjectionTargetWrapper(this);
            if (wrapper != null) {
                wrapper.preDestroy(instance);
                wrapper.dispose(instance);
            } else {
                this.destroyInstance(instance, creationalContext);
            }
            creationalContext.release();
        }
        catch (Exception e) {
            this.getLogger().fatal(e, "FATAL_0001", this);
        }
    }

    protected void destroyInstance(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public void destroyCreatedInstance(T instance, CreationalContext<T> creationalContext) {
        this.destroyInstance(instance, creationalContext);
    }

    @Override
    public String getId() {
        if (!this.isEnabled() || this.returnType.equals(Object.class)) {
            return null;
        }
        if (this.passivatingId == null) {
            StringBuilder sb = new StringBuilder(this.webBeansType.toString()).append('#');
            sb.append(this.returnType).append('#');
            for (Annotation qualifier : this.implQualifiers) {
                sb.append(((Object)qualifier).toString()).append(',');
            }
            this.passivatingId = sb.toString();
        }
        return this.passivatingId;
    }

    @Override
    public boolean isPassivationCapable() {
        return false;
    }

    public Class<?> getBeanClass() {
        if (IBeanHasParent.class.isAssignableFrom(this.getClass())) {
            IBeanHasParent comp = (IBeanHasParent)((Object)this);
            return comp.getParent().getBeanClass();
        }
        return this.getReturnType();
    }

    @Override
    public Annotation getImplScopeType() {
        return this.implScopeType;
    }

    @Override
    public void setImplScopeType(Annotation scopeType) {
        this.implScopeType = scopeType;
        this.scopeClass = this.implScopeType.annotationType();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public WebBeansType getWebBeansType() {
        return this.webBeansType;
    }

    @Override
    public void addStereoType(Annotation stereoType) {
        this.stereoTypeClasses = null;
        this.stereoTypes.add(stereoType);
    }

    @Override
    public void addApiType(Class<?> apiType) {
        this.apiTypes.add(apiType);
    }

    @Override
    public Set<Annotation> getImplQualifiers() {
        return this.implQualifiers;
    }

    @Override
    public Set<Annotation> getOwbStereotypes() {
        return this.stereoTypes;
    }

    @Override
    public void addQualifier(Annotation qualifier) {
        this.implQualifiers.add(qualifier);
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            throw new UnsupportedOperationException("Component name is not null, is " + this.name);
        }
        this.name = name;
    }

    public Set<Annotation> getQualifiers() {
        return this.implQualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeClass;
    }

    public Set<Type> getTypes() {
        return this.apiTypes;
    }

    @Override
    public Class<T> getReturnType() {
        return this.returnType;
    }

    @Override
    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void setSerializable(boolean serializable) {
        this.serializable = serializable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    public void addInjectionPoint(InjectionPoint injectionPoint) {
        this.injectionPoints.add(injectionPoint);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public void setSpecializedBean(boolean specialized) {
        this.specializedBean = specialized;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    public List<InjectionPoint> getInjectionPoint(Member member) {
        ArrayList<InjectionPoint> points = new ArrayList<InjectionPoint>();
        for (InjectionPoint ip : this.injectionPoints) {
            if (!ip.getMember().equals(member)) continue;
            points.add(ip);
        }
        return points;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        if (this.stereoTypeClasses == null) {
            HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>();
            for (Annotation ann : this.stereoTypes) {
                set.add(ann.annotationType());
            }
            this.stereoTypeClasses = set;
        }
        return this.stereoTypeClasses;
    }

    public boolean isAlternative() {
        return this.webBeansContext.getAlternativesManager().isBeanHasAlternative(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Name:").append(this.getName()).append(",WebBeans Type:").append((Object)this.getWebBeansType());
        builder.append(",API Types:[");
        int size = this.getTypes().size();
        int index = 1;
        for (Type clazz : this.getTypes()) {
            if (clazz instanceof Class) {
                builder.append(((Class)clazz).getName());
            } else {
                Class rawType = (Class)((ParameterizedType)clazz).getRawType();
                builder.append(rawType.getName());
            }
            if (index < size) {
                builder.append(",");
            }
            ++index;
        }
        builder.append("],");
        builder.append("Qualifiers:[");
        size = this.getQualifiers().size();
        index = 1;
        for (Annotation ann : this.getQualifiers()) {
            builder.append(ann.annotationType().getName());
            if (index < size) {
                builder.append(",");
            }
            ++index;
        }
        builder.append("]");
        return builder.toString();
    }

    protected synchronized WebBeansLogger getLogger() {
        if (this.logger == null) {
            this.logger = WebBeansLogger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Override
    public boolean isDependent() {
        return this.getScope().equals(Dependent.class);
    }

    @Override
    public void validatePassivationDependencies() {
        if (this.isPassivationCapable() || this instanceof AbstractProducerBean) {
            Set<InjectionPoint> injectionPoints = this.getInjectionPoints();
            for (InjectionPoint injectionPoint : injectionPoints) {
                if (injectionPoint.isTransient() || this.getWebBeansContext().getWebBeansUtil().isPassivationCapableDependency(injectionPoint) || injectionPoint.getAnnotated().isAnnotationPresent(Disposes.class)) continue;
                throw new WebBeansConfigurationException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + this.toString() + " does not satisfy.");
            }
        }
    }
}

