/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.Nonbinding;
import javax.inject.Qualifier;
import javax.interceptor.InterceptorBinding;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.ArrayUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansConstants;
import org.apache.webbeans.xml.XMLAnnotationTypeManager;

public final class AnnotationUtil {
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private AnnotationUtil() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasMethodAnnotation(Method method, Class<? extends Annotation> clazz) {
        Annotation[] anns;
        for (Annotation annotation : anns = method.getDeclaredAnnotations()) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMethodParameterAnnotation(Method method, Class<? extends Annotation> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public static <X> boolean hasAnnotatedMethodParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Type[] getMethodParameterGenericTypesWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Type> list = new ArrayList<Type>();
        Type[] result = null;
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type[] genericTypes = method.getGenericParameterTypes();
        int i = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                list.add(genericTypes[i]);
                break;
            }
            ++i;
        }
        result = new Type[list.size()];
        result = list.toArray(result);
        return result;
    }

    public static Type[] getConstructorParameterGenericTypesWithGivenAnnotation(Constructor<?> constructor, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(constructor, "constructor argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Type> list = new ArrayList<Type>();
        Type[] result = null;
        Annotation[][] parameterAnns = constructor.getParameterAnnotations();
        Type[] genericTypes = constructor.getGenericParameterTypes();
        int i = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                list.add(genericTypes[i]);
                break;
            }
            ++i;
        }
        result = new Type[list.size()];
        result = list.toArray(result);
        return result;
    }

    public static boolean hasMethodMultipleParameterAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        boolean found = false;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                if (!param.annotationType().equals(clazz)) continue;
                if (!found) {
                    found = true;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    public static <X> boolean hasAnnotatedMethodMultipleParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        boolean found = false;
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            if (!found) {
                found = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public static Type getMethodFirstParameterWithAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type[] params = method.getGenericParameterTypes();
        int index = 0;
        Annotation[][] arr$ = parameterAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return params[index];
            }
            ++index;
        }
        return null;
    }

    public static <X> Type getAnnotatedMethodFirstParameterWithAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return parameter.getBaseType();
        }
        return null;
    }

    public static <X> Annotation[] getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            Annotation[] anns;
            if (!parameter.isAnnotationPresent(clazz)) continue;
            for (Annotation ann : anns = AnnotationUtil.getAnnotationsFromSet(parameter.getAnnotations())) {
                if (!AnnotationUtil.isQualifierAnnotation(ann.annotationType())) continue;
                list.add(ann);
            }
        }
        Annotation[] finalAnns = new Annotation[list.size()];
        finalAnns = list.toArray(finalAnns);
        return finalAnns;
    }

    public static Class<?> getMethodFirstParameterTypeClazzWithAnnotation(Method method, Class<? extends Annotation> clazz) {
        Type type = AnnotationUtil.getMethodFirstParameterWithAnnotation(method, clazz);
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public static Annotation[] getMethodFirstParameterQualifierWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (btype.equals(clazz)) {
                    found = true;
                    continue;
                }
                if (!AnnotationUtil.isQualifierAnnotation(btype)) continue;
                list.add(param);
            }
            if (!found) continue;
            Annotation[] result = new Annotation[list.size()];
            result = list.toArray(result);
            return result;
        }
        Annotation[] result = new Annotation[]{};
        return result;
    }

    public static Type getTypeOfParameterWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        Type result = null;
        int index = 0;
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                found = true;
                break;
            }
            if (found) {
                result = method.getGenericParameterTypes()[index];
                break;
            }
            ++index;
        }
        return result;
    }

    public static <T extends Annotation> T getMethodFirstParameterAnnotation(Method method, Class<T> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Class<? extends Annotation> btype = param.annotationType();
                if (!btype.equals(clazz)) continue;
                return (T)((Annotation)clazz.cast(param));
            }
        }
        return null;
    }

    public static <X, T extends Annotation> T getAnnotatedMethodFirstParameterAnnotation(AnnotatedMethod<X> annotatedMethod, Class<T> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod argument can not be null");
        Asserts.nullCheckForClass(clazz);
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            if (!parameter.isAnnotationPresent(clazz)) continue;
            return (T)((Annotation)clazz.cast(parameter.getAnnotation(clazz)));
        }
        return null;
    }

    public static boolean hasMethodParameterAnnotationCrossRef(Method method, Class<? extends Annotation> clazz) {
        Annotation[][] parameterAnns;
        Asserts.assertNotNull(method, "Method argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] arr$ = parameterAnns = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[i$]) {
                Annotation[] btype;
                for (Annotation b : btype = param.annotationType().getDeclaredAnnotations()) {
                    if (!b.annotationType().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isQualifierEqual(Annotation qualifier1, Annotation qualifier2) {
        Asserts.assertNotNull(qualifier1, "qualifier1 argument can not be null");
        Asserts.assertNotNull(qualifier2, "qualifier2 argument can not be null");
        Class<? extends Annotation> qualifier1AnnotationType = qualifier1.annotationType();
        if (qualifier1AnnotationType == null || !qualifier1AnnotationType.equals(qualifier2.annotationType())) {
            return false;
        }
        List<Method> bindingQualifierMethods = AnnotationUtil.getBindingQualifierMethods(qualifier1AnnotationType);
        for (Method method : bindingQualifierMethods) {
            Object value2;
            Object value1 = AnnotationUtil.callMethod(qualifier1, method);
            if (AnnotationUtil.checkEquality(value1, value2 = AnnotationUtil.callMethod(qualifier2, method))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEquality(Object value1, Object value2) {
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        Class<?> valueClass = value1.getClass();
        if (!valueClass.equals(value2.getClass())) {
            return false;
        }
        if (valueClass.isPrimitive()) {
            return value1 == value2;
        }
        if (valueClass.isArray()) {
            Class<?> arrayType = valueClass.getComponentType();
            if (arrayType.isPrimitive()) {
                if (Long.TYPE == arrayType) {
                    return Arrays.equals((long[])value1, (long[])value2);
                }
                if (Integer.TYPE == arrayType) {
                    return Arrays.equals((int[])value1, (int[])value2);
                }
                if (Short.TYPE == arrayType) {
                    return Arrays.equals((short[])value1, (short[])value2);
                }
                if (Double.TYPE == arrayType) {
                    return Arrays.equals((double[])value1, (double[])value2);
                }
                if (Float.TYPE == arrayType) {
                    return Arrays.equals((float[])value1, (float[])value2);
                }
                if (Boolean.TYPE == arrayType) {
                    return Arrays.equals((boolean[])value1, (boolean[])value2);
                }
                if (Byte.TYPE == arrayType) {
                    return Arrays.equals((byte[])value1, (byte[])value2);
                }
                if (Character.TYPE == arrayType) {
                    return Arrays.equals((char[])value1, (char[])value2);
                }
                return false;
            }
            return Arrays.equals((Object[])value1, (Object[])value2);
        }
        return value1.equals(value2);
    }

    private static Object callMethod(Object instance, Method method) {
        boolean accessible = method.isAccessible();
        try {
            if (!accessible) {
                SecurityUtil.doPrivilegedSetAccessible(method, true);
            }
            Object object = method.invoke(instance, EMPTY_OBJECT_ARRAY);
            return object;
        }
        catch (Exception e) {
            throw new WebBeansException("Exception in method call : " + method.getName(), e);
        }
        finally {
            SecurityUtil.doPrivilegedSetAccessible(method, accessible);
        }
    }

    private static List<Method> getBindingQualifierMethods(Class<? extends Annotation> qualifierAnnotationType) {
        Method[] qualifierMethods = SecurityUtil.doPrivilegedGetDeclaredMethods(qualifierAnnotationType);
        if (qualifierMethods.length > 0) {
            ArrayList<Method> bindingMethods = new ArrayList<Method>();
            for (Method qualifierMethod : qualifierMethods) {
                Annotation[] qualifierMethodAnnotations = qualifierMethod.getDeclaredAnnotations();
                if (qualifierMethodAnnotations.length > 0) {
                    boolean nonbinding = false;
                    for (Annotation qualifierMethodAnnotation : qualifierMethodAnnotations) {
                        if (!Nonbinding.class.equals(qualifierMethodAnnotation.annotationType())) continue;
                        nonbinding = true;
                        break;
                    }
                    if (nonbinding) continue;
                    bindingMethods.add(qualifierMethod);
                    continue;
                }
                bindingMethods.add(qualifierMethod);
            }
            return bindingMethods;
        }
        return Collections.emptyList();
    }

    public static Annotation[] getQualifierAnnotations(Annotation ... annotations) {
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        HashSet<Object> set = new HashSet<Object>();
        for (Annotation annot : annotations) {
            if (!AnnotationUtil.isQualifierAnnotation(annot.annotationType())) continue;
            set.add(annot);
        }
        if (set.size() == 0) {
            set.add((Object)new DefaultLiteral());
        }
        Annotation[] a = new Annotation[set.size()];
        a = set.toArray(a);
        return a;
    }

    public static Method[] getMethodsWithParameterAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] rMethod = null;
        for (Method m : methods) {
            if (!AnnotationUtil.hasMethodParameterAnnotation(m, annotation)) continue;
            list.add(m);
        }
        rMethod = new Method[list.size()];
        rMethod = list.toArray(rMethod);
        return rMethod;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        ArrayList<Method> list = new ArrayList<Method>();
        Method[] rMethod = null;
        for (Method m : methods) {
            if (!AnnotationUtil.hasMethodAnnotation(m, annotation)) continue;
            list.add(m);
        }
        rMethod = new Method[list.size()];
        rMethod = list.toArray(rMethod);
        return rMethod;
    }

    public static boolean hasClassAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotation, "Annotation argument can not be null");
        Annotation a = clazz.getAnnotation(annotation);
        return a != null;
    }

    public static boolean hasMetaAnnotation(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(Annotation[] anns, Class<? extends Annotation> annotation) {
        return AnnotationUtil.getAnnotation(anns, annotation) != null;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] anns, Class<T> annotation) {
        Asserts.assertNotNull(anns, "anns argument can not be null");
        Asserts.assertNotNull(annotation, "annotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().equals(annotation)) continue;
            return (T)annot;
        }
        return null;
    }

    public static Annotation[] getMetaAnnotations(Annotation[] anns, Class<? extends Annotation> metaAnnotation) {
        ArrayList<Annotation> annots = new ArrayList<Annotation>();
        Annotation[] result = null;
        Asserts.assertNotNull(anns, "Anns argument can not be null");
        Asserts.assertNotNull(metaAnnotation, "MetaAnnotation argument can not be null");
        for (Annotation annot : anns) {
            if (!annot.annotationType().isAnnotationPresent(metaAnnotation)) continue;
            annots.add(annot);
        }
        result = new Annotation[annots.size()];
        result = annots.toArray(result);
        return result;
    }

    public static Field[] getClazzFieldsWithGivenAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Field[] fields = SecurityUtil.doPrivilegedGetDeclaredFields(clazz);
        ArrayList<Field> list = new ArrayList<Field>();
        if (fields.length != 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(annotation)) continue;
                list.add(field);
            }
        }
        fields = new Field[list.size()];
        fields = list.toArray(fields);
        return fields;
    }

    public static void checkQualifierConditions(Annotation ... qualifierAnnots) {
        Set<Annotation> annSet = ArrayUtil.asSet(qualifierAnnots);
        if (qualifierAnnots.length != annSet.size()) {
            throw new IllegalArgumentException("Qualifier annotations can not contain duplicate qualifiers:" + qualifierAnnots);
        }
        AnnotationUtil.checkQualifierConditions(annSet);
    }

    public static void checkQualifierConditions(Set<Annotation> qualifierAnnots) {
        for (Annotation ann : qualifierAnnots) {
            AnnotationUtil.checkQualifierConditions(ann);
        }
    }

    private static void checkQualifierConditions(Annotation ann) {
        Method[] methods;
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(ann.annotationType())) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
            throw new WebBeansConfigurationException("@Qualifier : " + ann.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
        }
        if (!AnnotationUtil.isQualifierAnnotation(ann.annotationType())) {
            throw new IllegalArgumentException("Qualifier annotations must be annotated with @Qualifier");
        }
    }

    public static boolean isQualifierAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        XMLAnnotationTypeManager manager = XMLAnnotationTypeManager.getInstance();
        if (manager.hasBindingType(clazz)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Qualifier.class)) {
            return true;
        }
        return BeanManagerImpl.getManager().getAdditionalQualifiers().contains(clazz);
    }

    public static boolean hasAnyQualifier(Bean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Set qualifiers = bean.getQualifiers();
        for (Annotation ann : qualifiers) {
            if (!ann.annotationType().equals(Any.class)) continue;
            return true;
        }
        return false;
    }

    public static Annotation hasOwbInjectableResource(Annotation[] annotations) {
        for (Annotation anno : annotations) {
            for (String name : WebBeansConstants.OWB_INJECTABLE_RESOURCE_ANNOTATIONS) {
                if (!anno.annotationType().getName().equals(name)) continue;
                return anno;
            }
        }
        return null;
    }

    public static boolean isInterceptorBindingAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        XMLAnnotationTypeManager manager = XMLAnnotationTypeManager.getInstance();
        if (manager.hasInterceptorBindingType(clazz)) {
            return true;
        }
        return clazz.isAnnotationPresent(InterceptorBinding.class);
    }

    public static boolean hasInterceptorBindingMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!AnnotationUtil.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static Annotation[] getInterceptorBindingMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            Annotation[] transitives;
            if (!AnnotationUtil.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = AnnotationUtil.getTransitiveInterceptorBindings(ann.annotationType().getDeclaredAnnotations())) {
                interAnns.add(transitive);
            }
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    private static Annotation[] getTransitiveInterceptorBindings(Annotation[] anns) {
        return AnnotationUtil.getInterceptorBindingMetaAnnotations(anns);
    }

    public static Annotation[] getStereotypeMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            Annotation[] transitives;
            if (!AnnotationUtil.isStereoTypeAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = AnnotationUtil.getTransitiveStereoTypes(ann.annotationType().getDeclaredAnnotations())) {
                interAnns.add(transitive);
            }
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    private static Annotation[] getTransitiveStereoTypes(Annotation[] anns) {
        return AnnotationUtil.getStereotypeMetaAnnotations(anns);
    }

    public static boolean hasStereoTypeMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "anns parameter can not be null");
        for (Annotation ann : anns) {
            if (!AnnotationUtil.isStereoTypeAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        XMLAnnotationTypeManager manager = XMLAnnotationTypeManager.getInstance();
        if (manager.hasStereoType(clazz)) {
            return true;
        }
        return clazz.isAnnotationPresent(Stereotype.class);
    }

    public static Annotation[] getRealizesGenericAnnotations(Class<?> clazz, Annotation[] anns) {
        Annotation[] genericReliazesAnns;
        HashSet<Annotation> setAnnots = new HashSet<Annotation>();
        for (Annotation definedAnn : anns) {
            setAnnots.add(definedAnn);
        }
        for (Annotation generic : genericReliazesAnns = AnnotationUtil.getQualifierAnnotations(clazz.getSuperclass().getDeclaredAnnotations())) {
            setAnnots.remove(generic);
        }
        for (Annotation generic : genericReliazesAnns = AnnotationUtil.getQualifierAnnotations(clazz.getDeclaredAnnotations())) {
            setAnnots.add(generic);
        }
        Annotation[] annots = new Annotation[setAnnots.size()];
        annots = setAnnots.toArray(annots);
        return annots;
    }

    public static Annotation[] getAnnotationsFromSet(Set<Annotation> set) {
        if (set != null) {
            Annotation[] anns = new Annotation[set.size()];
            anns = set.toArray(anns);
            return anns;
        }
        return new Annotation[0];
    }
}

