/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;

public final class AnnotatedElementFactory {
    private ConcurrentMap<Class<?>, AnnotatedType<?>> annotatedTypeCache = new ConcurrentHashMap();
    private ConcurrentMap<Constructor<?>, AnnotatedConstructor<?>> annotatedConstructorCache = new ConcurrentHashMap();
    private ConcurrentMap<Method, AnnotatedMethod<?>> annotatedMethodCache = new ConcurrentHashMap();
    private ConcurrentMap<Field, AnnotatedField<?>> annotatedFieldCache = new ConcurrentHashMap();

    public static AnnotatedElementFactory getInstance() {
        AnnotatedElementFactory aef = (AnnotatedElementFactory)WebBeansFinder.getSingletonInstance(AnnotatedElementFactory.class.getName());
        return aef;
    }

    public <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        Asserts.assertNotNull(annotatedClass, "annotatedClass is null");
        AnnotatedTypeImpl annotatedType = null;
        if (this.annotatedTypeCache.containsKey(annotatedClass)) {
            annotatedType = (AnnotatedTypeImpl)this.annotatedTypeCache.get(annotatedClass);
        } else {
            annotatedType = new AnnotatedTypeImpl(annotatedClass);
            Field[] fields = SecurityUtil.doPrivilegedGetDeclaredFields(annotatedClass);
            Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(annotatedClass);
            Constructor<X>[] ctxs = SecurityUtil.doPrivilegedGetDeclaredConstructors(annotatedClass);
            for (Field field : fields) {
                AnnotatedFieldImpl af = new AnnotatedFieldImpl(field, annotatedType);
                annotatedType.addAnnotatedField(af);
            }
            for (AccessibleObject accessibleObject : methods) {
                AnnotatedMethodImpl am = new AnnotatedMethodImpl((Method)accessibleObject, annotatedType);
                annotatedType.addAnnotatedMethod(am);
            }
            for (AccessibleObject accessibleObject : ctxs) {
                AnnotatedConstructorImpl ac = new AnnotatedConstructorImpl(accessibleObject, annotatedType);
                annotatedType.addAnnotatedConstructor(ac);
            }
            AnnotatedTypeImpl oldType = this.annotatedTypeCache.putIfAbsent(annotatedClass, annotatedType);
            if (oldType != null) {
                annotatedType = oldType;
            }
        }
        return annotatedType;
    }

    public <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor, AnnotatedType<X> declaringClass) {
        Asserts.assertNotNull(constructor, "constructor is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        AnnotatedConstructorImpl<X> annConstructor = null;
        if (this.annotatedConstructorCache.containsKey(constructor)) {
            annConstructor = (AnnotatedConstructorImpl<X>)this.annotatedConstructorCache.get(constructor);
        } else {
            annConstructor = new AnnotatedConstructorImpl<X>(constructor, declaringClass);
            AnnotatedConstructorImpl<X> old = this.annotatedConstructorCache.putIfAbsent(constructor, annConstructor);
            if (old != null) {
                annConstructor = old;
            }
        }
        return annConstructor;
    }

    public <X> AnnotatedField<X> newAnnotatedField(Field field, AnnotatedType<X> declaringClass) {
        Asserts.assertNotNull(field, "field is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        AnnotatedFieldImpl<X> annotField = null;
        if (this.annotatedFieldCache.containsKey(field)) {
            annotField = (AnnotatedFieldImpl<X>)this.annotatedFieldCache.get(field);
        } else {
            annotField = new AnnotatedFieldImpl<X>(field, declaringClass);
            AnnotatedFieldImpl<X> old = this.annotatedFieldCache.putIfAbsent(field, annotField);
            if (old != null) {
                annotField = old;
            }
        }
        return annotField;
    }

    public <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, AnnotatedType<X> declaringType) {
        Asserts.assertNotNull(method, "method is null");
        Asserts.assertNotNull(declaringType, "declaringType is null");
        AnnotatedMethodImpl<X> annotMethod = null;
        if (this.annotatedMethodCache.containsKey(method)) {
            annotMethod = (AnnotatedMethodImpl<X>)this.annotatedMethodCache.get(method);
        } else {
            annotMethod = new AnnotatedMethodImpl<X>(method, declaringType);
            AnnotatedMethodImpl<X> old = this.annotatedMethodCache.putIfAbsent(method, annotMethod);
            if (old != null) {
                annotMethod = old;
            }
        }
        return annotMethod;
    }

    public void clear() {
        this.annotatedTypeCache.clear();
        this.annotatedConstructorCache.clear();
        this.annotatedFieldCache.clear();
        this.annotatedMethodCache.clear();
    }
}

