/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.logger;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WebBeansLogger {
    public static final Level WBL_DEBUG = Level.FINER;
    public static final Level WBL_TRACE = Level.FINE;
    public static final Level WBL_INFO = Level.INFO;
    public static final Level WBL_WARN = Level.WARNING;
    public static final Level WBL_ERROR = Level.SEVERE;
    public static final Level WBL_FATAL = Level.SEVERE;
    private Logger logger = null;
    private ResourceBundle wbBundle = ResourceBundle.getBundle("openwebbeans/Messages");
    private Class<?> caller = null;

    private WebBeansLogger() {
    }

    public static WebBeansLogger getLogger(Class<?> clazz) {
        WebBeansLogger wbLogger = new WebBeansLogger();
        wbLogger.caller = clazz;
        Logger inLogger = Logger.getLogger(clazz.getName(), "openwebbeans/Messages");
        wbLogger.setLogger(inLogger);
        return wbLogger;
    }

    public static WebBeansLogger getLogger(Class<?> clazz, Locale desiredLocale) {
        WebBeansLogger wbLogger = new WebBeansLogger();
        wbLogger.caller = clazz;
        Logger inLogger = Logger.getLogger(clazz.getName(), ResourceBundle.getBundle("openwebbeans/Messages", desiredLocale).toString());
        wbLogger.setLogger(inLogger);
        return wbLogger;
    }

    private void wblLog(Level level, String messageKey) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.caller.getName(), Thread.currentThread().getStackTrace()[4].getMethodName(), messageKey);
        }
    }

    private void wblLog(Level level, String messageKey, Object ... args) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.caller.getName(), Thread.currentThread().getStackTrace()[4].getMethodName(), messageKey, args);
        }
    }

    private void wblLog(Level level, Throwable e, String messageKey) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.caller.getName(), Thread.currentThread().getStackTrace()[4].getMethodName(), messageKey, e);
        }
    }

    private void wblLog(Level level, Throwable e, String messageKey, Object ... args) {
        if (this.logger.isLoggable(level)) {
            this.logger.logp(level, this.caller.getName(), Thread.currentThread().getStackTrace()[3].getMethodName(), this.constructMessage(messageKey, args), e);
        }
    }

    public void fatal(String messageKey) {
        this.wblLog(WBL_FATAL, messageKey);
    }

    public void fatal(String messageKey, Object ... args) {
        this.wblLog(WBL_FATAL, messageKey, args);
    }

    public void fatal(String messageKey, Throwable e) {
        this.wblLog(WBL_FATAL, e, messageKey);
    }

    public void error(Throwable e) {
        this.wblLog(WBL_ERROR, e, "");
    }

    public void error(String messageKey) {
        this.wblLog(WBL_ERROR, messageKey);
    }

    public void error(String messageKey, Object ... args) {
        this.wblLog(WBL_ERROR, messageKey, args);
    }

    public void error(String messageKey, Throwable e) {
        this.wblLog(WBL_ERROR, e, messageKey);
    }

    public void error(String messageKey, Throwable e, Object ... args) {
        this.wblLog(WBL_ERROR, e, messageKey, args);
    }

    public void warn(String messageKey) {
        this.wblLog(WBL_WARN, messageKey);
    }

    public void warn(String messageKey, Object ... args) {
        this.wblLog(WBL_WARN, messageKey, args);
    }

    public void warn(String messageKey, Throwable e) {
        this.wblLog(WBL_WARN, e, messageKey);
    }

    public void info(String messageKey) {
        this.wblLog(WBL_INFO, messageKey);
    }

    public void info(String messageKey, Object ... args) {
        this.wblLog(WBL_INFO, messageKey, args);
    }

    public void info(String messageKey, Throwable e) {
        this.wblLog(WBL_INFO, e, messageKey);
    }

    public void debug(String messageKey) {
        this.wblLog(WBL_DEBUG, messageKey);
    }

    public void debug(String messageKey, Throwable e) {
        this.wblLog(WBL_DEBUG, e, messageKey);
    }

    public void debug(String messageKey, Object ... args) {
        this.wblLog(WBL_DEBUG, messageKey, args);
    }

    public void trace(String messageKey) {
        this.wblLog(WBL_TRACE, messageKey);
    }

    public void trace(String messageKey, Object ... args) {
        this.wblLog(WBL_TRACE, messageKey, args);
    }

    public void trace(String messageKey, Throwable e) {
        this.wblLog(WBL_TRACE, e, messageKey);
    }

    private String constructMessage(String messageKey, Object ... args) {
        MessageFormat msgFrmt = new MessageFormat(this.getTokenString(messageKey), Locale.getDefault());
        String formattedString = msgFrmt.format(args);
        return formattedString;
    }

    public String getTokenString(String messageKey) {
        String strVal = null;
        if (this.wbBundle == null) {
            throw new NullPointerException("ResourceBundle can not be null");
        }
        try {
            strVal = this.wbBundle.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            strVal = null;
        }
        if (strVal == null) {
            return messageKey;
        }
        return strVal;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean wblWillLogFatal() {
        return this.logger.isLoggable(WBL_FATAL);
    }

    public boolean wblWillLogError() {
        return this.logger.isLoggable(WBL_ERROR);
    }

    public boolean wblWillLogWarn() {
        return this.logger.isLoggable(WBL_WARN);
    }

    public boolean wblWillLogInfo() {
        return this.logger.isLoggable(WBL_INFO);
    }

    public boolean wblWillLogDebug() {
        return this.logger.isLoggable(WBL_DEBUG);
    }

    public boolean wblWillLogTrace() {
        return this.logger.isLoggable(WBL_TRACE);
    }
}

