/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionType;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;

public final class InterceptorUtil {
    static OpenWebBeansEjbLCAPlugin ejbPlugin = null;
    static Class<? extends Annotation> prePassivateClass = null;
    static Class<? extends Annotation> postActivateClass = null;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorUtil.class);

    private InterceptorUtil() {
        ejbPlugin = PluginLoader.getInstance().getEjbLCAPlugin();
        if (ejbPlugin != null) {
            prePassivateClass = ejbPlugin.getPrePassivateClass();
            postActivateClass = ejbPlugin.getPostActivateClass();
        }
    }

    public static boolean isWebBeansBusinessMethod(Method method) {
        Annotation[] anns;
        Asserts.nullCheckForMethod(method);
        int modifiers = method.getModifiers();
        if (ClassUtil.isStatic(modifiers) || ClassUtil.isPrivate(modifiers) || ClassUtil.isFinal(modifiers)) {
            return false;
        }
        for (Annotation ann : anns = method.getDeclaredAnnotations()) {
            Class<? extends Annotation> annCls = ann.annotationType();
            if (!annCls.equals(Inject.class) && !annCls.equals(PreDestroy.class) && !annCls.equals(PostConstruct.class) && !annCls.equals(AroundInvoke.class) && !annCls.equals(AroundTimeout.class) && (ejbPlugin == null || !annCls.equals(prePassivateClass) && !annCls.equals(postActivateClass))) continue;
            return false;
        }
        return true;
    }

    public static Class<? extends Annotation> getInterceptorAnnotationClazz(InterceptionType type) {
        if (type.equals((Object)InterceptionType.AROUND_INVOKE)) {
            return AroundInvoke.class;
        }
        if (type.equals((Object)InterceptionType.POST_ACTIVATE)) {
            return postActivateClass;
        }
        if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
            return PostConstruct.class;
        }
        if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
            return PreDestroy.class;
        }
        if (type.equals((Object)InterceptionType.PRE_PASSIVATE)) {
            return prePassivateClass;
        }
        if (type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
            return AroundTimeout.class;
        }
        throw new WebBeansException("Undefined interceotion type");
    }

    public static <T> boolean isBusinessMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(AroundInvoke.class) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[0]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Object.class) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || ClassUtil.isStatic(method.getJavaMember().getModifiers()) || ClassUtil.isFinal(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBusinessMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, AroundInvoke.class) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Object.class) || !ClassUtil.isMethodHasException(method) || ClassUtil.isStatic(method.getModifiers()) || ClassUtil.isFinal(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isLifecycleMethodInterceptor(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            Class<?>[] params;
            if (!AnnotationUtil.hasMethodAnnotation(method, PostConstruct.class) && !AnnotationUtil.hasMethodAnnotation(method, PreDestroy.class) && !AnnotationUtil.hasMethodAnnotation(method, postActivateClass) && !AnnotationUtil.hasMethodAnnotation(method, prePassivateClass) || !ClassUtil.isMethodHasParameter(method) || (params = ClassUtil.getMethodParameterTypes(method)).length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method) || ClassUtil.isStatic(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isLifecycleMethodInterceptor(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(PostConstruct.class) && !method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(postActivateClass) && !method.isAnnotationPresent(prePassivateClass) || methodA.getParameters().isEmpty()) continue;
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[0]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class) || !ClassUtil.getReturnType(method.getJavaMember()).equals(Void.TYPE) || ClassUtil.isMethodHasCheckedException(method.getJavaMember()) || ClassUtil.isStatic(method.getJavaMember().getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static <T> void checkAnnotatedTypeInterceptorConditions(AnnotatedType<T> annotatedType) {
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            if (!methodA.isAnnotationPresent(Produces.class)) continue;
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " can not have producer methods but it has one with name : " + methodA.getJavaMember().getName());
        }
        Annotation[] anns = annotatedType.getAnnotations().toArray(new Annotation[0]);
        if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(anns)) {
            throw new WebBeansConfigurationException("Interceptor class : " + annotatedType.getJavaClass().getName() + " must have at least one @InterceptorBinding annotation");
        }
        InterceptorUtil.checkLifecycleConditions(annotatedType, anns, "Lifecycle interceptor : " + annotatedType.getJavaClass().getName() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public static void checkInterceptorConditions(Class<?> clazz) {
        Method[] methods;
        Asserts.nullCheckForClass(clazz);
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            if (!AnnotationUtil.hasMethodAnnotation(method, Produces.class)) continue;
            throw new WebBeansConfigurationException("Interceptor class : " + clazz + " can not have producer methods but it has one with name : " + method.getName());
        }
        if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(clazz.getDeclaredAnnotations())) {
            throw new WebBeansConfigurationException("WebBeans Interceptor class : " + clazz.getName() + " must have at least one @InterceptorBinding annotation");
        }
        InterceptorUtil.checkLifecycleConditions(clazz, clazz.getDeclaredAnnotations(), "Lifecycle interceptor : " + clazz.getName() + " interceptor binding type must be defined as @Target{TYPE}");
    }

    public static <T> void checkLifecycleConditions(Class<T> clazz, Annotation[] annots, String errorMessage) {
        Asserts.nullCheckForClass(clazz);
        if (InterceptorUtil.isLifecycleMethodInterceptor(clazz) && !InterceptorUtil.isBusinessMethodInterceptor(clazz)) {
            Annotation[] anns;
            for (Annotation annotation : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public static <T> void checkLifecycleConditions(AnnotatedType<T> annotatedType, Annotation[] annots, String errorMessage) {
        if (InterceptorUtil.isLifecycleMethodInterceptor(annotatedType) && !InterceptorUtil.isBusinessMethodInterceptor(annotatedType)) {
            Annotation[] anns;
            for (Annotation annotation : anns = AnnotationUtil.getInterceptorBindingMetaAnnotations(annots)) {
                Target target = annotation.annotationType().getAnnotation(Target.class);
                ElementType[] elementTypes = target.value();
                if (elementTypes.length == 1 && elementTypes[0].equals((Object)ElementType.TYPE)) continue;
                throw new WebBeansConfigurationException(errorMessage);
            }
        }
    }

    public static void checkSimpleWebBeansInterceptorConditions(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz);
        Annotation[] anns = clazz.getDeclaredAnnotations();
        boolean hasClassInterceptors = false;
        if (AnnotationUtil.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = AnnotationUtil.getStereotypeMetaAnnotations(clazz.getDeclaredAnnotations());
            for (Annotation stero : stereoTypes) {
                if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (ClassUtil.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final Simple class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz);
        for (Method method : methods) {
            int modifiers = method.getModifiers();
            if (ClassUtil.isStatic(modifiers) || ClassUtil.isPrivate(modifiers) || !ClassUtil.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Simple web bean class : " + clazz.getName() + " can not define non-static, non-private final methods. " + "Because it is annotated with at least one @InterceptorBinding");
            }
            if (!AnnotationUtil.hasInterceptorBindingMetaAnnotation(method.getDeclaredAnnotations())) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in simple web bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final. " + "Because it is annotated with at least one @InterceptorBinding");
        }
    }

    public static List<InterceptorData> getInterceptorMethods(List<InterceptorData> stack, InterceptorType type) {
        ArrayList<InterceptorData> ai = new ArrayList<InterceptorData>();
        ArrayList<InterceptorData> at = new ArrayList<InterceptorData>();
        ArrayList<InterceptorData> pa = new ArrayList<InterceptorData>();
        ArrayList<InterceptorData> pc = new ArrayList<InterceptorData>();
        ArrayList<InterceptorData> pd = new ArrayList<InterceptorData>();
        ArrayList<InterceptorData> pp = new ArrayList<InterceptorData>();
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            Method m = null;
            InterceptorData data = it.next();
            if (type.equals((Object)InterceptorType.AROUND_INVOKE)) {
                m = data.getAroundInvoke();
                if (m == null) continue;
                ai.add(data);
                continue;
            }
            if (type.equals((Object)InterceptorType.AROUND_TIMEOUT)) {
                m = data.getAroundTimeout();
                if (m == null) continue;
                at.add(data);
                continue;
            }
            if (type.equals((Object)InterceptorType.POST_ACTIVATE)) {
                m = data.getPostActivate();
                if (m == null) continue;
                pa.add(data);
                continue;
            }
            if (type.equals((Object)InterceptorType.POST_CONSTRUCT)) {
                m = data.getPostConstruct();
                if (m == null) continue;
                pc.add(data);
                continue;
            }
            if (type.equals((Object)InterceptorType.PRE_DESTROY)) {
                m = data.getPreDestroy();
                if (m == null) continue;
                pd.add(data);
                continue;
            }
            if (!type.equals((Object)InterceptorType.PRE_PASSIVATE) || (m = data.getPrePassivate()) == null) continue;
            pp.add(data);
        }
        if (type.equals((Object)InterceptorType.AROUND_INVOKE)) {
            return ai;
        }
        if (type.equals((Object)InterceptorType.AROUND_TIMEOUT)) {
            return at;
        }
        if (type.equals((Object)InterceptorType.POST_ACTIVATE)) {
            return pa;
        }
        if (type.equals((Object)InterceptorType.POST_CONSTRUCT)) {
            return pc;
        }
        if (type.equals((Object)InterceptorType.PRE_DESTROY)) {
            return pd;
        }
        if (type.equals((Object)InterceptorType.PRE_PASSIVATE)) {
            return pp;
        }
        return Collections.EMPTY_LIST;
    }

    private static boolean shouldRemoveInterceptorCommon(InterceptorData id, Method method) {
        boolean isMethodAnnotatedWithExcludeInterceptorClass = false;
        if (AnnotationUtil.hasMethodAnnotation(method, ExcludeClassInterceptors.class)) {
            isMethodAnnotatedWithExcludeInterceptorClass = true;
        }
        if (isMethodAnnotatedWithExcludeInterceptorClass && !id.isDefinedInMethod() && id.isDefinedInInterceptorClass()) {
            return true;
        }
        return id.isDefinedInMethod() && !id.getInterceptorBindingMethod().equals(method);
    }

    public static void filterCommonInterceptorStackList(List<InterceptorData> stack, Method method) {
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData data = it.next();
            if (!InterceptorUtil.shouldRemoveInterceptorCommon(data, method)) continue;
            it.remove();
        }
    }

    public static Object callAroundInvokes(InjectionTargetBean<?> bean, Object instance, CreationalContextImpl<?> creationalContext, Method proceed, Object[] arguments, List<InterceptorData> stack, InvocationContext ejbInvocationContext, Object altKey) throws Exception {
        InvocationContextImpl impl = new InvocationContextImpl(bean, instance, proceed, arguments, stack, InterceptorType.AROUND_INVOKE);
        if (ejbInvocationContext != null) {
            impl.setEJBInvocationContext(ejbInvocationContext);
        }
        if (altKey != null) {
            impl.setCcKey(altKey);
        }
        impl.setCreationalContext(creationalContext);
        return impl.proceed();
    }

    public static boolean checkInInterceptorHierarchy(Class<?> interceptorClass, Class<?> candidateClass) {
        Class<?> superClassInterceptor = interceptorClass.getSuperclass();
        if (superClassInterceptor != null && !superClassInterceptor.equals(Object.class)) {
            if (superClassInterceptor.equals(candidateClass)) {
                return true;
            }
            return InterceptorUtil.checkInInterceptorHierarchy(superClassInterceptor, candidateClass);
        }
        return false;
    }

    public static void filterOverridenLifecycleInterceptor(Class<?> beanClass, List<InterceptorData> stack) {
        ArrayList overridenInterceptors = new ArrayList();
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData overridenInterceptor;
            InterceptorData interceptorData = it.next();
            if (!interceptorData.isLifecycleInterceptor() || null == (overridenInterceptor = InterceptorUtil.getOverridenInterceptor(beanClass, interceptorData, stack))) continue;
            if (logger.wblWillLogDebug()) {
                logger.debug("REMOVING parent " + overridenInterceptor);
            }
            it.remove();
        }
        stack.removeAll(overridenInterceptors);
    }

    public static void filterOverridenAroundInvokeInterceptor(Class<?> beanClass, List<InterceptorData> stack) {
        ArrayList<InterceptorData> overridenInterceptors = new ArrayList<InterceptorData>();
        for (InterceptorData interceptorData : stack) {
            InterceptorData overridenInterceptor;
            if (interceptorData.isLifecycleInterceptor() || null == (overridenInterceptor = InterceptorUtil.getOverridenInterceptor(beanClass, interceptorData, stack))) continue;
            overridenInterceptors.add(overridenInterceptor);
            if (!logger.wblWillLogDebug()) continue;
            logger.debug("REMOVING parent " + overridenInterceptor);
        }
        stack.removeAll(overridenInterceptors);
    }

    private static InterceptorData getOverridenInterceptor(Class<?> clazz, InterceptorData interceptorData, List<InterceptorData> stack) {
        Method interceptor = interceptorData.getInterceptorMethod();
        Class<?> interceptorClass = interceptor.getDeclaringClass();
        for (InterceptorData superInterceptorData : stack) {
            if (interceptorClass.equals(superInterceptorData.getInterceptorClass())) continue;
            if (InterceptorUtil.checkInInterceptorHierarchy(interceptorClass, superInterceptorData.getInterceptorClass())) {
                Method superInterceptorMethod = superInterceptorData.getInterceptorMethod();
                Method childInterceptorMethod = ClassUtil.getDeclaredMethod(interceptorClass, superInterceptorMethod.getName(), superInterceptorMethod.getParameterTypes());
                if (null == childInterceptorMethod || !ClassUtil.isOverriden(childInterceptorMethod, superInterceptorMethod)) continue;
                if (logger.wblWillLogDebug()) {
                    logger.debug("KEEPING child " + interceptorData);
                }
                return superInterceptorData;
            }
            return InterceptorUtil.removeInheritedButOverridenInterceptor(clazz, interceptorData);
        }
        return null;
    }

    private static InterceptorData removeInheritedButOverridenInterceptor(Class<?> clazz, InterceptorData interceptorData) {
        Method interceptor = interceptorData.getInterceptorMethod();
        Class<?> declaringClass = interceptor.getDeclaringClass();
        if (InterceptorUtil.checkGivenClassIsInInterceptorList(clazz, declaringClass)) {
            return null;
        }
        if (!declaringClass.equals(clazz) && InterceptorUtil.checkInInterceptorHierarchy(clazz, declaringClass)) {
            Method found = ClassUtil.getDeclaredMethod(clazz, interceptor.getName(), interceptor.getParameterTypes());
            if (found != null) {
                if (logger.wblWillLogDebug()) {
                    logger.debug("KEEPING child " + clazz);
                }
                return interceptorData;
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                return InterceptorUtil.removeInheritedButOverridenInterceptor(superClass, interceptorData);
            }
        }
        return null;
    }

    public static boolean checkGivenClassIsInInterceptorList(Class<?> mainClass, Class<?> candidateClass) {
        if (AnnotationUtil.hasClassAnnotation(mainClass, Interceptors.class)) {
            Class[] intClasses;
            Interceptors incs = mainClass.getAnnotation(Interceptors.class);
            for (Class intClass : intClasses = incs.value()) {
                if (intClass.equals(candidateClass)) {
                    return true;
                }
                if (!InterceptorUtil.checkInInterceptorHierarchy(intClass, candidateClass)) continue;
                return true;
            }
        }
        return false;
    }
}

