/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.ApplicationScopeLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.annotation.NewLiteral;
import org.apache.webbeans.annotation.RequestedScopeLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanManagerBean;
import org.apache.webbeans.component.ConversationBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.decorator.DecoratorUtil;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.exception.inject.NullableDependencyException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.creation.InjectionTargetProducer;
import org.apache.webbeans.portable.creation.ProducerBeansProducer;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessProducerField;
import org.apache.webbeans.portable.events.generics.GProcessProducerMethod;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.SortedListHelper;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;

public final class WebBeansUtil {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansUtil.class);
    private static Boolean enforceCheckedException;
    private static Map<Class<? extends Annotation>, Boolean> isScopeTypeNormalCache;

    private WebBeansUtil() {
        throw new UnsupportedOperationException();
    }

    private static boolean isNoCheckedExceptionEnforced() {
        if (enforceCheckedException == null) {
            enforceCheckedException = Boolean.parseBoolean(OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.forceNoCheckedExceptions", "true"));
        }
        return enforceCheckedException;
    }

    public static ClassLoader getCurrentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = WebBeansUtil.class.getClassLoader();
        }
        return loader;
    }

    public static void checkGenericType(Bean<?> bean) {
        Asserts.assertNotNull(bean);
        Class clazz = bean.getBeanClass();
        if (ClassUtil.isDefinitionConstainsTypeVariables(clazz) && !bean.getScope().equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Generic type may only defined with scope @Dependent for ManagedBean class : " + clazz.getName());
        }
    }

    public static void checkProducerGenericType(Bean<?> bean, Member member) {
        Asserts.assertNotNull(bean, "Bean is null");
        Type type = null;
        if (bean instanceof ProducerMethodBean) {
            type = ((ProducerMethodBean)bean).getCreatorMethod().getGenericReturnType();
        } else if (bean instanceof ProducerFieldBean) {
            type = ((ProducerFieldBean)bean).getCreatorField().getGenericType();
        } else {
            throw new IllegalArgumentException("Bean must be Producer Field or Method Bean instance : " + bean);
        }
        String message = "Producer Field/Method Bean with name : " + member.getName() + " in bean class : " + member.getDeclaringClass().getName();
        if (WebBeansUtil.checkGenericForProducers(type, message) && !bean.getScope().equals(Dependent.class)) {
            throw new WebBeansConfigurationException(message + " scope must bee @Dependent");
        }
    }

    private static boolean checkGenericForProducers(Type type, String message) {
        boolean result = false;
        if (type instanceof TypeVariable) {
            throw new WebBeansConfigurationException(message + " return type can not be type variable");
        }
        if (ClassUtil.isParametrizedType(type)) {
            Type[] actualTypes = ClassUtil.getActualTypeArguements(type);
            if (actualTypes.length == 0) {
                throw new WebBeansConfigurationException(message + " return type must define actual type arguments or type variable");
            }
            for (Type actualType : actualTypes) {
                if (ClassUtil.isWildCardType(actualType)) {
                    throw new WebBeansConfigurationException(message + " return type can not define wildcard actual type argument");
                }
                if (!ClassUtil.isTypeVariable(actualType)) continue;
                result = true;
            }
        }
        return result;
    }

    public static void isManagedBeanClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz, "Class is null");
        int modifier = clazz.getModifiers();
        if (!ClassUtil.isStatic(modifier) && ClassUtil.isInnerClazz(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " can not be non-static inner class");
        }
        if (!ClassUtil.isConcrete(clazz) && !AnnotationUtil.hasClassAnnotation(clazz, Decorator.class)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " have to be concrete if not defines as @Decorator");
        }
        if (!WebBeansUtil.isConstructureOk(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " must define at least one Constructor");
        }
        if (Extension.class.isAssignableFrom(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class can not implement javax.enterprise.inject.spi.Extension.!");
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> intr : interfaces) {
                if (!intr.getName().equals("javax.ejb.EnterpriseBean")) continue;
                throw new WebBeansConfigurationException("Bean implementation class can not implement javax.ejb.EnterpriseBean");
            }
        }
        List<OpenWebBeansPlugin> plugins = PluginLoader.getInstance().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            try {
                plugin.isManagedBean(clazz);
            }
            catch (Exception e) {
                PluginLoader.throwsException(e);
            }
        }
    }

    public static boolean supportsJavaEeComponentInjections(Class<?> clazz) {
        List<OpenWebBeansPlugin> plugins = PluginLoader.getInstance().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            if (plugin instanceof OpenWebBeansEjbPlugin || !plugin.supportsJavaEeComponentInjections(clazz)) continue;
            return true;
        }
        return false;
    }

    public static <T> Constructor<T> defineConstructor(Class<T> clazz) throws WebBeansConfigurationException {
        Asserts.nullCheckForClass(clazz);
        Constructor<T>[] constructors = ClassUtil.getConstructors(clazz);
        return WebBeansUtil.defineConstructor(constructors, clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> defineConstructor(Constructor<T>[] constructors, Class<T> clazz) {
        void var8_11;
        Annotation[][] parameterAnns;
        Constructor<T> result = null;
        boolean inAnnotation = false;
        int j = 0;
        for (Constructor<Inject> constructor : constructors) {
            ++j;
            if (constructor.getAnnotation(Inject.class) == null) continue;
            if (inAnnotation) {
                throw new WebBeansConfigurationException("There are more than one Constructor with Initializer annotation in class " + clazz.getName());
            }
            inAnnotation = true;
            result = constructor;
        }
        if (result == null && (result = ClassUtil.isContaintNoArgConstructor(clazz)) == null) {
            throw new WebBeansConfigurationException("No constructor is found for the class : " + clazz.getName());
        }
        Annotation[][] arr$ = parameterAnns = result.getParameterAnnotations();
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_11 < len$) {
            Annotation[] parameters;
            for (Annotation param : parameters = arr$[var8_11]) {
                if (param.annotationType().equals(Disposes.class)) {
                    throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Disposes annotation in class : " + clazz.getName());
                }
                if (!param.annotationType().equals(Observes.class)) continue;
                throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Observes annotation in class : " + clazz.getName());
            }
            ++var8_11;
        }
        return result;
    }

    public static boolean isConstructureOk(Class<?> clazz) throws WebBeansConfigurationException {
        Asserts.nullCheckForClass(clazz);
        if (ClassUtil.isContaintNoArgConstructor(clazz) != null) {
            return true;
        }
        Constructor<?>[] constructors = ClassUtil.getConstructors(clazz);
        int j = 0;
        for (Constructor<?> constructor : constructors) {
            ++j;
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static void checkProducerMethodForDeployment(Method method, String parentImplClazzName) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        if (AnnotationUtil.hasMethodAnnotation(method, Inject.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Disposes.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) {
            throw new WebBeansConfigurationException("Producer Method Bean with name : " + method.getName() + " in bean class : " + parentImplClazzName + " can not be annotated with @Initializer/@Destructor annotation " + "or has a parameter annotated with @Disposes/@Observes");
        }
    }

    public static void checkProducerMethodDisposal(Method disposalMethod, String definedBeanClassName) {
        if (AnnotationUtil.hasMethodMultipleParameterAnnotation(disposalMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Disposal method : " + disposalMethod.getName() + " in class " + definedBeanClassName + " has multiple @Disposes annotation parameter");
        }
        if (AnnotationUtil.hasMethodAnnotation(disposalMethod, Inject.class) || AnnotationUtil.hasMethodParameterAnnotation(disposalMethod, Observes.class) || AnnotationUtil.hasMethodAnnotation(disposalMethod, Produces.class)) {
            throw new WebBeansConfigurationException("Disposal method : " + disposalMethod.getName() + " in the class : " + definedBeanClassName + " can not be annotated with @Initializer/@Destructor/@Produces " + "annotation or has a parameter annotated with @Observes");
        }
    }

    public static Annotation[] checkForNewQualifierForDeployment(Type type, Class<?> clazz, String name, Annotation[] annotations) {
        Asserts.assertNotNull(type, "Type argument can not be null");
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotations, "Annotations argument can not be null");
        Annotation[] as = AnnotationUtil.getQualifierAnnotations(annotations);
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(New.class) || as.length <= 1) continue;
            throw new WebBeansConfigurationException("@New binding annotation can not have any binding annotation in class : " + clazz.getName() + " in field/method : " + name);
        }
        return as;
    }

    public static boolean isScopeEncloseOther(Class<? extends Annotation> src, Class<? extends Annotation> target) {
        Asserts.assertNotNull(src, "Src argument can not be null");
        Asserts.assertNotNull(target, "Target argument can not be null");
        if (src.equals(ConversationScoped.class)) {
            return true;
        }
        if (src.equals(ApplicationScoped.class)) {
            return !target.equals(ConversationScoped.class) && !target.equals(ApplicationScoped.class);
        }
        if (src.equals(SessionScoped.class)) {
            return !target.equals(ConversationScoped.class) && !target.equals(ApplicationScoped.class) && !target.equals(SessionScoped.class);
        }
        if (src.equals(RequestScoped.class)) {
            return false;
        }
        throw new WebBeansException("Scope is not correct");
    }

    public static <T> NewBean<T> createNewComponent(Class<T> clazz, Type apiType) {
        Asserts.nullCheckForClass(clazz);
        NewBean<T> comp = null;
        if (ManagedBeanConfigurator.isManagedBean(clazz)) {
            comp = new NewBean<T>(clazz, WebBeansType.MANAGED);
            comp.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
            comp.setConstructor(WebBeansUtil.defineConstructor(clazz));
            DefinitionUtil.addConstructorInjectionPointMetaData(comp, comp.getConstructor());
            DefinitionUtil.defineInjectedFields(comp);
            DefinitionUtil.defineInjectedMethods(comp);
        } else if (EJBWebBeansConfigurator.isSessionBean(clazz)) {
            comp = new NewBean<T>(clazz, WebBeansType.ENTERPRISE);
            comp.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        } else {
            throw new WebBeansConfigurationException("@New annotation on type : " + clazz.getName() + " must defined as a simple or an enterprise web bean");
        }
        comp.addQualifier((Annotation)((Object)new NewLiteral(clazz)));
        comp.setName(null);
        if (apiType == null) {
            comp.addApiType(clazz);
        } else {
            comp.getTypes().add(apiType);
        }
        comp.addApiType(Object.class);
        return comp;
    }

    public static <T> ExtensionBean<T> createExtensionComponent(Class<T> clazz) {
        Asserts.nullCheckForClass(clazz);
        ExtensionBean<T> comp = null;
        comp = new ExtensionBean<T>(clazz);
        comp.setEnabled(true);
        DefinitionUtil.defineApiTypes(comp, clazz);
        comp.setImplScopeType((Annotation)((Object)new ApplicationScopeLiteral()));
        comp.addQualifier((Annotation)((Object)new DefaultLiteral()));
        DefinitionUtil.defineObserverMethods(comp, clazz);
        return comp;
    }

    public static <T> NewBean<T> createNewBean(AbstractInjectionTargetBean<T> bean) {
        Asserts.assertNotNull(bean, "bean argument can not be null");
        NewBean comp = null;
        comp = new NewBean(bean.getReturnType(), WebBeansType.NEW);
        comp.getTypes().addAll(bean.getTypes());
        if (bean instanceof ManagedBean) {
            comp.setConstructor(((ManagedBean)bean).getConstructor());
        }
        for (Field injectedField : bean.getInjectedFields()) {
            comp.addInjectedField(injectedField);
        }
        for (Method injectedMethod : bean.getInjectedMethods()) {
            comp.addInjectedMethod(injectedMethod);
        }
        List<InterceptorData> interceptorList = bean.getInterceptorStack();
        if (!interceptorList.isEmpty()) {
            comp.getInterceptorStack().addAll(interceptorList);
        }
        comp.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        comp.addQualifier((Annotation)((Object)new NewLiteral(bean.getBeanClass())));
        comp.setName(null);
        Set<InjectionPoint> injectionPoints = bean.getInjectionPoints();
        for (InjectionPoint injectionPoint : injectionPoints) {
            comp.addInjectionPoint(injectionPoint);
        }
        return comp;
    }

    public static BeanManagerBean getManagerBean() {
        BeanManagerBean managerComponent = new BeanManagerBean();
        managerComponent.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        managerComponent.addQualifier((Annotation)((Object)new DefaultLiteral()));
        managerComponent.addQualifier((Annotation)((Object)new AnyLiteral()));
        managerComponent.addApiType(BeanManager.class);
        managerComponent.addApiType(Object.class);
        return managerComponent;
    }

    public static <T> InstanceBean<T> getInstanceBean() {
        InstanceBean instanceBean = new InstanceBean();
        instanceBean.getTypes().add(new TypeLiteral<Instance<?>>(){}.getRawType());
        instanceBean.getTypes().add(new TypeLiteral<Provider<?>>(){}.getRawType());
        instanceBean.addApiType(Object.class);
        instanceBean.addQualifier((Annotation)((Object)new AnyLiteral()));
        instanceBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        instanceBean.setName(null);
        return instanceBean;
    }

    public static <T> EventBean<T> getEventBean() {
        EventBean eventBean = new EventBean();
        eventBean.getTypes().add(new TypeLiteral<Event<?>>(){}.getRawType());
        eventBean.addApiType(Object.class);
        eventBean.addQualifier((Annotation)((Object)new AnyLiteral()));
        eventBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        eventBean.setName(null);
        return eventBean;
    }

    public static ConversationBean getConversationBean() {
        ConversationBean conversationComp = new ConversationBean();
        conversationComp.addApiType(Conversation.class);
        conversationComp.addApiType(ConversationImpl.class);
        conversationComp.addApiType(Object.class);
        conversationComp.setImplScopeType((Annotation)((Object)new RequestedScopeLiteral()));
        conversationComp.addQualifier((Annotation)((Object)new DefaultLiteral()));
        conversationComp.addQualifier((Annotation)((Object)new AnyLiteral()));
        conversationComp.setName("javax.enterprise.context.conversation");
        WebBeansDecoratorConfig.configureDecarotors(conversationComp);
        return conversationComp;
    }

    public static InjectionPointBean getInjectionPointBean() {
        return new InjectionPointBean();
    }

    public static Method checkCommonAnnotationCriterias(Class<?> clazz, Class<? extends Annotation> commonAnnotation, boolean invocationContext) {
        Asserts.nullCheckForClass(clazz);
        Method[] methods = ClassUtil.getDeclaredMethods(clazz);
        Method result = null;
        boolean found = false;
        for (Method method : methods) {
            if (!AnnotationUtil.hasMethodAnnotation(method, commonAnnotation) || ClassUtil.isMoreThanOneMethodWithName(method.getName(), clazz)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            if (ClassUtil.isMethodHasParameter(method)) {
                Class<?>[] params = ClassUtil.getMethodParameterTypes(method);
                if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
                }
            } else if (invocationContext) {
                return null;
            }
            if (!ClassUtil.getReturnType(method).equals(Void.TYPE)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return void type");
            }
            if (WebBeansUtil.isNoCheckedExceptionEnforced() && ClassUtil.isMethodHasCheckedException(method)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not throw any checked exception");
            }
            if (!ClassUtil.isStatic(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static");
        }
        return result;
    }

    public static <T> Method checkCommonAnnotationCriterias(AnnotatedType<T> annotatedType, Class<? extends Annotation> commonAnnotation, boolean invocationContext) {
        Class clazz = annotatedType.getJavaClass();
        Method result = null;
        boolean found = false;
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod methodB = methodA;
            Method method = methodB.getJavaMember();
            if (!method.isAnnotationPresent(commonAnnotation) || ClassUtil.isMoreThanOneMethodWithName(method.getName(), clazz)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            if (methodB.getParameters().isEmpty()) {
                if (!invocationContext) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments");
                }
                List parameters = methodB.getParameters();
                ArrayList clazzParameters = new ArrayList();
                for (AnnotatedParameter parameter : parameters) {
                    clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
                }
                Class[] params = clazzParameters.toArray(new Class[0]);
                if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
                }
            } else if (invocationContext) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must take a parameter with class type javax.interceptor.InvocationContext.");
            }
            if (!ClassUtil.getReturnType(method).equals(Void.TYPE)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return void type");
            }
            if (WebBeansUtil.isNoCheckedExceptionEnforced() && ClassUtil.isMethodHasCheckedException(method)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not throw any checked exception");
            }
            if (!ClassUtil.isStatic(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static");
        }
        return result;
    }

    public static Method checkAroundInvokeAnnotationCriterias(Class<?> clazz, Class<? extends Annotation> annot) {
        Asserts.nullCheckForClass(clazz);
        Method[] methods = ClassUtil.getDeclaredMethods(clazz);
        Method result = null;
        boolean found = false;
        for (Method method : methods) {
            if (!AnnotationUtil.hasMethodAnnotation(method, annot) || ClassUtil.isMoreThanOneMethodWithName(method.getName(), clazz)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            Class<?>[] params = ClassUtil.getMethodParameterTypes(method);
            if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
            }
            if (!ClassUtil.getReturnType(method).equals(Object.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return Object type");
            }
            if (!ClassUtil.isMethodHasException(method)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must throw Exception");
            }
            if (!ClassUtil.isStatic(method.getModifiers()) && !ClassUtil.isFinal(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static or final");
        }
        return result;
    }

    public static <T> Method checkAroundInvokeAnnotationCriterias(AnnotatedType<T> annotatedType, Class<? extends Annotation> annot) {
        Method result = null;
        boolean found = false;
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(annot) || ClassUtil.isMoreThanOneMethodWithName(method.getJavaMember().getName(), annotatedType.getJavaClass())) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotation is declared more than one method in the class : " + annotatedType.getJavaClass().getName());
            }
            found = true;
            result = method.getJavaMember();
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[0]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " can not take any formal arguments other than InvocationContext");
            }
            if (!ClassUtil.getReturnType(method.getJavaMember()).equals(Object.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " must return Object type");
            }
            if (!ClassUtil.isMethodHasException(method.getJavaMember())) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " must throw Exception");
            }
            if (!ClassUtil.isStatic(method.getJavaMember().getModifiers()) && !ClassUtil.isFinal(method.getJavaMember().getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " can not be static or final");
        }
        return result;
    }

    public static void configureInterceptorMethods(Interceptor<?> webBeansInterceptor, Class<?> interceptorClass, Class<? extends Annotation> interceptorType, boolean definedInInterceptorClass, boolean definedInMethod, List<InterceptorData> stack, Method annotatedInterceptorClassMethod, boolean defineWithInterceptorBinding) {
        Constructor<?> ct;
        InterceptorDataImpl intData = null;
        Method method = null;
        if (webBeansInterceptor == null && definedInInterceptorClass && (ct = ClassUtil.isContaintNoArgConstructor(interceptorClass)) == null) {
            throw new WebBeansConfigurationException("class : " + interceptorClass.getName() + " must have no-arg constructor");
        }
        if (interceptorType.equals(AroundInvoke.class) || interceptorType.equals(AroundTimeout.class)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(interceptorClass, interceptorType);
        } else if (interceptorType.equals(PostConstruct.class)) {
            method = definedInInterceptorClass ? WebBeansUtil.checkCommonAnnotationCriterias(interceptorClass, PostConstruct.class, true) : WebBeansUtil.checkCommonAnnotationCriterias(interceptorClass, PostConstruct.class, false);
        } else if (interceptorType.equals(PreDestroy.class)) {
            method = definedInInterceptorClass ? WebBeansUtil.checkCommonAnnotationCriterias(interceptorClass, PreDestroy.class, true) : WebBeansUtil.checkCommonAnnotationCriterias(interceptorClass, PreDestroy.class, false);
        }
        if (method != null) {
            intData = new InterceptorDataImpl(defineWithInterceptorBinding);
            intData.setDefinedInInterceptorClass(definedInInterceptorClass);
            intData.setDefinedInMethod(definedInMethod);
            intData.setInterceptorBindingMethod(annotatedInterceptorClassMethod);
            intData.setWebBeansInterceptor(webBeansInterceptor);
            if (definedInInterceptorClass) {
                intData.setInterceptorClass(interceptorClass);
            }
            intData.setInterceptorMethod(method, interceptorType);
            stack.add(intData);
        }
    }

    public static <T> void configureInterceptorMethods(Interceptor<?> webBeansInterceptor, AnnotatedType<T> annotatedType, Class<? extends Annotation> annotation, boolean definedInInterceptorClass, boolean definedInMethod, List<InterceptorData> stack, Method annotatedInterceptorClassMethod) {
        InterceptorDataImpl intData = null;
        Method method = null;
        if (annotation.equals(AroundInvoke.class) || annotation.equals(AroundTimeout.class)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(annotatedType, annotation);
        } else if (annotation.equals(PostConstruct.class)) {
            method = definedInInterceptorClass ? WebBeansUtil.checkCommonAnnotationCriterias(annotatedType, PostConstruct.class, true) : WebBeansUtil.checkCommonAnnotationCriterias(annotatedType, PostConstruct.class, false);
        } else if (annotation.equals(PreDestroy.class)) {
            method = definedInInterceptorClass ? WebBeansUtil.checkCommonAnnotationCriterias(annotatedType, PreDestroy.class, true) : WebBeansUtil.checkCommonAnnotationCriterias(annotatedType, PreDestroy.class, false);
        }
        if (method != null) {
            intData = new InterceptorDataImpl(true);
            intData.setDefinedInInterceptorClass(definedInInterceptorClass);
            intData.setDefinedInMethod(definedInMethod);
            intData.setInterceptorBindingMethod(annotatedInterceptorClassMethod);
            intData.setWebBeansInterceptor(webBeansInterceptor);
            intData.setInterceptorMethod(method, annotation);
            intData.setInterceptorClass(webBeansInterceptor.getBeanClass());
            stack.add(intData);
        }
    }

    public static <T> T newInstanceForced(Class<T> clazz) throws WebBeansConfigurationException {
        Constructor<T> ct = ClassUtil.isContaintNoArgConstructor(clazz);
        if (ct == null) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " must have no-arg constructor");
        }
        if (!ct.isAccessible()) {
            SecurityUtil.doPrivilegedSetAccessible(ct, true);
        }
        try {
            return ct.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (InvocationTargetException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (InstantiationException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
    }

    public static boolean isContainsInterceptorMethod(List<InterceptorData> stack, InterceptorType type) {
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            Method m = null;
            InterceptorData data = it.next();
            if (type.equals((Object)InterceptorType.AROUND_INVOKE)) {
                m = data.getAroundInvoke();
            } else if (type.equals((Object)InterceptorType.POST_CONSTRUCT)) {
                m = data.getPostConstruct();
            } else if (type.equals((Object)InterceptorType.PRE_DESTROY)) {
                m = data.getPreDestroy();
            }
            if (m == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isComponentHasStereoType(OwbBean<?> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Set<Annotation> set = component.getOwbStereotypes();
        Annotation[] anns = new Annotation[set.size()];
        anns = set.toArray(anns);
        return AnnotationUtil.hasStereoTypeMetaAnnotation(anns);
    }

    public static Annotation[] getComponentStereoTypes(OwbBean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        if (WebBeansUtil.isComponentHasStereoType(bean)) {
            Set<Annotation> set = bean.getOwbStereotypes();
            Annotation[] anns = new Annotation[set.size()];
            anns = set.toArray(anns);
            return AnnotationUtil.getStereotypeMetaAnnotations(anns);
        }
        return new Annotation[0];
    }

    public static boolean hasNamedOnStereoTypes(OwbBean<?> bean) {
        Annotation[] types;
        for (Annotation ann : types = WebBeansUtil.getComponentStereoTypes(bean)) {
            if (!AnnotationUtil.hasClassAnnotation(ann.annotationType(), Named.class)) continue;
            return true;
        }
        return false;
    }

    public static String getManagedBeanDefaultName(String clazzName) {
        Asserts.assertNotNull(clazzName);
        if (clazzName.length() > 0) {
            StringBuffer name = new StringBuffer(clazzName);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }
        return clazzName;
    }

    public static String getProducerDefaultName(String methodName) {
        StringBuffer buffer = new StringBuffer(methodName);
        if (buffer.length() > 3 && (buffer.substring(0, 3).equals("get") || buffer.substring(0, 3).equals("set"))) {
            if (Character.isUpperCase(buffer.charAt(3))) {
                buffer.setCharAt(3, Character.toLowerCase(buffer.charAt(3)));
            }
            return buffer.substring(3);
        }
        if (buffer.length() > 2 && buffer.substring(0, 2).equals("is")) {
            if (Character.isUpperCase(buffer.charAt(2))) {
                buffer.setCharAt(2, Character.toLowerCase(buffer.charAt(2)));
            }
            return buffer.substring(2);
        }
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }

    public static void checkStereoTypeClass(Class<? extends Annotation> clazz) {
        WebBeansUtil.checkStereoTypeClass(clazz, clazz.getDeclaredAnnotations());
    }

    public static void checkStereoTypeClass(Class<? extends Annotation> clazz, Annotation ... annotations) {
        Asserts.nullCheckForClass(clazz);
        boolean scopeTypeFound = false;
        for (Annotation annotation : annotations) {
            Target target;
            ElementType[] type;
            Class<? extends Annotation> annotType = annotation.annotationType();
            if (annotType.isAnnotationPresent(NormalScope.class) || annotType.isAnnotationPresent(Scope.class)) {
                if (scopeTypeFound) {
                    throw new WebBeansConfigurationException("@StereoType annotation can not contain more than one @Scope/@NormalScope annotation");
                }
                scopeTypeFound = true;
                continue;
            }
            if (annotType.equals(Named.class)) {
                Named name = (Named)annotation;
                if (name.value().equals("")) continue;
                throw new WebBeansConfigurationException("@StereoType annotation can not define @Named annotation with value");
            }
            if (!AnnotationUtil.isInterceptorBindingAnnotation(annotType) || (type = (target = clazz.getAnnotation(Target.class)).value()).length == 1 || type[0].equals((Object)ElementType.TYPE)) continue;
            throw new WebBeansConfigurationException("Stereotype with @InterceptorBinding must be defined as @Target{TYPE}");
        }
    }

    protected static boolean isDirectlySpecializedBeanSet(Set<Bean<?>> beans) {
        ArrayList<AbstractOwbBean> beanList = new ArrayList<AbstractOwbBean>();
        for (Bean<?> bb : beans) {
            AbstractOwbBean bean = (AbstractOwbBean)bb;
            beanList.add(bean);
        }
        Collections.sort(beanList, new Comparator(){

            public int compare(Object o1, Object o2) {
                AbstractOwbBean b1 = (AbstractOwbBean)o1;
                AbstractOwbBean b2 = (AbstractOwbBean)o2;
                Class c1 = b1.getReturnType();
                Class c2 = b2.getReturnType();
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                throw new InconsistentSpecializationException(c1 + " and " + c2 + "are not assignable to each other.");
            }
        });
        for (int i = 0; i < beanList.size() - 1; ++i) {
            if (((AbstractOwbBean)beanList.get(i)).getReturnType().equals(((AbstractOwbBean)beanList.get(i + 1)).getReturnType().getSuperclass())) continue;
            return false;
        }
        return true;
    }

    public static void configureSpecializations(List<Class<?>> beanClasses) {
        for (Class<?> clazz : beanClasses) {
            WebBeansUtil.configureSpecializations(clazz, beanClasses);
        }
    }

    protected static void configureSpecializations(Class<?> specializedClass, List<Class<?>> beanClasses) {
        Asserts.nullCheckForClass(specializedClass);
        Bean<?> superBean = null;
        Bean<?> specialized = null;
        Set<Bean<?>> resolvers = WebBeansUtil.isConfiguredWebBeans(specializedClass, true);
        AlternativesManager altManager = AlternativesManager.getInstance();
        if (resolvers != null) {
            if (resolvers.isEmpty()) {
                throw new InconsistentSpecializationException("Specialized bean for class : " + specializedClass + " is not enabled in the deployment.");
            }
            specialized = resolvers.iterator().next();
            if (resolvers.size() > 1) {
                if (!WebBeansUtil.isDirectlySpecializedBeanSet(resolvers)) {
                    throw new InconsistentSpecializationException("More than one specialized bean for class : " + specializedClass + " is enabled in the deployment.");
                }
                for (Bean<?> sp : resolvers) {
                    if (sp == specialized || !((AbstractOwbBean)sp).getReturnType().isAssignableFrom(((AbstractOwbBean)specialized).getReturnType())) continue;
                    specialized = sp;
                }
            }
            Class<?> superClass = specializedClass.getSuperclass();
            resolvers = WebBeansUtil.isConfiguredWebBeans(superClass, false);
            for (Bean<?> candidates : resolvers) {
                AbstractOwbBean candidate = (AbstractOwbBean)candidates;
                if (candidate instanceof NewBean || !candidate.getReturnType().equals(superClass)) continue;
                superBean = candidates;
                break;
            }
            if (superBean != null) {
                if (beanClasses.contains(superClass) && ((AbstractOwbBean)superBean).isEnabled()) {
                    WebBeansUtil.configureSpecializations(superClass, beanClasses);
                }
                if (!AnnotationUtil.hasClassAnnotation(specializedClass, Alternative.class)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                } else if (altManager.isClassAlternative(specializedClass)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                }
                AbstractOwbBean comp = (AbstractOwbBean)specialized;
                if (comp.isSpecializedBean()) {
                    return;
                }
                if (comp.getClass() != superBean.getClass()) {
                    throw new DefinitionException("@Specialized Class : " + specializedClass.getName() + " and its super class may be the same type of bean,i.e, ManagedBean, SessionBean etc.");
                }
                if (superBean.getName() != null) {
                    if (comp.getName() != null) {
                        throw new DefinitionException("@Specialized Class : " + specializedClass.getName() + " may not explicitly declare a bean name");
                    }
                    comp.setName(superBean.getName());
                    comp.setSpecializedBean(true);
                }
                specialized.getQualifiers().addAll(superBean.getQualifiers());
            } else {
                throw new InconsistentSpecializationException("WebBean component class : " + specializedClass.getName() + " is not enabled for specialized by the " + specializedClass + " class");
            }
        }
    }

    protected static void configSpecializedProducerMethodBeans(List<ProducerMethodBean> sortedProducerBeans) {
        if (sortedProducerBeans.isEmpty()) {
            return;
        }
        AlternativesManager altManager = AlternativesManager.getInstance();
        Method superMethod = sortedProducerBeans.get(0).getCreatorMethod();
        for (int i = 1; i < sortedProducerBeans.size(); ++i) {
            ProducerMethodBean bean = sortedProducerBeans.get(i);
            ProducerMethodBean superBean = sortedProducerBeans.get(i - 1);
            Set<Annotation> qualifiers = superBean.getQualifiers();
            for (Annotation an : qualifiers) {
                bean.addQualifier(an);
            }
            boolean isSuperHasName = WebBeansUtil.configuredProducerSpecializedName(bean, bean.getCreatorMethod(), superMethod);
            if (bean.getCreatorMethod().getAnnotation(Alternative.class) == null) {
                superBean.setEnabled(false);
            } else if (altManager.isClassAlternative(bean.getBeanClass())) {
                superBean.setEnabled(false);
            }
            if (isSuperHasName) continue;
            superMethod = bean.getCreatorMethod();
        }
    }

    public static void configureProducerMethodSpecializations() {
        logger.debug("configure Specialized producer beans has started.");
        Set<Bean<?>> beans = BeanManagerImpl.getManager().getBeans();
        ArrayList<ProducerMethodBean> producerBeans = new ArrayList<ProducerMethodBean>();
        for (Bean<?> b : beans) {
            if (!(b instanceof ProducerMethodBean)) continue;
            producerBeans.add((ProducerMethodBean)b);
        }
        SortedListHelper<ProducerMethodBean> producerBeanListHelper = new SortedListHelper<ProducerMethodBean>(new ArrayList(), new Comparator<ProducerMethodBean>(){

            @Override
            public int compare(ProducerMethodBean e1, ProducerMethodBean e2) {
                if (e1.getBeanClass().isAssignableFrom(e2.getBeanClass())) {
                    return -1;
                }
                if (e1.equals(e2)) {
                    return 0;
                }
                return 1;
            }
        });
        while (true) {
            boolean bl;
            ProducerMethodBean<Object> pRight;
            ProducerMethodBean<Object> pbean = null;
            Method method = null;
            producerBeanListHelper.clear();
            for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                if (!producerMethodBean.isSpecializedBean()) continue;
                pbean = producerMethodBean;
                method = producerMethodBean.getCreatorMethod();
                producerBeanListHelper.add(producerMethodBean);
                break;
            }
            if (pbean == null) break;
            ProducerMethodBean<Object> pLeft = pRight = pbean;
            boolean pLeftContinue = true;
            boolean bl2 = true;
            while (pLeftContinue || bl) {
                bl = false;
                pLeftContinue = false;
                for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                    Method superMethod;
                    if (pLeft != null && pLeft.getBeanClass().getSuperclass().equals(producerMethodBean.getBeanClass())) {
                        superMethod = ClassUtil.getClassMethodWithTypes(producerMethodBean.getBeanClass(), method.getName(), Arrays.asList(method.getParameterTypes()));
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pLeft = producerMethodBean.isSpecializedBean() ? producerMethodBean : null;
                        } else {
                            pLeft = null;
                        }
                        if (pLeft != null) {
                            pLeftContinue = true;
                        }
                    }
                    if (pRight == null || !producerMethodBean.getBeanClass().getSuperclass().equals(pRight.getBeanClass())) continue;
                    if (!producerMethodBean.isSpecializedBean()) {
                        pRight = null;
                    } else {
                        superMethod = ClassUtil.getClassMethodWithTypes(producerMethodBean.getBeanClass(), method.getName(), Arrays.asList(method.getParameterTypes()));
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pRight = producerMethodBean;
                        } else {
                            pRight = null;
                        }
                    }
                    if (pRight == null) continue;
                    bl = true;
                }
            }
            for (ProducerMethodBean<Object> producerMethodBean : producerBeanListHelper.getList()) {
                producerBeans.remove(producerMethodBean);
            }
            WebBeansUtil.configSpecializedProducerMethodBeans(producerBeanListHelper.getList());
        }
    }

    public static Set<Bean<?>> isConfiguredWebBeans(Class<?> clazz, boolean annotate) {
        Asserts.nullCheckForClass(clazz);
        HashSet beans = new HashSet();
        Set<Bean<?>> components = BeanManagerImpl.getManager().getComponents();
        for (AbstractOwbBean abstractOwbBean : components) {
            boolean enterprise = false;
            if (abstractOwbBean instanceof EnterpriseBeanMarker) {
                enterprise = true;
            }
            if (!abstractOwbBean.getTypes().contains(clazz) && (!enterprise || !abstractOwbBean.getBeanClass().equals(clazz))) continue;
            if (annotate) {
                if (!abstractOwbBean.getReturnType().isAnnotationPresent(Specializes.class) || abstractOwbBean instanceof NewBean) continue;
                beans.add(abstractOwbBean);
                continue;
            }
            beans.add(abstractOwbBean);
        }
        return beans;
    }

    public static void checkUnproxiableApiType(Bean<?> bean, Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull("bean", "bean parameter can not be null");
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        if (WebBeansUtil.isScopeTypeNormal(scopeType)) {
            Set types = bean.getTypes();
            ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation();
            for (Type type : types) {
                Class<?> beanClass = ClassUtil.getClass(type);
                if (beanClass.isInterface() || beanClass == Object.class) continue;
                if (ClassUtil.isPrimitive(beanClass)) {
                    violationMessage.addLine("It isn't possible to use a primitive type (" + beanClass.getName(), ")");
                }
                if (ClassUtil.isArray(beanClass)) {
                    violationMessage.addLine("It isn't possible to use an array type (", beanClass.getName(), ")");
                }
                if (!violationMessage.containsViolation()) {
                    Constructor<?> cons = ClassUtil.isContaintNoArgConstructor(beanClass);
                    if (ClassUtil.isFinal(beanClass.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " is a final class! CDI doesn't allow that.");
                    }
                    if (ClassUtil.hasFinalMethod(beanClass)) {
                        violationMessage.addLine(beanClass.getName(), " has final methods! CDI doesn't allow that.");
                    }
                    if (cons == null) {
                        violationMessage.addLine(beanClass.getName(), " has no explicit no-arg constructor!", "A public or protected constructor without args is required!");
                    } else if (ClassUtil.isPrivate(cons.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " has a >private< no-arg constructor! CDI doesn't allow that.");
                    }
                }
                if (!violationMessage.containsViolation()) continue;
                InjectionExceptionUtils.throwUnproxyableResolutionException(violationMessage);
            }
        }
    }

    public static void checkNullable(Class<?> type, AbstractOwbBean<?> component) {
        Asserts.assertNotNull(type, "type parameter can not be null");
        Asserts.assertNotNull(component, "component parameter can not be null");
        if (type.isPrimitive() && component.isNullable()) {
            throw new NullableDependencyException("Injection point for primitive type resolves webbeans component with return type : " + component.getReturnType().getName() + " with nullable");
        }
    }

    public static void configureProducerSpecialization(AbstractOwbBean<?> component, Method method, Class<?> superClass) {
        Method superMethod = ClassUtil.getClassMethodWithTypes(superClass, method.getName(), Arrays.asList(method.getParameterTypes()));
        if (superMethod == null) {
            throw new WebBeansConfigurationException("Producer method specialization is failed. Method " + method.getName() + " not found in super class : " + superClass.getName());
        }
        if (!AnnotationUtil.hasAnnotation(superMethod.getAnnotations(), Produces.class)) {
            throw new WebBeansConfigurationException("Producer method specialization is failed. Method " + method.getName() + " found in super class : " + superClass.getName() + " is not annotated with @Produces");
        }
        component.setSpecializedBean(true);
    }

    public static boolean configuredProducerSpecializedName(AbstractOwbBean<?> component, Method method, Method superMethod) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Asserts.assertNotNull(method, "method parameter can not be null");
        Asserts.assertNotNull(superMethod, "superMethod parameter can not be null");
        String name = null;
        boolean hasName = false;
        if (AnnotationUtil.hasMethodAnnotation(superMethod, Named.class)) {
            Named named = superMethod.getAnnotation(Named.class);
            hasName = true;
            name = !named.value().equals("") ? named.value() : WebBeansUtil.getProducerDefaultName(superMethod.getName());
        } else {
            Annotation[] anns;
            for (Annotation ann : anns = AnnotationUtil.getStereotypeMetaAnnotations(superMethod.getAnnotations())) {
                if (!ann.annotationType().isAnnotationPresent(Stereotype.class)) continue;
                hasName = true;
                name = WebBeansUtil.getProducerDefaultName(superMethod.getName());
                break;
            }
        }
        if (hasName) {
            if (AnnotationUtil.hasMethodAnnotation(method, Named.class)) {
                throw new DefinitionException("Specialized method : " + method.getName() + " in class : " + component.getReturnType().getName() + " may not define @Named annotation");
            }
            component.setName(name);
        }
        return hasName;
    }

    public static void checkInjectedMethodParameterConditions(Method method, Class<?> clazz) {
        Asserts.assertNotNull(method, "method parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        if (AnnotationUtil.hasMethodParameterAnnotation(method, Disposes.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) {
            throw new WebBeansConfigurationException("Initializer method parameters in method : " + method.getName() + " in class : " + clazz.getName() + " can not be annotated with @Disposes or @Observers");
        }
    }

    public static void checkInterceptorResolverParams(Annotation ... interceptorBindings) {
        if (interceptorBindings == null || interceptorBindings.length == 0) {
            throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not be empty");
        }
        Annotation old = null;
        for (Annotation interceptorBinding : interceptorBindings) {
            if (!AnnotationUtil.isInterceptorBindingAnnotation(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array can not contain other annotation that is not @InterceptorBinding");
            }
            if (old == null) {
                old = interceptorBinding;
                continue;
            }
            if (((Object)old).equals(interceptorBinding)) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not define duplicate binding annotation with name : @" + old.getClass().getName());
            }
            old = interceptorBinding;
        }
    }

    public static void checkDecoratorResolverParams(Set<Type> apiTypes, Annotation ... qualifiers) {
        if (apiTypes == null || apiTypes.size() == 0) {
            throw new IllegalArgumentException("Manager.resolveDecorators() method parameter api types argument can not be empty");
        }
        Annotation old = null;
        for (Annotation qualifier : qualifiers) {
            if (!AnnotationUtil.isQualifierAnnotation(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array can not contain other annotation that is not @Qualifier");
            }
            if (old == null) {
                old = qualifier;
                continue;
            }
            if (old.annotationType().equals(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array argument can not define duplicate qualifier annotation with name : @" + old.annotationType().getName());
            }
            old = qualifier;
        }
    }

    public static boolean checkObtainsInjectionPointConditions(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        Class candidateClazz = null;
        if (type instanceof Class) {
            candidateClazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            candidateClazz = (Class)pt.getRawType();
        }
        if (!candidateClazz.isAssignableFrom(Instance.class)) {
            return false;
        }
        Class rawType = null;
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            ParameterizedType pt = (ParameterizedType)injectionPoint.getType();
            rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.isAssignableFrom(Instance.class)) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must have type javax.inject.Instance");
            }
            if (typeArgs.length != 1) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }

    public static <T> void defineInterceptor(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> injectionTargetEvent) {
        Class clazz = injectionTargetEvent.getAnnotatedType().getJavaClass();
        if (InterceptorsManager.getInstance().isInterceptorEnabled(clazz)) {
            ManagedBean<T> component = null;
            InterceptorUtil.checkInterceptorConditions(clazz);
            component = WebBeansUtil.defineManagedBean(managedBeanCreator, injectionTargetEvent);
            if (component != null) {
                WebBeansInterceptorConfig.configureInterceptorClass(component, AnnotationUtil.getInterceptorBindingMetaAnnotations(clazz.getDeclaredAnnotations()));
            }
        }
    }

    public static <T> void defineDecorator(ManagedBeanCreatorImpl<T> creator, ProcessInjectionTarget<T> processInjectionTargetEvent) {
        Class clazz = processInjectionTargetEvent.getAnnotatedType().getJavaClass();
        if (DecoratorsManager.getInstance().isDecoratorEnabled(clazz)) {
            ManagedBean<T> delegate = null;
            DecoratorUtil.checkDecoratorConditions(clazz);
            delegate = Modifier.isAbstract(clazz.getModifiers()) ? WebBeansUtil.defineAbstractDecorator(creator, processInjectionTargetEvent) : WebBeansUtil.defineManagedBean(creator, processInjectionTargetEvent);
            if (delegate != null) {
                WebBeansDecoratorConfig.configureDecoratorClass(delegate);
            } else {
                logger.trace("Unable to configure decorator with class : [{0}]", clazz);
            }
        }
    }

    public static boolean isScopeTypeNormal(Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(scopeType, "scopeType argument can not be null");
        Boolean isNormal = isScopeTypeNormalCache.get(scopeType);
        if (isNormal != null) {
            return isNormal;
        }
        if (scopeType.isAnnotationPresent(NormalScope.class)) {
            isScopeTypeNormalCache.put(scopeType, Boolean.TRUE);
            return true;
        }
        if (scopeType.isAnnotationPresent(Scope.class)) {
            isScopeTypeNormalCache.put(scopeType, Boolean.FALSE);
            return false;
        }
        List<ExternalScope> additionalScopes = BeanManagerImpl.getManager().getAdditionalScopes();
        for (ExternalScope additionalScope : additionalScopes) {
            if (!additionalScope.getScope().equals(scopeType)) continue;
            isNormal = new Boolean(additionalScope.isNormal());
            isScopeTypeNormalCache.put(scopeType, isNormal);
            return isNormal;
        }
        throw new IllegalArgumentException("scopeType argument must be annotated with @Scope or @NormalScope");
    }

    public static void checkNullInstance(Object instance, Class<?> scopeType, String errorMessage) {
        if (instance == null && !scopeType.equals(Dependent.class)) {
            throw new IllegalProductException(errorMessage);
        }
    }

    public static void checkSerializableScopeType(Class<? extends Annotation> scopeType, boolean isSerializable, String errorMessage) {
        if (BeanManagerImpl.getManager().isPassivatingScope(scopeType) && !isSerializable) {
            throw new IllegalProductException(errorMessage);
        }
    }

    public static boolean isManagedBean(AbstractOwbBean<?> component) {
        return component.getWebBeansType().equals((Object)WebBeansType.MANAGED) || component.getWebBeansType().equals((Object)WebBeansType.INTERCEPTOR) || component.getWebBeansType().equals((Object)WebBeansType.DECORATOR);
    }

    public static boolean isProducerBean(AbstractOwbBean<?> bean) {
        return bean.getWebBeansType().equals((Object)WebBeansType.PRODUCERFIELD) || bean.getWebBeansType().equals((Object)WebBeansType.PRODUCERMETHOD);
    }

    public static boolean isEnterpriseBean(AbstractOwbBean<?> bean) {
        Asserts.assertNotNull(bean, "Bean is null");
        return bean.getWebBeansType().equals((Object)WebBeansType.ENTERPRISE);
    }

    public static Bean<?> getMostSpecializedBean(BeanManager manager, Bean<?> component) {
        Set beans = manager.getBeans((Type)component.getBeanClass(), AnnotationUtil.getAnnotationsFromSet(component.getQualifiers()));
        for (Bean bean : beans) {
            Bean find = bean;
            if (find.equals(component) || !AnnotationUtil.hasClassAnnotation(find.getBeanClass(), Specializes.class)) continue;
            return WebBeansUtil.getMostSpecializedBean(manager, find);
        }
        return component;
    }

    public static <T> GProcessAnnotatedType fireProcessAnnotatedTypeEvent(AnnotatedType<T> annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = new GProcessAnnotatedType((AnnotatedType)annotatedType);
        BeanManagerImpl.getManager().fireEvent(processAnnotatedEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processAnnotatedEvent;
    }

    public static <T> GProcessInjectionTarget fireProcessInjectionTargetEvent(AbstractInjectionTargetBean<T> bean) {
        AnnotatedType annotatedType = AnnotatedElementFactory.getInstance().newAnnotatedType(bean.getReturnType());
        InjectionTargetProducer<T> injectionTarget = new InjectionTargetProducer<T>(bean);
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget((InjectionTarget<?>)injectionTarget, (AnnotatedType<?>)annotatedType);
        BeanManagerImpl.getManager().fireEvent(processInjectionTargetEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processInjectionTargetEvent;
    }

    public static <T> GProcessInjectionTarget fireProcessInjectionTargetEventForJavaEeComponents(Class<T> componentClass) {
        AnnotatedType<T> annotatedType = AnnotatedElementFactory.getInstance().newAnnotatedType(componentClass);
        InjectionTarget<T> injectionTarget = BeanManagerImpl.getManager().createInjectionTarget(annotatedType);
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        BeanManagerImpl.getManager().fireEvent(processInjectionTargetEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processInjectionTargetEvent;
    }

    public static GProcessProducer fireProcessProducerEventForMethod(ProducerMethodBean<?> producerMethod, AnnotatedMethod<?> method) {
        GProcessProducer producerEvent = new GProcessProducer((Producer<?>)new ProducerBeansProducer((AbstractProducerBean<?>)producerMethod), (AnnotatedMember<?>)method);
        BeanManagerImpl.getManager().fireEvent(producerEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return producerEvent;
    }

    public static GProcessProducer fireProcessProducerEventForField(ProducerFieldBean<?> producerField, AnnotatedField<?> field) {
        GProcessProducer producerEvent = new GProcessProducer((Producer<?>)new ProducerBeansProducer((AbstractProducerBean<?>)producerField), (AnnotatedMember<?>)field);
        BeanManagerImpl.getManager().fireEvent(producerEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return producerEvent;
    }

    public static void fireProcessProducerMethodBeanEvent(Map<ProducerMethodBean<?>, AnnotatedMethod<?>> annotatedMethods, AnnotatedType<?> annotatedType) {
        for (ProducerMethodBean<?> bean : annotatedMethods.keySet()) {
            AnnotatedMethod<?> annotatedMethod = annotatedMethods.get(bean);
            Method disposal = WebBeansAnnotatedTypeUtil.getDisposalWithGivenAnnotatedMethod(annotatedType, bean.getReturnType(), AnnotationUtil.getAnnotationsFromSet(bean.getQualifiers()));
            AnnotatedMethod<?> disposalAnnotated = null;
            GProcessProducerMethod processProducerMethodEvent = null;
            if (disposal != null) {
                disposalAnnotated = AnnotatedElementFactory.getInstance().newAnnotatedMethod(disposal, annotatedType);
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, (AnnotatedParameter)disposalAnnotated.getParameters().get(0));
            } else {
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, null);
            }
            BeanManagerImpl.getManager().fireEvent(processProducerMethodEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public static void fireProcessObservableMethodBeanEvent(Map<ObserverMethod<?>, AnnotatedMethod<?>> annotatedMethods) {
        for (ObserverMethod<?> observableMethod : annotatedMethods.keySet()) {
            AnnotatedMethod<?> annotatedMethod = annotatedMethods.get(observableMethod);
            GProcessObservableMethod event = new GProcessObservableMethod(annotatedMethod, observableMethod);
            BeanManagerImpl.getManager().fireEvent(event, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public static void fireProcessProducerFieldBeanEvent(Map<ProducerFieldBean<?>, AnnotatedField<?>> annotatedFields) {
        for (ProducerFieldBean<?> bean : annotatedFields.keySet()) {
            AnnotatedField<?> field = annotatedFields.get(bean);
            GProcessProducerField processProducerFieldEvent = new GProcessProducerField(bean, field);
            BeanManagerImpl.getManager().fireEvent(processProducerFieldEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public static boolean isBeanHasEnterpriseMarker(Object beanInstance) {
        Asserts.assertNotNull(beanInstance, "Bean instance is null");
        return beanInstance instanceof EnterpriseBeanMarker;
    }

    public static void checkInjectionPointNamedQualifier(InjectionPoint injectionPoint) {
        Member member;
        String value;
        Set qualifierset = injectionPoint.getQualifiers();
        Named namedQualifier = null;
        for (Annotation qualifier : qualifierset) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            namedQualifier = (Named)qualifier;
            break;
        }
        if (namedQualifier != null && ((value = namedQualifier.value()) == null || value.equals("")) && !((member = injectionPoint.getMember()) instanceof Field)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define @Named qualifier without value!");
        }
    }

    public static void setInjectionTargetBeanEnableFlag(InjectionTargetBean<?> bean) {
        Asserts.assertNotNull(bean, "bean can not be null");
        if (WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(bean) && !AlternativesManager.getInstance().isBeanHasAlternative(bean)) {
            bean.setEnabled(false);
        }
    }

    public static boolean hasInjectionTargetBeanAnnotatedWithAlternative(InjectionTargetBean<?> bean) {
        Asserts.assertNotNull(bean, "bean can not be null");
        boolean alternative = false;
        if (AnnotationUtil.hasClassAnnotation(bean.getBeanClass(), Alternative.class)) {
            alternative = true;
        }
        if (!alternative) {
            Set stereotypes = bean.getStereotypes();
            for (Class stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        return alternative;
    }

    public static void setBeanEnableFlagForProducerBean(InjectionTargetBean<?> parent, AbstractProducerBean<?> producer, Annotation[] annotations) {
        Asserts.assertNotNull(parent, "parent can not be null");
        Asserts.assertNotNull(producer, "producer can not be null");
        boolean alternative = false;
        if (AnnotationUtil.hasAnnotation(annotations, Alternative.class)) {
            alternative = true;
        }
        if (!alternative) {
            Set<Class<Annotation>> stereotypes = producer.getStereotypes();
            for (Class<Annotation> stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        if (alternative) {
            if (WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(parent) && AlternativesManager.getInstance().isBeanHasAlternative(parent)) {
                producer.setEnabled(true);
            } else {
                producer.setEnabled(false);
            }
        } else {
            producer.setEnabled(parent.isEnabled());
        }
    }

    public static boolean isExtensionEventType(Class<?> clazz) {
        return clazz.equals(BeforeBeanDiscovery.class) || clazz.equals(AfterBeanDiscovery.class) || clazz.equals(AfterDeploymentValidation.class) || clazz.equals(BeforeShutdown.class) || clazz.equals(GProcessAnnotatedType.class) || clazz.equals(GProcessInjectionTarget.class) || clazz.equals(GProcessProducer.class) || clazz.equals(GProcessProducerField.class) || clazz.equals(GProcessProducerMethod.class) || clazz.equals(GProcessManagedBean.class) || clazz.equals(GProcessBean.class) || clazz.equals(GProcessSessionBean.class) || clazz.equals(GProcessObservableMethod.class);
    }

    public static boolean isExtensionBeanEventType(Class<?> clazz) {
        return clazz.equals(GProcessAnnotatedType.class) || clazz.equals(GProcessInjectionTarget.class) || clazz.equals(GProcessManagedBean.class) || clazz.equals(GProcessSessionBean.class) || clazz.equals(GProcessBean.class);
    }

    public static boolean isDefaultExtensionBeanEventType(Class<?> clazz) {
        return clazz.equals(ProcessAnnotatedType.class) || clazz.equals(ProcessInjectionTarget.class) || clazz.equals(ProcessManagedBean.class) || clazz.equals(ProcessBean.class) || clazz.equals(ProcessSessionBean.class);
    }

    public static boolean isExtensionProducerOrObserverEventType(Class<?> clazz) {
        return clazz.equals(GProcessProducer.class) || clazz.equals(GProcessProducerField.class) || clazz.equals(GProcessProducerMethod.class) || clazz.equals(GProcessObservableMethod.class);
    }

    public static boolean isDefaultExtensionProducerOrObserverEventType(Class<?> clazz) {
        return clazz.equals(ProcessProducer.class) || clazz.equals(ProcessProducerField.class) || clazz.equals(ProcessProducerMethod.class) || clazz.equals(ProcessObserverMethod.class);
    }

    public static boolean isDependent(Bean<?> bean) {
        if (!(bean instanceof OwbBean)) {
            return bean.getScope().equals(Dependent.class);
        }
        return ((OwbBean)bean).isDependent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inspectErrorStack(String logMessage) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        ErrorStack stack = manager.getErrorStack();
        try {
            if (stack.hasErrors()) {
                stack.logErrors();
                throw new WebBeansConfigurationException(logMessage);
            }
        }
        finally {
            stack.clear();
        }
    }

    public static String isPassivationCapable(Contextual<?> contextual) {
        if (contextual instanceof Bean) {
            if (contextual instanceof AbstractOwbBean) {
                if (((AbstractOwbBean)contextual).isPassivationCapable()) {
                    return ((AbstractOwbBean)contextual).getId();
                }
            } else if (contextual instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)contextual;
                return pc.getId();
            }
        } else if (contextual instanceof PassivationCapable && contextual instanceof Serializable) {
            PassivationCapable pc = (PassivationCapable)contextual;
            return pc.getId();
        }
        return null;
    }

    public static <T> ManagedBean<T> defineAbstractDecorator(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> processInjectionTargetEvent) {
        ManagedBean<?> bean = WebBeansUtil.defineManagedBean(managedBeanCreator, processInjectionTargetEvent);
        Class<?> clazz = JavassistProxyFactory.getInstance().createAbstractDecoratorProxyClass(bean);
        bean.setConstructor(WebBeansUtil.defineConstructor(clazz));
        return bean;
    }

    public static <T> ManagedBean<T> defineManagedBean(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> processInjectionTargetEvent) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        AnnotatedType annotatedType = processInjectionTargetEvent.getAnnotatedType();
        AbstractInjectionTargetBean managedBean = managedBeanCreator.getBean();
        Class clazz = annotatedType.getJavaClass();
        managedBeanCreator.defineSerializable();
        managedBeanCreator.defineStereoTypes();
        managedBeanCreator.defineScopeType(logger.getTokenString("TEXT_MB_IMPL") + clazz.getName() + logger.getTokenString("TEXT_SAME_SCOPE"));
        WebBeansUtil.setInjectionTargetBeanEnableFlag(managedBean);
        managedBeanCreator.defineApiType();
        managedBeanCreator.checkCreateConditions();
        managedBeanCreator.defineQualifier();
        managedBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        managedBeanCreator.defineConstructor();
        Set<ProducerMethodBean<?>> producerMethods = managedBeanCreator.defineProducerMethods();
        Set<ProducerFieldBean<?>> producerFields = managedBeanCreator.defineProducerFields();
        managedBeanCreator.defineInjectedFields();
        managedBeanCreator.defineInjectedMethods();
        Set<Object> observerMethods = new HashSet();
        if (managedBean.isEnabled()) {
            observerMethods = managedBeanCreator.defineObserverMethods();
        }
        manager.putInjectionTargetWrapper(managedBean, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
        HashMap annotatedMethods = new HashMap();
        for (ProducerMethodBean<?> producerMethod : producerMethods) {
            AnnotatedMethod method = AnnotatedElementFactory.getInstance().newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            GProcessProducer gProcessProducer = WebBeansUtil.fireProcessProducerEventForMethod(producerMethod, method);
            WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
            manager.putInjectionTargetWrapper(producerMethod, new InjectionTargetWrapper(gProcessProducer.getProducer()));
            gProcessProducer.setProducerSet(false);
        }
        HashMap annotatedFields = new HashMap();
        for (ProducerFieldBean<?> producerField : producerFields) {
            AnnotatedField annotatedField = AnnotatedElementFactory.getInstance().newAnnotatedField(producerField.getCreatorField(), annotatedType);
            GProcessProducer producerEvent = WebBeansUtil.fireProcessProducerEventForField(producerField, annotatedField);
            WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, annotatedField);
            manager.putInjectionTargetWrapper(producerField, new InjectionTargetWrapper(producerEvent.getProducer()));
            producerEvent.setProducerSet(false);
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod annotatedMethod = AnnotatedElementFactory.getInstance().newAnnotatedMethod(impl.getObserverMethod(), annotatedType);
            observerMethodsMap.put(observerMethod, annotatedMethod);
        }
        BeanManagerImpl beanManager = BeanManagerImpl.getManager();
        GProcessManagedBean gProcessManagedBean = new GProcessManagedBean((ManagedBean<?>)managedBean, (AnnotatedType<?>)annotatedType);
        beanManager.fireEvent(gProcessManagedBean, new Annotation[0]);
        WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessManagedBean event observers for managed beans. Look at logs for further details");
        WebBeansUtil.fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        WebBeansUtil.fireProcessProducerFieldBeanEvent(annotatedFields);
        WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        WebBeansUtil.fireProcessObservableMethodBeanEvent(observerMethodsMap);
        WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        if (!WebBeansAnnotatedTypeUtil.isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
            beanManager.addBean(WebBeansUtil.createNewBean(managedBean));
            beanManager.addBean(managedBean);
            for (ProducerMethodBean<?> producerMethodBean : producerMethods) {
                beanManager.addBean(producerMethodBean);
            }
            managedBeanCreator.defineDisposalMethods();
            for (ProducerFieldBean producerFieldBean : producerFields) {
                beanManager.addBean(producerFieldBean);
            }
        }
        return managedBean;
    }

    public static <T> ManagedBean<T> defineManagedBeanWithoutFireEvents(AnnotatedType<T> type) {
        Class clazz = type.getJavaClass();
        ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED);
        managedBean.setAnnotatedType(type);
        ManagedBeanCreatorImpl<T> managedBeanCreator = new ManagedBeanCreatorImpl<T>(managedBean);
        managedBeanCreator.setAnnotatedType(type);
        managedBeanCreator.defineSerializable();
        managedBeanCreator.defineStereoTypes();
        managedBeanCreator.defineScopeType(logger.getTokenString("TEXT_MB_IMPL") + clazz.getName() + logger.getTokenString("TEXT_SAME_SCOPE"));
        WebBeansUtil.setInjectionTargetBeanEnableFlag(managedBean);
        managedBeanCreator.defineApiType();
        managedBeanCreator.checkCreateConditions();
        managedBeanCreator.defineQualifier();
        managedBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        managedBeanCreator.defineConstructor();
        managedBeanCreator.defineProducerMethods();
        managedBeanCreator.defineProducerFields();
        managedBeanCreator.defineInjectedFields();
        managedBeanCreator.defineInjectedMethods();
        managedBeanCreator.defineObserverMethods();
        DefinitionUtil.defineDecoratorStack(managedBean);
        DefinitionUtil.defineBeanInterceptorStack(managedBean);
        managedBeanCreator.defineDisposalMethods();
        return managedBean;
    }

    public static boolean isStaticInjection(InjectionPoint injectionPoint) {
        Member member;
        return injectionPoint != null && (member = injectionPoint.getMember()) != null && Modifier.isStatic(member.getModifiers());
    }

    public static boolean isPassivationCapableDependency(InjectionPoint injectionPoint) {
        Bean<?> bean = InjectionResolver.getInstance().getInjectionPointBean(injectionPoint);
        if (bean instanceof EnterpriseBeanMarker || bean instanceof ResourceBean || bean instanceof InstanceBean || bean instanceof EventBean || bean instanceof InjectionPointBean || bean instanceof BeanManagerBean) {
            return true;
        }
        if (BeanManagerImpl.getManager().isNormalScope(bean.getScope())) {
            return true;
        }
        return WebBeansUtil.isPassivationCapable(bean) != null;
    }

    public static void throwRuntimeExceptions(Exception e) {
        if (RuntimeException.class.isAssignableFrom(e.getClass())) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    static {
        isScopeTypeNormalCache = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    }
}

