/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class InterceptorHandler
implements MethodHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private final WebBeansLogger logger = WebBeansLogger.getLogger(InterceptorHandler.class);
    protected OwbBean<?> bean = null;
    protected transient Map<Method, List<InterceptorData>> interceptedMethodMap = null;

    protected InterceptorHandler(OwbBean<?> bean) {
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments, CreationalContextImpl<?> ownerCreationalContext) throws Exception {
        if (instance == null) {
            return null;
        }
        Object result = null;
        try {
            String methodName = method.getName();
            if ((!ClassUtil.isObjectMethod(methodName) || methodName.equals("toString")) && this.bean instanceof InjectionTargetBean) {
                InjectionTargetBean injectionTarget = (InjectionTargetBean)this.bean;
                DelegateHandler delegateHandler = null;
                InterceptorDataImpl decoratorInterceptorDataImpl = null;
                if (InterceptorUtil.isWebBeansBusinessMethod(method)) {
                    List<InterceptorData> interceptorStack;
                    List<Object> decorators = null;
                    if (injectionTarget.getDecoratorStack().size() > 0) {
                        Class<?> proxyClass = JavassistProxyFactory.getInstance().getInterceptorProxyClasses().get(this.bean);
                        if (proxyClass == null) {
                            ProxyFactory delegateFactory = JavassistProxyFactory.getInstance().createProxyFactory(this.bean);
                            proxyClass = JavassistProxyFactory.getInstance().getProxyClass(delegateFactory);
                            JavassistProxyFactory.getInstance().getInterceptorProxyClasses().put(this.bean, proxyClass);
                        }
                        Object delegate = proxyClass.newInstance();
                        delegateHandler = new DelegateHandler(this.bean);
                        ((ProxyObject)delegate).setHandler((MethodHandler)delegateHandler);
                        decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, instance, delegate, ownerCreationalContext);
                        delegateHandler.setDecorators(decorators);
                    }
                    if ((interceptorStack = injectionTarget.getInterceptorStack()).size() > 0) {
                        ArrayList<InterceptorData> filteredInterceptorStack;
                        if (this.interceptedMethodMap == null) {
                            this.interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
                        }
                        if (decorators != null) {
                            WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                            decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor);
                            decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                            decoratorInterceptorDataImpl.setAroundInvoke(SecurityUtil.doPrivilegedGetDeclaredMethods(lastInterceptor.getClass())[0]);
                        }
                        if (this.interceptedMethodMap.get(method) == null) {
                            filteredInterceptorStack = new ArrayList<InterceptorData>(interceptorStack);
                            InterceptorUtil.filterCommonInterceptorStackList(filteredInterceptorStack, method);
                            this.interceptedMethodMap.put(method, filteredInterceptorStack);
                        }
                        filteredInterceptorStack = new ArrayList(this.interceptedMethodMap.get(method));
                        if (decoratorInterceptorDataImpl != null) {
                            filteredInterceptorStack.add(decoratorInterceptorDataImpl);
                        }
                        if (WebBeansUtil.isContainsInterceptorMethod(filteredInterceptorStack, InterceptorType.AROUND_INVOKE)) {
                            return this.callAroundInvokes(method, arguments, InterceptorUtil.getInterceptorMethods(filteredInterceptorStack, InterceptorType.AROUND_INVOKE));
                        }
                    }
                    if (decorators != null) {
                        return delegateHandler.invoke(instance, method, proceed, arguments);
                    }
                }
            }
            boolean access = method.isAccessible();
            SecurityUtil.doPrivilegedSetAccessible(method, true);
            try {
                result = method.invoke(instance, arguments);
            }
            finally {
                SecurityUtil.doPrivilegedSetAccessible(method, access);
            }
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (Exception.class.isAssignableFrom(target.getClass())) {
                throw (Exception)target;
            }
            throw e;
        }
        return result;
    }

    protected abstract Object callAroundInvokes(Method var1, Object[] var2, List<InterceptorData> var3) throws Exception;

    protected BeanManagerImpl getBeanManager() {
        return BeanManagerImpl.getManager();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeLong(1L);
        String passivationId = this.bean.getId();
        if (passivationId != null) {
            s.writeObject(passivationId);
        } else {
            s.writeObject(null);
            this.logger.warn("WARN_0010", this.bean);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (s.readLong() == 1L) {
            String passivationId = (String)s.readObject();
            if (passivationId != null) {
                this.bean = (OwbBean)BeanManagerImpl.getManager().getPassivationCapableBean(passivationId);
            }
        } else {
            this.logger.warn("WARN_0011", this.bean);
        }
    }
}

