/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Scope;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.inheritance.IBeanInheritedMetaData;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.intercept.ejb.EJBInterceptorConfig;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class DefinitionUtil {
    private DefinitionUtil() {
    }

    public static <T> void defineApiTypes(AbstractOwbBean<T> bean, Class<T> clazz) {
        Annotation[] annots = clazz.getDeclaredAnnotations();
        if (AnnotationUtil.hasAnnotation(annots, Typed.class)) {
            Typed beanTypes = AnnotationUtil.getAnnotation(annots, Typed.class);
            DefinitionUtil.defineUserDefinedBeanTypes(bean, null, beanTypes);
        } else {
            DefinitionUtil.defineNormalApiTypes(bean, clazz);
        }
    }

    private static <T> void defineNormalApiTypes(AbstractOwbBean<T> bean, Class<T> clazz) {
        bean.getTypes().add((Type)((Object)Object.class));
        ClassUtil.setTypeHierarchy(bean.getTypes(), clazz);
    }

    private static <T> void defineUserDefinedBeanTypes(AbstractOwbBean<T> bean, Type producerGenericReturnType, Typed beanTypes) {
        if (producerGenericReturnType != null) {
            DefinitionUtil.defineNormalProducerMethodApi((AbstractProducerBean)bean, producerGenericReturnType);
        } else {
            DefinitionUtil.defineNormalApiTypes(bean, bean.getReturnType());
        }
        Class[] types = beanTypes.value();
        Set<Type> apiTypes = bean.getTypes();
        HashSet<Type> newTypes = new HashSet<Type>();
        for (Class type : types) {
            Type foundType = null;
            for (Type apiType : apiTypes) {
                if (ClassUtil.getClazz(apiType) != type) continue;
                foundType = apiType;
                break;
            }
            if (foundType == null) {
                throw new WebBeansConfigurationException("@Type values must be in bean api types : " + bean.getTypes());
            }
            newTypes.add(foundType);
        }
        apiTypes.clear();
        apiTypes.addAll(newTypes);
        apiTypes.add((Type)((Object)Object.class));
    }

    public static <T> void defineProducerMethodApiTypes(AbstractProducerBean<T> producerBean, Type type, Annotation[] annots) {
        if (AnnotationUtil.hasAnnotation(annots, Typed.class)) {
            Typed beanTypes = AnnotationUtil.getAnnotation(annots, Typed.class);
            DefinitionUtil.defineUserDefinedBeanTypes(producerBean, type, beanTypes);
        } else {
            DefinitionUtil.defineNormalProducerMethodApi(producerBean, type);
        }
    }

    private static <T> void defineNormalProducerMethodApi(AbstractProducerBean<T> producerBean, Type type) {
        Set<Type> types = producerBean.getTypes();
        types.add((Type)((Object)Object.class));
        Class<?> clazz = ClassUtil.getClazz(type);
        if (clazz != null && (clazz.isPrimitive() || clazz.isArray())) {
            types.add(clazz);
        } else {
            ClassUtil.setTypeHierarchy(producerBean.getTypes(), type);
        }
    }

    public static <T> void defineQualifiers(AbstractOwbBean<T> component, Annotation[] annotations) {
        Annotation annot;
        boolean find = false;
        for (Annotation annotation : annotations) {
            Method[] methods;
            Class<? extends Annotation> type = annotation.annotationType();
            if (!AnnotationUtil.isQualifierAnnotation(type)) continue;
            for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(type)) {
                Class<?> clazz = method.getReturnType();
                if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
                throw new WebBeansConfigurationException("WebBeans definition class : " + component.getReturnType().getName() + " @Qualifier : " + annotation.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
            }
            if (!find) {
                find = true;
            }
            component.addQualifier(annotation);
        }
        IBeanInheritedMetaData inheritedMetaData = null;
        if (component instanceof InjectionTargetBean) {
            inheritedMetaData = ((InjectionTargetBean)((Object)component)).getInheritedMetaData();
        }
        if (inheritedMetaData != null) {
            Set<Annotation> inheritedTypes = inheritedMetaData.getInheritedQualifiers();
            for (Annotation inherited : inheritedTypes) {
                Set<Annotation> qualifiers = component.getQualifiers();
                boolean found = false;
                for (Annotation existQualifier : qualifiers) {
                    if (!existQualifier.annotationType().equals(inherited.annotationType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                component.addQualifier(inherited);
            }
        }
        if (component.getQualifiers().size() == 0) {
            component.addQualifier((Annotation)((Object)new DefaultLiteral()));
        } else if (component.getQualifiers().size() == 1 && (annot = component.getQualifiers().iterator().next()).annotationType().equals(Named.class)) {
            component.addQualifier((Annotation)((Object)new DefaultLiteral()));
        }
        if (!AnnotationUtil.hasAnyQualifier(component)) {
            component.addQualifier((Annotation)((Object)new AnyLiteral()));
        }
    }

    public static <T> void defineScopeType(AbstractOwbBean<T> component, Annotation[] annotations, String exceptionMessage) {
        boolean found = false;
        List<ExternalScope> additionalScopes = BeanManagerImpl.getManager().getAdditionalScopes();
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            Object var = annotationType.getAnnotation(NormalScope.class);
            Object pseudo = annotationType.getAnnotation(Scope.class);
            if (var == null && pseudo == null) {
                for (ExternalScope additionalScope : additionalScopes) {
                    if (!annotationType.equals(additionalScope.getScope())) continue;
                    Annotation scopeAnnotation = additionalScope.getScopeAnnotation();
                    if (additionalScope.isNormal()) {
                        var = scopeAnnotation;
                        continue;
                    }
                    pseudo = scopeAnnotation;
                }
            }
            if (var != null) {
                if (pseudo != null) {
                    throw new WebBeansConfigurationException("Not to define both @Scope and @NormalScope on bean : " + component);
                }
                if (found) {
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                found = true;
                component.setImplScopeType(annotation);
                continue;
            }
            if (pseudo == null) continue;
            if (found) {
                throw new WebBeansConfigurationException(exceptionMessage);
            }
            found = true;
            component.setImplScopeType(annotation);
        }
        if (!found) {
            DefinitionUtil.defineDefaultScopeType(component, exceptionMessage);
        }
    }

    public static <T> void defineStereoTypes(OwbBean<?> component, Annotation[] anns) {
        if (AnnotationUtil.hasStereoTypeMetaAnnotation(anns)) {
            Annotation[] steroAnns;
            for (Annotation stereo : steroAnns = AnnotationUtil.getStereotypeMetaAnnotations(anns)) {
                component.addStereoType(stereo);
            }
        }
        IBeanInheritedMetaData inheritedMetaData = null;
        if (component instanceof InjectionTargetBean) {
            inheritedMetaData = ((InjectionTargetBean)component).getInheritedMetaData();
        }
        if (inheritedMetaData != null) {
            Set<Annotation> inheritedTypes = inheritedMetaData.getInheritedStereoTypes();
            for (Annotation inherited : inheritedTypes) {
                Set qualifiers = component.getStereotypes();
                boolean found = false;
                for (Class existQualifier : qualifiers) {
                    if (!existQualifier.equals(inherited.annotationType())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                component.addStereoType(inherited);
            }
        }
    }

    public static void defineDefaultScopeType(OwbBean<?> component, String exceptionMessage) {
        Annotation inheritedScope;
        IBeanInheritedMetaData metaData = null;
        if (component instanceof InjectionTargetBean) {
            metaData = ((InjectionTargetBean)component).getInheritedMetaData();
        }
        boolean found = false;
        if (metaData != null && (inheritedScope = metaData.getInheritedScopeType()) != null) {
            found = true;
            component.setImplScopeType(inheritedScope);
        }
        if (!found) {
            Set stereos = component.getStereotypes();
            if (stereos.size() == 0) {
                component.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
            } else {
                Annotation defined = null;
                Set anns = component.getStereotypes();
                for (Class stero : anns) {
                    boolean containsNormal = AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class);
                    if (!AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), NormalScope.class) && !AnnotationUtil.hasMetaAnnotation(stero.getDeclaredAnnotations(), Scope.class)) continue;
                    Annotation next = null;
                    next = containsNormal ? AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), NormalScope.class)[0] : AnnotationUtil.getMetaAnnotations(stero.getDeclaredAnnotations(), Scope.class)[0];
                    if (defined == null) {
                        defined = next;
                        continue;
                    }
                    if (((Object)defined).equals(next)) continue;
                    throw new WebBeansConfigurationException(exceptionMessage);
                }
                if (defined != null) {
                    component.setImplScopeType(defined);
                } else {
                    component.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
                }
            }
        }
    }

    public static <T> void defineName(AbstractOwbBean<T> component, Annotation[] anns, String defaultName) {
        Named nameAnnot = null;
        boolean isDefault = false;
        for (Annotation ann : anns) {
            if (!ann.annotationType().equals(Named.class)) continue;
            nameAnnot = (Named)ann;
            break;
        }
        if (nameAnnot == null) {
            if (WebBeansUtil.hasNamedOnStereoTypes(component)) {
                isDefault = true;
            }
        } else if (nameAnnot.value().equals("")) {
            isDefault = true;
        } else {
            component.setName(nameAnnot.value());
        }
        if (isDefault) {
            component.setName(defaultName);
        }
    }

    public static Set<ProducerFieldBean<?>> defineProduerFields(InjectionTargetBean<?> component) {
        HashSet producerFields = new HashSet();
        Field[] fields = SecurityUtil.doPrivilegedGetDeclaredFields(component.getReturnType());
        DefinitionUtil.createProducerField(component, producerFields, fields);
        return producerFields;
    }

    private static void createProducerField(InjectionTargetBean<?> component, Set<ProducerFieldBean<?>> producerFields, Field[] fields) {
        for (Field field : fields) {
            Type genericType = field.getGenericType();
            if (!AnnotationUtil.hasAnnotation(field.getDeclaredAnnotations(), Produces.class)) continue;
            if (ClassUtil.isParametrizedType(genericType) && !ClassUtil.checkParametrizedType((ParameterizedType)genericType)) {
                throw new WebBeansConfigurationException("Producer field : " + field.getName() + " return type in class : " + field.getDeclaringClass().getName() + " can not be Wildcard type or Type variable");
            }
            ProducerFieldBean<?> newComponent = DefinitionUtil.createProducerFieldComponent(field.getType(), field, component);
            if (newComponent == null) continue;
            producerFields.add(newComponent);
        }
    }

    public static Set<ProducerMethodBean<?>> defineProducerMethods(AbstractInjectionTargetBean<?> component) {
        Method[] declaredMethods;
        Asserts.assertNotNull(component, "component parameter can not be null");
        HashSet producerComponents = new HashSet();
        Class clazz = component.getReturnType();
        for (Method declaredMethod : declaredMethods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            DefinitionUtil.createProducerComponents(component, producerComponents, declaredMethod, clazz);
        }
        return producerComponents;
    }

    private static <T> void createProducerComponents(InjectionTargetBean<T> component, Set<ProducerMethodBean<?>> producerComponents, Method declaredMethod, Class<?> clazz) {
        boolean isSpecializes = false;
        if (AnnotationUtil.hasMethodAnnotation(declaredMethod, Produces.class)) {
            ProducerMethodBean<?> newComponent;
            WebBeansUtil.checkProducerMethodForDeployment(declaredMethod, clazz.getName());
            if (AnnotationUtil.hasMethodAnnotation(declaredMethod, Specializes.class)) {
                if (ClassUtil.isStatic(declaredMethod.getModifiers())) {
                    throw new WebBeansConfigurationException("Specializing producer method : " + declaredMethod.getName() + " in class : " + clazz.getName() + " can not be static");
                }
                isSpecializes = true;
            }
            if ((newComponent = DefinitionUtil.createProducerComponent(declaredMethod.getReturnType(), declaredMethod, component, isSpecializes)) != null) {
                producerComponents.add(newComponent);
                DefinitionUtil.addMethodInjectionPointMetaData(newComponent, declaredMethod);
            }
        }
    }

    public static <T> ProducerMethodBean<T> createProducerComponent(Class<T> returnType, Method method, InjectionTargetBean<?> parent, boolean isSpecializes) {
        ProducerMethodBean<T> component = new ProducerMethodBean<T>(parent, returnType);
        component.setCreatorMethod(method);
        if (isSpecializes) {
            WebBeansUtil.configureProducerSpecialization(component, method, parent.getReturnType().getSuperclass());
        }
        if (returnType.isPrimitive()) {
            component.setNullable(false);
        }
        DefinitionUtil.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, method.getDeclaredAnnotations());
        Annotation[] methodAnns = method.getDeclaredAnnotations();
        WebBeansUtil.setBeanEnableFlagForProducerBean(parent, component, methodAnns);
        DefinitionUtil.defineProducerMethodApiTypes(component, method.getGenericReturnType(), methodAnns);
        DefinitionUtil.defineScopeType(component, methodAnns, "WebBeans producer method : " + method.getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation");
        WebBeansUtil.checkUnproxiableApiType(component, component.getScope());
        WebBeansUtil.checkProducerGenericType(component, method);
        DefinitionUtil.defineQualifiers(component, methodAnns);
        DefinitionUtil.defineName(component, methodAnns, WebBeansUtil.getProducerDefaultName(method.getName()));
        return component;
    }

    private static <T> ProducerFieldBean<T> createProducerFieldComponent(Class<T> returnType, Field field, InjectionTargetBean<?> parent) {
        ProducerFieldBean<T> component = new ProducerFieldBean<T>(parent, returnType);
        Annotation resourceAnnotation = AnnotationUtil.hasOwbInjectableResource(field.getDeclaredAnnotations());
        if (resourceAnnotation != null && !ClassUtil.isStatic(field.getModifiers())) {
            ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), returnType, resourceAnnotation);
            if (field.isAnnotationPresent(Named.class)) {
                throw new WebBeansConfigurationException("Resource producer field : " + field + " can not define EL name");
            }
            ResourceBean resourceBean = new ResourceBean(returnType, parent, resourceRef);
            DefinitionUtil.defineProducerMethodApiTypes(resourceBean, field.getGenericType(), field.getDeclaredAnnotations());
            DefinitionUtil.defineQualifiers(resourceBean, field.getDeclaredAnnotations());
            resourceBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
            resourceBean.setProducerField(field);
            return resourceBean;
        }
        component.setProducerField(field);
        if (returnType.isPrimitive()) {
            component.setNullable(false);
        }
        DefinitionUtil.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, field.getDeclaredAnnotations());
        Annotation[] fieldAnns = field.getDeclaredAnnotations();
        WebBeansUtil.setBeanEnableFlagForProducerBean(parent, component, fieldAnns);
        DefinitionUtil.defineProducerMethodApiTypes(component, field.getGenericType(), fieldAnns);
        DefinitionUtil.defineScopeType(component, fieldAnns, "WebBeans producer method : " + field.getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation");
        WebBeansUtil.checkUnproxiableApiType(component, component.getScope());
        WebBeansUtil.checkProducerGenericType(component, field);
        DefinitionUtil.defineQualifiers(component, fieldAnns);
        DefinitionUtil.defineName(component, fieldAnns, field.getName());
        return component;
    }

    public static <T> void defineDisposalMethods(AbstractOwbBean<T> component) {
        Class<T> clazz = component.getReturnType();
        Method[] methods = AnnotationUtil.getMethodsWithParameterAnnotation(clazz, Disposes.class);
        DefinitionUtil.createDisposalMethods(component, methods, clazz);
    }

    private static <T> void createDisposalMethods(AbstractOwbBean<T> component, Method[] methods, Class<?> clazz) {
        ProducerMethodBean previous = null;
        for (Method declaredMethod : methods) {
            WebBeansUtil.checkProducerMethodDisposal(declaredMethod, clazz.getName());
            Type type = AnnotationUtil.getMethodFirstParameterWithAnnotation(declaredMethod, Disposes.class);
            Annotation[] annot = AnnotationUtil.getMethodFirstParameterQualifierWithGivenAnnotation(declaredMethod, Disposes.class);
            Set<Bean<?>> set = InjectionResolver.getInstance().implResolveByType(type, annot);
            if (set.isEmpty()) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, declaredMethod, annot);
            }
            Bean<?> bean = set.iterator().next();
            ProducerMethodBean pr = null;
            if (bean == null || !(bean instanceof ProducerMethodBean)) {
                InjectionExceptionUtils.throwUnsatisfiedResolutionException(clazz, declaredMethod, new Annotation[0]);
            } else {
                pr = (ProducerMethodBean)bean;
            }
            if (previous == null) {
                previous = pr;
            } else if (previous.equals(pr)) {
                throw new WebBeansConfigurationException("There are multiple disposal method for the producer method : " + pr.getCreatorMethod().getName() + " in class : " + clazz.getName());
            }
            Method producerMethod = pr.getCreatorMethod();
            if (!producerMethod.getDeclaringClass().getName().equals(declaredMethod.getDeclaringClass().getName())) {
                throw new WebBeansConfigurationException("Producer method component of the disposal method : " + declaredMethod.getName() + " in class : " + clazz.getName() + " must be in the same class!");
            }
            pr.setDisposalMethod(declaredMethod);
            DefinitionUtil.addMethodInjectionPointMetaData(component, declaredMethod);
        }
    }

    public static <T> void defineInjectedFields(AbstractInjectionTargetBean<T> component) {
        Class clazz = component.getReturnType();
        DefinitionUtil.defineInternalInjectedFields(component, clazz, false);
        DefinitionUtil.defineInternalInjectedFieldsRecursively(component, clazz);
    }

    public static <T> void defineInternalInjectedFieldsRecursively(AbstractInjectionTargetBean<T> component, Class<T> clazz) {
        Class<T> superClazz = clazz.getSuperclass();
        if (!superClazz.equals(Object.class)) {
            DefinitionUtil.defineInternalInjectedFields(component, superClazz, true);
            DefinitionUtil.defineInternalInjectedFieldsRecursively(component, superClazz);
        }
    }

    public static <T> void defineInternalInjectedFields(AbstractInjectionTargetBean<T> component, Class<T> clazz, boolean fromSuperClazz) {
        Field[] fields = SecurityUtil.doPrivilegedGetDeclaredFields(clazz);
        if (fields.length != 0) {
            for (Field field : fields) {
                int mod;
                if (ClassUtil.isPublic(field.getModifiers()) && !ClassUtil.isStatic(field.getModifiers()) && BeanManagerImpl.getManager().isNormalScope(component.getScope())) {
                    throw new WebBeansConfigurationException("If bean has a public field, bean scope must be defined as @Scope. Bean is : " + component.toString());
                }
                if (!field.isAnnotationPresent(Inject.class)) continue;
                Annotation[] anns = field.getDeclaredAnnotations();
                if (AnnotationUtil.hasAnnotation(anns, Produces.class)) {
                    throw new WebBeansConfigurationException("Injection fields can not be annotated with @Produces");
                }
                Annotation[] qualifierAnns = AnnotationUtil.getQualifierAnnotations(anns);
                if (qualifierAnns.length <= 0) continue;
                if (qualifierAnns.length > 0) {
                    WebBeansUtil.checkForNewQualifierForDeployment(field.getGenericType(), clazz, field.getName(), anns);
                }
                if (Modifier.isStatic(mod = field.getModifiers()) || Modifier.isFinal(mod)) continue;
                if (fromSuperClazz) {
                    component.addInjectedFieldToSuper(field);
                } else {
                    component.addInjectedField(field);
                }
                DefinitionUtil.addFieldInjectionPointMetaData(component, field);
            }
        }
    }

    public static <T> void defineInjectedMethods(AbstractInjectionTargetBean<T> bean) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Class clazz = bean.getReturnType();
        DefinitionUtil.defineInternalInjectedMethods(bean, clazz, false);
        DefinitionUtil.defineInternalInjectedMethodsRecursively(bean, clazz);
    }

    public static <T> void defineInternalInjectedMethodsRecursively(AbstractInjectionTargetBean<T> component, Class<T> clazz) {
        Class<T> superClazz = clazz.getSuperclass();
        if (!superClazz.equals(Object.class)) {
            DefinitionUtil.defineInternalInjectedMethods(component, superClazz, true);
            DefinitionUtil.defineInternalInjectedMethodsRecursively(component, superClazz);
        }
    }

    private static <T> void defineInternalInjectedMethods(AbstractInjectionTargetBean<T> component, Class<T> clazz, boolean fromInherited) {
        Method[] methods;
        for (Method method : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(clazz)) {
            boolean isInitializer = AnnotationUtil.hasMethodAnnotation(method, Inject.class);
            if (!isInitializer || ClassUtil.isStatic(method.getModifiers())) continue;
            DefinitionUtil.checkForInjectedInitializerMethod(component, clazz, method);
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (!fromInherited) {
                component.addInjectedMethod(method);
                DefinitionUtil.addMethodInjectionPointMetaData(component, method);
                continue;
            }
            Method[] beanMethods = SecurityUtil.doPrivilegedGetDeclaredMethods(component.getReturnType());
            boolean defined = false;
            for (Method beanMethod : beanMethods) {
                if (!ClassUtil.isOverriden(beanMethod, method)) continue;
                defined = true;
                break;
            }
            if (defined) continue;
            component.addInjectedMethodToSuper(method);
            DefinitionUtil.addMethodInjectionPointMetaData(component, method);
        }
    }

    private static <T> void checkForInjectedInitializerMethod(AbstractInjectionTargetBean<T> component, Class<T> clazz, Method method) {
        TypeVariable<Method>[] args = method.getTypeParameters();
        if (args.length > 0) {
            throw new WebBeansConfigurationException("Initializer methods must not be generic but method : " + method.getName() + " in bean class : " + clazz + " is defined as generic");
        }
        Annotation[][] anns = method.getParameterAnnotations();
        Type[] type = method.getGenericParameterTypes();
        for (int i = 0; i < anns.length; ++i) {
            Annotation[] a = anns[i];
            Type t = type[i];
            WebBeansUtil.checkForNewQualifierForDeployment(t, clazz, method.getName(), a);
        }
        if (method.getAnnotation(Produces.class) != null) {
            throw new WebBeansConfigurationException("Initializer method : " + method.getName() + " in class : " + clazz.getName() + " can not be annotated with @Produces");
        }
        WebBeansUtil.checkInjectedMethodParameterConditions(method, clazz);
    }

    public static void defineBeanInterceptorStack(AbstractInjectionTargetBean<?> bean) {
        Asserts.assertNotNull(bean, "bean parameter can no be null");
        if (!(bean instanceof EnterpriseBeanMarker)) {
            EJBInterceptorConfig.configure(bean.getReturnType(), bean.getInterceptorStack());
        } else {
            ArrayList<InterceptorData> stack = new ArrayList<InterceptorData>();
            EJBInterceptorConfig.configure(bean.getBeanClass(), stack);
            for (InterceptorData data : stack) {
                if (!data.isDefinedInInterceptorClass() || OWBInjector.checkInjectionPointForInterceptorPassivation(data.getInterceptorClass())) continue;
                throw new WebBeansConfigurationException("Enterprise bean : " + bean.toString() + " interceptors must have serializable injection points");
            }
        }
        WebBeansInterceptorConfig.configure(bean, bean.getInterceptorStack());
    }

    public static void defineDecoratorStack(AbstractInjectionTargetBean<?> bean) {
        WebBeansDecoratorConfig.configureDecarotors(bean);
    }

    public static <T> Set<ObserverMethod<?>> defineObserverMethods(InjectionTargetBean<T> component, Class<T> clazz) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        NotificationManager manager = NotificationManager.getInstance();
        Method[] candidateMethods = AnnotationUtil.getMethodsWithParameterAnnotation(clazz, Observes.class);
        DefinitionUtil.createObserverMethods(component, clazz, candidateMethods);
        return manager.addObservableComponentMethods(component);
    }

    private static <T> void createObserverMethods(InjectionTargetBean<T> component, Class<?> clazz, Method[] candidateMethods) {
        for (Method candidateMethod : candidateMethods) {
            EventUtil.checkObserverMethodConditions(candidateMethod, clazz);
            AbstractOwbBean bean = (AbstractOwbBean)((Object)component);
            if (bean.getScope().equals(Dependent.class) && EventUtil.isReceptionIfExist(candidateMethod)) {
                throw new WebBeansConfigurationException("Dependent Bean : " + bean + " can not define observer method with @Receiver = IF_EXIST");
            }
            component.addObservableMethod(candidateMethod);
            DefinitionUtil.addMethodInjectionPointMetaData((AbstractOwbBean)((Object)component), candidateMethod);
        }
    }

    public static <T> void defineSerializable(AbstractOwbBean<T> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        if (ClassUtil.isClassAssignable(Serializable.class, component.getReturnType())) {
            component.setSerializable(true);
        }
    }

    public static <T> void addFieldInjectionPointMetaData(AbstractOwbBean<T> owner, Field field) {
        InjectionPoint injectionPoint = InjectionPointFactory.getFieldInjectionPointData(owner, field);
        if (injectionPoint != null) {
            DefinitionUtil.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public static <T> void addMethodInjectionPointMetaData(AbstractOwbBean<T> owner, Method method) {
        List<InjectionPoint> injectionPoints = InjectionPointFactory.getMethodInjectionPointData(owner, method);
        for (InjectionPoint injectionPoint : injectionPoints) {
            DefinitionUtil.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public static <T> void addConstructorInjectionPointMetaData(AbstractOwbBean<T> owner, Constructor<T> constructor) {
        List<InjectionPoint> injectionPoints = InjectionPointFactory.getConstructorInjectionPointData(owner, constructor);
        for (InjectionPoint injectionPoint : injectionPoints) {
            DefinitionUtil.addImplicitComponentForInjectionPoint(injectionPoint);
            owner.addInjectionPoint(injectionPoint);
        }
    }

    public static void addImplicitComponentForInjectionPoint(InjectionPoint injectionPoint) {
        if (WebBeansUtil.checkObtainsInjectionPointConditions(injectionPoint) || EventUtil.checkObservableInjectionPointConditions(injectionPoint)) {
            // empty if block
        }
    }

    public static <X> Set<ProducerMethodBean<?>> defineProducerMethods(InjectionTargetBean<X> bean, AnnotatedType<X> annotatedType) {
        HashSet producerComponents = new HashSet();
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            DefinitionUtil.createProducerBeansFromAnnotatedType(bean, producerComponents, annotatedMethod, bean.getReturnType(), false);
        }
        return producerComponents;
    }

    private static <X> void createProducerBeansFromAnnotatedType(InjectionTargetBean<X> bean, Set<ProducerMethodBean<?>> producerComponents, AnnotatedMethod<X> annotatedMethod, Class<?> clazz, boolean isSpecializes) {
        Annotation[] anns = annotatedMethod.getAnnotations().toArray(new Annotation[0]);
        List parameters = annotatedMethod.getParameters();
        if (AnnotationUtil.hasAnnotation(anns, Produces.class)) {
            ProducerMethodBean<?> newComponent;
            for (AnnotatedParameter parameter : parameters) {
                Annotation[] parameterAnns = parameter.getAnnotations().toArray(new Annotation[0]);
                if (!AnnotationUtil.hasAnnotation(anns, Inject.class) && !AnnotationUtil.hasAnnotation(parameterAnns, Disposes.class) && !AnnotationUtil.hasAnnotation(parameterAnns, Observes.class)) continue;
                throw new WebBeansConfigurationException("Producer Method Bean with name : " + annotatedMethod.getJavaMember().getName() + " in bean class : " + clazz + " can not be annotated with @Initializer/@Destructor annotation " + "or has a parameter annotated with @Disposes/@Observes");
            }
            if (AnnotationUtil.hasAnnotation(anns, Specializes.class)) {
                if (ClassUtil.isStatic(annotatedMethod.getJavaMember().getModifiers())) {
                    throw new WebBeansConfigurationException("Specializing producer method : " + annotatedMethod.getJavaMember().getName() + " in class : " + clazz.getName() + " can not be static");
                }
                isSpecializes = true;
            }
            if ((newComponent = DefinitionUtil.createProducerBeanFromAnnotatedType(annotatedMethod.getJavaMember().getReturnType(), annotatedMethod, bean, isSpecializes)) != null) {
                producerComponents.add(newComponent);
                DefinitionUtil.addMethodInjectionPointMetaData(newComponent, annotatedMethod.getJavaMember());
            }
        }
    }

    public static <X> ProducerMethodBean<X> createProducerBeanFromAnnotatedType(Class<X> returnType, AnnotatedMethod<X> method, InjectionTargetBean<?> parent, boolean isSpecializes) {
        ProducerMethodBean<X> bean = new ProducerMethodBean<X>(parent, returnType);
        bean.setCreatorMethod(method.getJavaMember());
        if (isSpecializes) {
            WebBeansUtil.configureProducerSpecialization(bean, method.getJavaMember(), parent.getReturnType().getSuperclass());
        }
        if (returnType.isPrimitive()) {
            bean.setNullable(false);
        }
        Annotation[] anns = method.getAnnotations().toArray(new Annotation[0]);
        DefinitionUtil.defineSerializable(bean);
        DefinitionUtil.defineStereoTypes(bean, anns);
        DefinitionUtil.defineProducerMethodApiTypes(bean, method.getBaseType(), anns);
        DefinitionUtil.defineScopeType(bean, anns, "Bean producer method : " + method.getJavaMember().getName() + " in class " + parent.getReturnType().getName() + " must declare default @Scope annotation");
        WebBeansUtil.checkProducerGenericType(bean, method.getJavaMember());
        DefinitionUtil.defineQualifiers(bean, anns);
        DefinitionUtil.defineName(bean, anns, WebBeansUtil.getProducerDefaultName(method.getJavaMember().getName()));
        return bean;
    }
}

