/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectableBeanManager;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.corespi.se.DefaultJndiService;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.plugins.OpenWebBeansJavaEEPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansWebPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.apache.webbeans.xml.XMLAnnotationTypeManager;
import org.apache.webbeans.xml.XMLSpecializesManager;

public class BeansDeployer {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(BeansDeployer.class);
    protected boolean deployed = false;
    protected WebBeansXMLConfigurator xmlConfigurator = null;
    protected boolean discoverEjb = false;

    public BeansDeployer(WebBeansXMLConfigurator xmlConfigurator) {
        this.xmlConfigurator = xmlConfigurator;
        String usage = OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService");
        this.discoverEjb = Boolean.parseBoolean(usage);
    }

    public void deploy(ScannerService scanner) {
        try {
            if (!this.deployed) {
                ExtensionLoader.getInstance().loadExtensionServices();
                JNDIService service = ServiceLoader.getService(JNDIService.class);
                if (service instanceof DefaultJndiService) {
                    service.bind("java:comp/BeanManager", (Object)new InjectableBeanManager());
                } else {
                    service.bind("java:comp/BeanManager", (Object)BeanManagerImpl.getManager().getReference());
                }
                BeanManagerImpl.getManager().addBean(WebBeansUtil.getManagerBean());
                this.fireBeforeBeanDiscoveryEvent();
                this.deployFromXML(scanner);
                this.checkStereoTypes(scanner);
                this.configureDefaultBeans();
                this.deployFromClassPath(scanner);
                this.checkSpecializations(scanner);
                this.fireAfterBeanDiscoveryEvent();
                this.validateInjectionPoints();
                this.fireAfterDeploymentValidationEvent();
                this.deployed = true;
            }
        }
        catch (Exception e) {
            this.logger.error(e);
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    private void configureDefaultBeans() {
        BeanManagerImpl beanManager = BeanManagerImpl.getManager();
        beanManager.addBean(WebBeansUtil.getConversationBean());
        beanManager.addBean(WebBeansUtil.getInjectionPointBean());
        beanManager.addBean(WebBeansUtil.getInstanceBean());
        beanManager.addBean(WebBeansUtil.getEventBean());
        OpenWebBeansJavaEEPlugin beanEeProvider = PluginLoader.getInstance().getJavaEEPlugin();
        OpenWebBeansWebPlugin beanWebProvider = PluginLoader.getInstance().getWebPlugin();
        if (beanEeProvider != null) {
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.common.beans.PrinicipalBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.ValidatorFactoryBean");
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.beans.UserTransactionBean");
        } else if (beanWebProvider != null) {
            this.addDefaultBean(beanManager, "org.apache.webbeans.ee.common.beans.PrinicipalBean");
        }
    }

    private void addDefaultBean(BeanManagerImpl manager, String className) {
        Bean bean = null;
        Class<?> beanClass = ClassUtil.getClassFromName(className);
        if (beanClass != null) {
            bean = (Bean)ClassUtil.newInstance(beanClass);
        }
        if (bean != null) {
            manager.addBean(bean);
        }
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new BeforeBeanDiscoveryImpl(), new Annotation[0]);
    }

    private void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new AfterBeanDiscoveryImpl(), new Annotation[0]);
        WebBeansUtil.inspectErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
    }

    private void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new AfterDeploymentValidationImpl(), new Annotation[0]);
        WebBeansUtil.inspectErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
    }

    private void validateInjectionPoints() {
        this.logger.debug("Validation of injection points has started.");
        DecoratorsManager.getInstance().validateDecoratorClasses();
        InterceptorsManager.getInstance().validateInterceptorClasses();
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        Set<Bean<?>> beans = new HashSet();
        Set<Decorator<?>> decorators = manager.getDecorators();
        for (Decorator<?> decorator : decorators) {
            WebBeansDecorator wbDec = (WebBeansDecorator)decorator;
            beans.add(wbDec);
        }
        this.logger.debug("Validation of the decorator's injection points has started.");
        this.validate(beans);
        beans.clear();
        Set<Interceptor<?>> interceptors = manager.getInterceptors();
        for (Interceptor<?> interceptor : interceptors) {
            WebBeansInterceptor wbInt = (WebBeansInterceptor)interceptor;
            beans.add(wbInt);
        }
        this.logger.debug("Validation of the interceptor's injection points has started.");
        this.validate(beans);
        beans.clear();
        beans = manager.getBeans();
        this.validate(beans);
        this.logger.info("INFO_0003");
    }

    private void validate(Set<Bean<?>> beans) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        if (beans != null && beans.size() > 0) {
            Stack<String> beanNames = new Stack<String>();
            for (Bean<?> bean : beans) {
                String beanName = bean.getName();
                if (beanName != null) {
                    beanNames.push(beanName);
                }
                if (bean instanceof InjectionTargetBean) {
                    if (!(bean instanceof Decorator || bean instanceof Interceptor || bean instanceof NewBean)) {
                        DefinitionUtil.defineDecoratorStack((AbstractInjectionTargetBean)bean);
                    }
                    if (bean instanceof InterceptedMarker) {
                        DefinitionUtil.defineBeanInterceptorStack((AbstractInjectionTargetBean)bean);
                    }
                }
                this.checkPassivationScope(bean);
                Set injectionPoints = bean.getInjectionPoints();
                if (injectionPoints == null) continue;
                for (InjectionPoint injectionPoint : injectionPoints) {
                    if (!injectionPoint.isDelegate()) {
                        manager.validate(injectionPoint);
                        continue;
                    }
                    if (bean.getBeanClass().isAnnotationPresent(javax.decorator.Decorator.class) || BeanManagerImpl.getManager().containsCustomDecoratorClass(bean.getBeanClass())) continue;
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
            }
            this.validateBeanNames(beanNames);
            beanNames.clear();
        }
    }

    private void validateBeanNames(Stack<String> beanNames) {
        if (beanNames.size() > 0) {
            for (String beanName : beanNames) {
                for (String other : beanNames) {
                    String part = null;
                    int i = beanName.lastIndexOf(46);
                    if (i != -1) {
                        part = beanName.substring(0, i);
                    }
                    if (beanName.equals(other)) {
                        InjectionResolver resolver = InjectionResolver.getInstance();
                        Set<Bean<?>> beans = resolver.implResolveByName(beanName);
                        if (beans.size() <= 1 || (beans = resolver.findByAlternatives(beans)).size() <= 1) continue;
                        throw new WebBeansConfigurationException("There are two different beans with name : " + beanName + " in the deployment archieve");
                    }
                    if (part == null || !part.equals(other)) continue;
                    throw new WebBeansConfigurationException("EL name of one bean is of the form x.y, where y is a valid bean EL name, and x is the EL name of the other bean for the bean name : " + beanName);
                }
            }
        }
    }

    protected void deployFromClassPath(ScannerService scanner) throws ClassNotFoundException {
        this.logger.debug("Deploying configurations from class files has started.");
        Set classIndex = scanner.getBeanClasses();
        if (classIndex != null) {
            for (Class implClass : classIndex) {
                boolean isDefined;
                AnnotatedType annotatedType = AnnotatedElementFactory.getInstance().newAnnotatedType(implClass);
                GProcessAnnotatedType processAnnotatedEvent = WebBeansUtil.fireProcessAnnotatedTypeEvent(annotatedType);
                if (processAnnotatedEvent.isVeto() || (isDefined = this.defineManagedBean(implClass, processAnnotatedEvent)) || !this.discoverEjb || !EJBWebBeansConfigurator.isSessionBean(implClass)) continue;
                this.logger.debug("Found Enterprise Bean with class name : [{0}]", implClass.getName());
                this.defineEnterpriseWebBean(implClass, processAnnotatedEvent);
            }
        }
        this.logger.debug("Deploying configurations from class files has ended.");
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
        this.logger.debug("Deploying configurations from XML files has started.");
        Set xmlLocations = scanner.getBeanXmls();
        for (URL fileURL : xmlLocations) {
            String fileName = fileURL.getFile();
            InputStream fis = null;
            try {
                fis = fileURL.openStream();
                this.xmlConfigurator.configure(fis, fileName);
            }
            catch (IOException e) {
                throw new WebBeansDeploymentException(e);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        this.logger.debug("Deploying configurations from XML has ended successfully.");
    }

    protected void checkSpecializations(ScannerService scanner) {
        this.logger.debug("Checking Specialization constraints has started.");
        try {
            Set beanClasses = scanner.getBeanClasses();
            if (beanClasses != null && beanClasses.size() > 0) {
                Class superClass = null;
                ArrayList superClassList = new ArrayList();
                ArrayList specialClassList = new ArrayList();
                for (Class specialClass : beanClasses) {
                    if (!AnnotationUtil.hasClassAnnotation(specialClass, Specializes.class)) continue;
                    superClass = specialClass.getSuperclass();
                    if (superClass.equals(Object.class)) {
                        throw new WebBeansConfigurationException(this.logger.getTokenString("EXCEPT_0003") + specialClass.getName() + this.logger.getTokenString("EXCEPT_0004"));
                    }
                    if (superClassList.contains(superClass)) {
                        throw new InconsistentSpecializationException(this.logger.getTokenString("EXCEPT_0005") + superClass.getName());
                    }
                    superClassList.add(superClass);
                    specialClassList.add(specialClass);
                }
                WebBeansUtil.configureSpecializations(specialClassList);
            }
            this.checkXMLSpecializations();
            WebBeansUtil.configureProducerMethodSpecializations();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
        this.logger.debug("Checking Specialization constraints has ended.");
    }

    protected void checkXMLSpecializations() {
        Set<Class<?>> clazzes = XMLSpecializesManager.getInstance().getXMLSpecializationClasses();
        Iterator<Class<?>> it = clazzes.iterator();
        Class<?> superClass = null;
        Class<?> specialClass = null;
        ArrayList specialClassList = new ArrayList();
        while (it.hasNext()) {
            specialClass = it.next();
            if (superClass == null) {
                superClass = specialClass.getSuperclass();
            } else if (superClass.equals(specialClass.getSuperclass())) {
                throw new InconsistentSpecializationException(this.logger.getTokenString("EXCEPT_XML") + this.logger.getTokenString("EXCEPT_0005") + superClass.getName());
            }
            specialClassList.add(specialClass);
        }
        WebBeansUtil.configureSpecializations(specialClassList);
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        boolean validate = false;
        if (EnterpriseBeanMarker.class.isAssignableFrom(beanObj.getClass())) {
            EnterpriseBeanMarker marker = (EnterpriseBeanMarker)beanObj;
            if (marker.isPassivationCapable()) {
                validate = true;
            }
        } else if (BeanManagerImpl.getManager().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.isPassivationCapable(beanObj) == null) {
                if (!(beanObj instanceof AbstractProducerBean)) {
                    throw new WebBeansConfigurationException("Passivation scoped defined bean must be passivation capable, but bean : " + beanObj.toString() + " is not passivation capable");
                }
                validate = true;
            }
            validate = true;
        }
        if (validate) {
            ((OwbBean)beanObj).validatePassivationDependencies();
        }
    }

    protected void checkStereoTypes(ScannerService scanner) {
        this.logger.debug("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        Set beanClasses = scanner.getBeanClasses();
        if (beanClasses != null && beanClasses.size() > 0) {
            for (Class beanClass : beanClasses) {
                Class stereoClass;
                if (!beanClass.isAnnotation() || !AnnotationUtil.isStereoTypeAnnotation(stereoClass = beanClass) || XMLAnnotationTypeManager.getInstance().hasStereoType(stereoClass)) continue;
                WebBeansUtil.checkStereoTypeClass(stereoClass);
                StereoTypeModel model = new StereoTypeModel(stereoClass);
                StereoTypeManager.getInstance().addStereoTypeModel(model);
            }
        }
        this.logger.debug("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(Model.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
        model = new StereoTypeModel(javax.decorator.Decorator.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
        model = new StereoTypeModel(javax.interceptor.Interceptor.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
    }

    protected <T> boolean defineManagedBean(Class<T> clazz, ProcessAnnotatedTypeImpl<T> processAnnotatedEvent) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        AnnotatedType<T> annotatedType = processAnnotatedEvent.getAnnotatedType();
        GProcessInjectionTarget processInjectionTargetEvent = null;
        if (WebBeansUtil.supportsJavaEeComponentInjections(clazz)) {
            processInjectionTargetEvent = WebBeansUtil.fireProcessInjectionTargetEventForJavaEeComponents(clazz);
            WebBeansUtil.inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
            if (processInjectionTargetEvent.isSet()) {
                manager.putInjectionTargetWrapperForJavaEeComponents(clazz, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
            }
            OWBInjector.checkInjectionPointForInjectInjectionPoint(clazz);
        }
        if (ManagedBeanConfigurator.isManagedBean(clazz)) {
            ManagedBeanConfigurator.checkManagedBeanCondition(clazz);
            ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED);
            ManagedBeanCreatorImpl<T> managedBeanCreator = new ManagedBeanCreatorImpl<T>(managedBean);
            boolean annotationTypeSet = false;
            if (processAnnotatedEvent.isSet()) {
                annotationTypeSet = true;
                managedBean.setAnnotatedType(annotatedType);
                annotatedType = processAnnotatedEvent.getAnnotatedType();
                managedBeanCreator.setAnnotatedType(annotatedType);
                managedBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
            }
            if (processInjectionTargetEvent == null) {
                processInjectionTargetEvent = WebBeansUtil.fireProcessInjectionTargetEvent(managedBean);
            }
            if (WebBeansAnnotatedTypeUtil.isAnnotatedTypeDecorator(annotatedType)) {
                if (this.logger.wblWillLogDebug()) {
                    this.logger.debug("Found Managed Bean Decorator with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                if (annotationTypeSet) {
                    WebBeansAnnotatedTypeUtil.defineDecorator(annotatedType);
                } else {
                    WebBeansUtil.defineDecorator(managedBeanCreator, processInjectionTargetEvent);
                }
            } else if (WebBeansAnnotatedTypeUtil.isAnnotatedTypeInterceptor(annotatedType)) {
                if (this.logger.wblWillLogDebug()) {
                    this.logger.debug("Found Managed Bean Interceptor with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                if (annotationTypeSet) {
                    WebBeansAnnotatedTypeUtil.defineInterceptor(annotatedType);
                } else {
                    WebBeansUtil.defineInterceptor(managedBeanCreator, processInjectionTargetEvent);
                }
            } else {
                if (BeanManagerImpl.getManager().containsCustomDecoratorClass(annotatedType.getJavaClass()) || BeanManagerImpl.getManager().containsCustomInterceptorClass(annotatedType.getJavaClass())) {
                    return false;
                }
                if (this.logger.wblWillLogDebug()) {
                    this.logger.debug("Found Managed Bean with class name : [{0}]", annotatedType.getJavaClass().getName());
                }
                WebBeansUtil.defineManagedBean(managedBeanCreator, processInjectionTargetEvent);
            }
            return true;
        }
        return false;
    }

    protected <T> void defineEnterpriseWebBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        InjectionTargetBean bean = (InjectionTargetBean)EJBWebBeansConfigurator.defineEjbBean(clazz, processAnnotatedTypeEvent);
        WebBeansUtil.setInjectionTargetBeanEnableFlag(bean);
    }
}

