/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.portable.AnnotatedFieldImpl;
import org.apache.webbeans.portable.AnnotatedMethodImpl;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.SecurityUtil;

public final class AnnotatedElementFactory {
    private static ConcurrentMap<Class<?>, AnnotatedType<?>> annotatedTypeCache = new ConcurrentHashMap();
    private static ConcurrentMap<Constructor<?>, AnnotatedConstructor<?>> annotatedConstructorCache = new ConcurrentHashMap();
    private static ConcurrentMap<Method, AnnotatedMethod<?>> annotatedMethodCache = new ConcurrentHashMap();
    private static ConcurrentMap<Field, AnnotatedField<?>> annotatedFieldCache = new ConcurrentHashMap();

    private AnnotatedElementFactory() {
    }

    public static <X> AnnotatedType<X> newAnnotatedType(Class<X> annotatedClass) {
        Asserts.assertNotNull(annotatedClass, "annotatedClass is null");
        AnnotatedTypeImpl<X> annotatedType = null;
        if (annotatedTypeCache.containsKey(annotatedClass)) {
            annotatedType = (AnnotatedTypeImpl<X>)annotatedTypeCache.get(annotatedClass);
        } else {
            annotatedType = new AnnotatedTypeImpl<X>(annotatedClass);
            Field[] fields = SecurityUtil.doPrivilegedGetDeclaredFields(annotatedClass);
            Method[] methods = SecurityUtil.doPrivilegedGetDeclaredMethods(annotatedClass);
            Constructor<X>[] ctxs = SecurityUtil.doPrivilegedGetDeclaredConstructors(annotatedClass);
            for (Field field : fields) {
                AnnotatedFieldImpl<X> af = new AnnotatedFieldImpl<X>(field, annotatedType);
                annotatedType.addAnnotatedField(af);
            }
            for (AccessibleObject accessibleObject : methods) {
                AnnotatedMethodImpl<X> am = new AnnotatedMethodImpl<X>((Method)accessibleObject, annotatedType);
                annotatedType.addAnnotatedMethod(am);
            }
            for (AccessibleObject accessibleObject : ctxs) {
                AnnotatedConstructorImpl<X> ac = new AnnotatedConstructorImpl<X>(accessibleObject, annotatedType);
                annotatedType.addAnnotatedConstructor(ac);
            }
            AnnotatedTypeImpl<X> oldType = annotatedTypeCache.putIfAbsent(annotatedClass, annotatedType);
            if (oldType != null) {
                annotatedType = oldType;
            }
        }
        return annotatedType;
    }

    public static <X> AnnotatedConstructor<X> newAnnotatedConstructor(Constructor<X> constructor, AnnotatedType<X> declaringClass) {
        Asserts.assertNotNull(constructor, "constructor is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        AnnotatedConstructorImpl<X> annConstructor = null;
        if (annotatedConstructorCache.containsKey(constructor)) {
            annConstructor = (AnnotatedConstructorImpl<X>)annotatedConstructorCache.get(constructor);
        } else {
            annConstructor = new AnnotatedConstructorImpl<X>(constructor, declaringClass);
            AnnotatedConstructorImpl<X> old = annotatedConstructorCache.putIfAbsent(constructor, annConstructor);
            if (old != null) {
                annConstructor = old;
            }
        }
        return annConstructor;
    }

    public static <X> AnnotatedField<X> newAnnotatedField(Field field, AnnotatedType<X> declaringClass) {
        Asserts.assertNotNull(field, "field is null");
        Asserts.assertNotNull(declaringClass, "declaringClass is null");
        AnnotatedFieldImpl<X> annotField = null;
        if (annotatedFieldCache.containsKey(field)) {
            annotField = (AnnotatedFieldImpl<X>)annotatedFieldCache.get(field);
        } else {
            annotField = new AnnotatedFieldImpl<X>(field, declaringClass);
            AnnotatedFieldImpl<X> old = annotatedFieldCache.putIfAbsent(field, annotField);
            if (old != null) {
                annotField = old;
            }
        }
        return annotField;
    }

    public static <X> AnnotatedMethod<X> newAnnotatedMethod(Method method, AnnotatedType<X> declaringType) {
        Asserts.assertNotNull(method, "method is null");
        Asserts.assertNotNull(declaringType, "declaringType is null");
        AnnotatedMethodImpl<X> annotMethod = null;
        if (annotatedMethodCache.containsKey(method)) {
            annotMethod = (AnnotatedMethodImpl<X>)annotatedMethodCache.get(method);
        } else {
            annotMethod = new AnnotatedMethodImpl<X>(method, declaringType);
            AnnotatedMethodImpl<X> old = annotatedMethodCache.putIfAbsent(method, annotMethod);
            if (old != null) {
                annotMethod = old;
            }
        }
        return annotMethod;
    }

    public static void clear() {
        annotatedTypeCache.clear();
        annotatedConstructorCache.clear();
        annotatedFieldCache.clear();
        annotatedMethodCache.clear();
    }
}

