/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.el;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public class ELContextStore {
    public static ThreadLocal<ELContextStore> localContext = new ThreadLocal();
    private Map<Bean<?>, CreationalStore> dependentObjects = new HashMap();

    public void addDependent(Bean<?> bean, Object dependent, CreationalContext<?> creationalContext) {
        if (bean.getScope().equals(Dependent.class)) {
            this.dependentObjects.put(bean, new CreationalStore(dependent, creationalContext));
        }
    }

    public Object getDependent(Bean<?> bean) {
        if (this.dependentObjects.containsKey(bean)) {
            return this.dependentObjects.get(bean).getObject();
        }
        return null;
    }

    public boolean isExist(Bean<?> bean) {
        return this.dependentObjects.containsKey(bean);
    }

    public void destroy() {
        Set<Bean<?>> beans = this.dependentObjects.keySet();
        Iterator<Bean<?>> i$ = beans.iterator();
        while (i$.hasNext()) {
            Bean<?> bean;
            Bean<?> o = bean = i$.next();
            CreationalStore store = this.dependentObjects.get(bean);
            o.destroy(store.getObject(), store.getCreational());
        }
        this.dependentObjects.clear();
    }

    private static class CreationalStore {
        private Object object;
        private CreationalContext<?> creational;

        public CreationalStore(Object object, CreationalContext<?> creational) {
            this.object = object;
            this.creational = creational;
        }

        public Object getObject() {
            return this.object;
        }

        public CreationalContext<?> getCreational() {
            return this.creational;
        }
    }
}

