/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.Asserts;

public class ConversationImpl
implements Conversation {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ConversationImpl.class);
    private String id;
    private boolean isTransient = true;
    private long timeout = 1800000L;
    private String sessionId;
    private long activeTime = 0L;
    private static AtomicInteger conversationIdGenerator = new AtomicInteger(0);
    private AtomicBoolean inUsed = new AtomicBoolean(false);

    public ConversationImpl() {
    }

    public ConversationImpl(String sessionId) {
        Asserts.assertNotNull(sessionId);
        this.sessionId = sessionId;
    }

    public void begin() {
        if (this.isTransient) {
            this.isTransient = false;
            this.id = Integer.toString(conversationIdGenerator.incrementAndGet());
            ConversationManager manager = ConversationManager.getInstance();
            try {
                manager.addConversationContext(this, (ConversationContext)BeanManagerImpl.getManager().getContext(ConversationScoped.class));
            }
            catch (Exception e) {
                manager.addConversationContext(this, new ConversationContext());
            }
        } else {
            logger.warn("WARN_0003", this.id);
            throw new IllegalStateException();
        }
    }

    public void begin(String id) {
        if (ConversationManager.getInstance().isConversationExistWithGivenId(id)) {
            throw new IllegalArgumentException("Conversation with id=" + id + " is already exist!");
        }
        if (this.isTransient) {
            this.isTransient = false;
            this.id = id;
            this.updateTimeOut();
            ConversationManager.getInstance().addConversationContext(this, (ConversationContext)BeanManagerImpl.getManager().getContext(ConversationScoped.class));
        }
    }

    public void end() {
        if (this.isTransient) {
            logger.warn("WARN_0004", this.id);
            throw new IllegalStateException();
        }
        this.isTransient = true;
        ConversationManager.getInstance().removeConversation(this);
    }

    public AtomicBoolean getInUsed() {
        return this.inUsed;
    }

    public void setInUsed(boolean inUsed) {
        this.inUsed.set(inUsed);
    }

    public void setTransient(boolean value) {
        this.isTransient = value;
    }

    public String getId() {
        return this.id;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTimeout(long milliseconds) {
        this.timeout = milliseconds;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getActiveTime() {
        return this.activeTime;
    }

    public void updateTimeOut() {
        this.activeTime = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.sessionId == null ? 0 : this.sessionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConversationImpl other = (ConversationImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.sessionId == null ? other.sessionId != null : !this.sessionId.equals(other.sessionId));
    }
}

