/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ExtensionLoader {
    private Map<Bean<?>, Object> extensions = new ConcurrentHashMap();

    public static ExtensionLoader getInstance() {
        ExtensionLoader loader = (ExtensionLoader)WebBeansFinder.getSingletonInstance(ExtensionLoader.class.getName());
        return loader;
    }

    public void loadExtensionServices() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class, WebBeansUtil.getCurrentClassLoader());
        for (Extension ext : loader) {
            try {
                this.addExtension(ext);
            }
            catch (Exception e) {
                throw new WebBeansException("Error is occured while reading Extension service list", e);
            }
        }
    }

    public <T> T getBeanInstance(Bean<T> bean) {
        Asserts.assertNotNull(bean, "bean parameter cannot be null");
        if (this.extensions.containsKey(bean)) {
            return (T)this.extensions.get(bean);
        }
        return null;
    }

    public void addExtension(Extension ext) {
        ExtensionBean<?> bean = WebBeansUtil.createExtensionComponent(ext.getClass());
        this.extensions.put(bean, ext);
        BeanManagerImpl.getManager().addBean(bean);
    }

    public void clear() {
        this.extensions.clear();
    }
}

