/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ObserverMethod;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ObserverMethodImpl<T>
implements ObserverMethod<T> {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ObserverMethodImpl.class);
    private final InjectionTargetBean<?> bean;
    private final Method observerMethod;
    private final boolean ifExist;
    private final Set<Annotation> observedQualifiers;
    private final Type observedEventType;
    private final TransactionPhase phase;

    public ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        Annotation[] qualifiers = AnnotationUtil.getMethodFirstParameterQualifierWithGivenAnnotation(observerMethod, Observes.class);
        AnnotationUtil.checkQualifierConditions(qualifiers);
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = AnnotationUtil.getTypeOfParameterWithGivenAnnotation(observerMethod, Observes.class);
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    protected ObserverMethodImpl(InjectionTargetBean<?> bean, Method observerMethod, boolean ifExist, Annotation[] qualifiers, Type observedEventType) {
        this.bean = bean;
        this.observerMethod = observerMethod;
        this.ifExist = ifExist;
        this.observedQualifiers = new HashSet<Annotation>(qualifiers.length);
        for (Annotation qualifier : qualifiers) {
            this.observedQualifiers.add(qualifier);
        }
        this.observedEventType = observedEventType;
        this.phase = EventUtil.getObserverMethodTransactionType(observerMethod);
    }

    public void notify(T event) {
        logger.trace("Notifying with event payload : ", new Object[]{event.toString()});
        AbstractOwbBean baseComponent = (AbstractOwbBean)((Object)this.bean);
        AbstractOwbBean specializedComponent = null;
        Object object = null;
        CreationalContext creationalContext = null;
        List<ObserverParams> methodArgsMap = this.getMethodArguments(event);
        ObserverParams[] obargs = null;
        try {
            if (!this.observerMethod.isAccessible()) {
                this.observerMethod.setAccessible(true);
            }
            obargs = new ObserverParams[methodArgsMap.size()];
            obargs = methodArgsMap.toArray(obargs);
            Object[] args = new Object[obargs.length];
            int i = 0;
            for (ObserverParams param : obargs) {
                args[i++] = param.instance;
            }
            if (Modifier.isStatic(this.observerMethod.getModifiers())) {
                this.observerMethod.invoke(object, args);
            } else {
                BeanManagerImpl manager = BeanManagerImpl.getManager();
                specializedComponent = (AbstractOwbBean)WebBeansUtil.getMostSpecializedBean(manager, baseComponent);
                Context context = manager.getContext(specializedComponent.getScope());
                creationalContext = manager.createCreationalContext(specializedComponent);
                if (this.ifExist && context.get((Contextual)specializedComponent) == null) {
                    return;
                }
                object = manager.getReference(specializedComponent, specializedComponent.getBeanClass(), creationalContext);
                if (object != null) {
                    this.observerMethod.invoke(object, args);
                }
            }
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
        finally {
            if (baseComponent.getScope().equals(Dependent.class)) {
                baseComponent.destroy(object, creationalContext);
            }
            if (methodArgsMap != null) {
                for (ObserverParams param : obargs) {
                    if (!param.isBean) continue;
                    param.bean.destroy(param.instance, param.creational);
                }
            }
        }
    }

    protected List<ObserverParams> getMethodArguments(Object event) {
        Type[] types = this.observerMethod.getGenericParameterTypes();
        Annotation[][] annots = this.observerMethod.getParameterAnnotations();
        ArrayList<ObserverParams> list = new ArrayList<ObserverParams>();
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        ObserverParams param = null;
        if (types.length > 0) {
            int i = 0;
            for (Type type : types) {
                Annotation[] annot = annots[i];
                boolean observesAnnotation = false;
                if (annot.length == 0) {
                    annot = new Annotation[]{new DefaultLiteral()};
                } else {
                    for (Annotation observersAnnot : annot) {
                        if (!observersAnnot.annotationType().equals(Observes.class)) continue;
                        param = new ObserverParams();
                        param.instance = event;
                        list.add(param);
                        observesAnnotation = true;
                        break;
                    }
                }
                if (!observesAnnotation) {
                    Annotation[] bindingTypes = AnnotationUtil.getQualifierAnnotations(annot);
                    if (bindingTypes.length > 0) {
                        InjectionPoint point = InjectionPointFactory.getPartialInjectionPoint(null, type, null, null, bindingTypes);
                        Bean<?> bean = InjectionResolver.getInstance().getInjectionPointBean(point);
                        CreationalContext<?> creational = manager.createCreationalContext(bean);
                        Object instance = manager.getInstance(bean, creational);
                        param = new ObserverParams();
                        param.isBean = true;
                        param.creational = creational;
                        param.instance = instance;
                        param.bean = bean;
                        list.add(param);
                    } else {
                        param = new ObserverParams();
                        list.add(param);
                    }
                }
                ++i;
            }
        }
        return list;
    }

    public Class<?> getBeanClass() {
        AbstractInjectionTargetBean abs = (AbstractInjectionTargetBean)this.bean;
        return abs.getBeanClass();
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.observedQualifiers;
    }

    public Type getObservedType() {
        return this.observedEventType;
    }

    public Reception getReception() {
        return this.ifExist ? Reception.IF_EXISTS : Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return this.phase;
    }

    public Method getObserverMethod() {
        return this.observerMethod;
    }

    private static class ObserverParams {
        private Bean<Object> bean;
        private Object instance;
        private CreationalContext<Object> creational;
        private boolean isBean = false;

        private ObserverParams() {
        }
    }
}

