/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.component.javaee.PrinicipalBean;
import org.apache.webbeans.component.javaee.ValidatorBean;
import org.apache.webbeans.component.javaee.ValidatorFactoryBean;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.deployment.StereoTypeManager;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.discovery.AfterBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.discovery.AfterDeploymentValidationImpl;
import org.apache.webbeans.portable.events.discovery.BeforeBeanDiscoveryImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.ServiceLoader;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;
import org.apache.webbeans.xml.XMLAnnotationTypeManager;
import org.apache.webbeans.xml.XMLSpecializesManager;

public class BeansDeployer {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(BeansDeployer.class);
    protected boolean deployed = false;
    protected WebBeansXMLConfigurator xmlConfigurator = null;
    protected boolean discoverEjb = false;

    public BeansDeployer(WebBeansXMLConfigurator xmlConfigurator) {
        this.xmlConfigurator = xmlConfigurator;
        String usage = OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.spi.deployer.UseEjbMetaDataDiscoveryService");
        this.discoverEjb = Boolean.parseBoolean(usage);
    }

    public void deploy(ScannerService scanner) {
        try {
            if (!this.deployed) {
                ExtensionLoader.getInstance().loadExtensionServices();
                JNDIService service = ServiceLoader.getService(JNDIService.class);
                service.bind("java:comp/BeanManager", (Object)BeanManagerImpl.getManager());
                BeanManagerImpl.getManager().addBean(WebBeansUtil.getManagerBean());
                this.fireBeforeBeanDiscoveryEvent();
                this.deployFromXML(scanner);
                this.checkStereoTypes(scanner);
                this.configureDefaultBeans();
                this.deployFromClassPath(scanner);
                this.checkSpecializations(scanner);
                this.fireAfterBeanDiscoveryEvent();
                this.validateInjectionPoints();
                this.fireAfterDeploymentValidationEvent();
                this.deployed = true;
            }
        }
        catch (WebBeansConfigurationException e) {
            logger.error(e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e);
            if (e instanceof WebBeansDeploymentException) {
                throw (WebBeansDeploymentException)e;
            }
            throw new WebBeansDeploymentException(e);
        }
    }

    private void configureDefaultBeans() {
        BeanManagerImpl beanManager = BeanManagerImpl.getManager();
        beanManager.addBean(WebBeansUtil.getConversationBean());
        beanManager.addBean(WebBeansUtil.getInjectionPointBean());
        beanManager.addBean(WebBeansUtil.getInstanceBean());
        beanManager.addBean(WebBeansUtil.getEventBean());
        beanManager.addBean(new ValidatorBean());
        beanManager.addBean(new ValidatorFactoryBean());
        beanManager.addBean(new PrinicipalBean());
    }

    private void fireBeforeBeanDiscoveryEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new BeforeBeanDiscoveryImpl(), new Annotation[0]);
    }

    private void fireAfterBeanDiscoveryEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new AfterBeanDiscoveryImpl(), new Annotation[0]);
        WebBeansUtil.inspectErrorStack("There are errors that are added by AfterBeanDiscovery event observers. Look at logs for further details");
    }

    private void fireAfterDeploymentValidationEvent() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        manager.fireEvent(new AfterDeploymentValidationImpl(), new Annotation[0]);
        WebBeansUtil.inspectErrorStack("There are errors that are added by AfterDeploymentValidation event observers. Look at logs for further details");
    }

    private void validateInjectionPoints() {
        logger.debug("Validation of injection points has started.");
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        Set<Bean<?>> beans = new HashSet();
        Set<Decorator<?>> decorators = manager.getDecorators();
        for (Decorator<?> decorator : decorators) {
            WebBeansDecorator wbDec = (WebBeansDecorator)decorator;
            beans.add(wbDec);
        }
        logger.debug("Validation of the decorator's injection points has started.");
        this.validate(beans);
        beans.clear();
        Set<Interceptor<?>> interceptors = manager.getInterceptors();
        for (Interceptor<?> interceptor : interceptors) {
            WebBeansInterceptor wbInt = (WebBeansInterceptor)interceptor;
            beans.add(wbInt);
        }
        logger.debug("Validation of the interceptor's injection points has started.");
        this.validate(beans);
        beans.clear();
        beans = manager.getBeans();
        this.validate(beans);
        logger.info("INFO_0008");
    }

    private void validate(Set<Bean<?>> beans) {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        if (beans != null && beans.size() > 0) {
            for (Bean<?> bean : beans) {
                if (bean instanceof AbstractInjectionTargetBean && !(bean instanceof NewBean)) {
                    if (!(bean instanceof Decorator) && !(bean instanceof Interceptor)) {
                        DefinitionUtil.defineDecoratorStack((AbstractInjectionTargetBean)bean);
                    }
                    if (!(bean instanceof Interceptor) && !(bean instanceof NewBean)) {
                        DefinitionUtil.defineBeanInterceptorStack((AbstractInjectionTargetBean)bean);
                    }
                }
                this.checkPassivationScope(bean);
                Set injectionPoints = bean.getInjectionPoints();
                if (injectionPoints == null) continue;
                for (InjectionPoint injectionPoint : injectionPoints) {
                    if (!injectionPoint.isDelegate()) {
                        manager.validate(injectionPoint);
                        continue;
                    }
                    if (bean.getBeanClass().isAnnotationPresent(javax.decorator.Decorator.class)) continue;
                    throw new WebBeansConfigurationException("Delegate injection points can not defined by beans that are not decorator. Injection point : " + injectionPoint);
                }
            }
        }
    }

    protected void deployFromClassPath(ScannerService scanner) throws ClassNotFoundException {
        logger.debug("Deploying configurations from class files has started.");
        Set classIndex = scanner.getBeanClasses();
        if (classIndex != null) {
            for (Class implClass : classIndex) {
                if (ManagedBeanConfigurator.isManagedBean(implClass)) {
                    ManagedBeanConfigurator.checkManagedBeanCondition(implClass);
                    this.defineManagedBean(implClass);
                    continue;
                }
                if (!this.discoverEjb || !EJBWebBeansConfigurator.isSessionBean(implClass)) continue;
                logger.info("INFO_0010", new Object[]{implClass.getName()});
                this.defineEnterpriseWebBean(implClass);
            }
        }
        logger.debug("Deploying configurations from class files has ended.");
    }

    protected void deployFromXML(ScannerService scanner) throws WebBeansDeploymentException {
        logger.debug("Deploying configurations from XML files has started.");
        Set xmlLocations = scanner.getBeanXmls();
        for (URL fileURL : xmlLocations) {
            String fileName = fileURL.getFile();
            InputStream fis = null;
            try {
                fis = fileURL.openStream();
                this.xmlConfigurator.configure(fis, fileName);
            }
            catch (IOException e) {
                throw new WebBeansDeploymentException(e);
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        logger.debug("Deploying configurations from XML has ended successfully.");
    }

    protected void checkSpecializations(ScannerService scanner) {
        logger.debug("Checking Specialization constraints has started.");
        try {
            Set beanClasses = scanner.getBeanClasses();
            if (beanClasses != null && beanClasses.size() > 0) {
                Class superClass = null;
                ArrayList superClassList = new ArrayList();
                ArrayList specialClassList = new ArrayList();
                for (Class specialClass : beanClasses) {
                    if (!AnnotationUtil.hasClassAnnotation(specialClass, Specializes.class)) continue;
                    superClass = specialClass.getSuperclass();
                    if (superClass.equals(Object.class)) {
                        throw new WebBeansConfigurationException(logger.getTokenString("EXCEPT_0003") + specialClass.getName() + logger.getTokenString("EXCEPT_0004"));
                    }
                    if (superClassList.contains(superClass)) {
                        throw new InconsistentSpecializationException(logger.getTokenString("EXCEPT_0005") + superClass.getName());
                    }
                    superClassList.add(superClass);
                    specialClassList.add(specialClass);
                }
                WebBeansUtil.configureSpecializations(specialClassList);
            }
            this.checkXMLSpecializations();
            WebBeansUtil.configureProducerMethodSpecializations();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
        logger.debug("Checking Specialization constraints has ended.");
    }

    protected void checkXMLSpecializations() {
        Set<Class<?>> clazzes = XMLSpecializesManager.getInstance().getXMLSpecializationClasses();
        Iterator<Class<?>> it = clazzes.iterator();
        Class<?> superClass = null;
        Class<?> specialClass = null;
        ArrayList specialClassList = new ArrayList();
        while (it.hasNext()) {
            specialClass = it.next();
            if (superClass == null) {
                superClass = specialClass.getSuperclass();
            } else if (superClass.equals(specialClass.getSuperclass())) {
                throw new InconsistentSpecializationException(logger.getTokenString("EXCEPT_XML") + logger.getTokenString("EXCEPT_0005") + superClass.getName());
            }
            specialClassList.add(specialClass);
        }
        WebBeansUtil.configureSpecializations(specialClassList);
    }

    protected void checkPassivationScope(Bean<?> beanObj) {
        if (BeanManagerImpl.getManager().isPassivatingScope(beanObj.getScope())) {
            if (WebBeansUtil.isPassivationCapable(beanObj) == null && !(beanObj instanceof AbstractProducerBean)) {
                throw new WebBeansConfigurationException("Passivation scoped defined bean must be passivation capable, but bean : " + this.toString() + " is not passivation capable");
            }
            ((OwbBean)beanObj).validatePassivationDependencies();
        }
    }

    protected void checkStereoTypes(ScannerService scanner) {
        logger.debug("Checking StereoType constraints has started.");
        this.addDefaultStereoTypes();
        Set beanClasses = scanner.getBeanClasses();
        if (beanClasses != null && beanClasses.size() > 0) {
            for (Class beanClass : beanClasses) {
                Class stereoClass;
                if (!beanClass.isAnnotation() || !AnnotationUtil.isStereoTypeAnnotation(stereoClass = beanClass) || XMLAnnotationTypeManager.getInstance().hasStereoType(stereoClass)) continue;
                WebBeansUtil.checkStereoTypeClass(stereoClass);
                StereoTypeModel model = new StereoTypeModel(stereoClass);
                StereoTypeManager.getInstance().addStereoTypeModel(model);
            }
        }
        logger.debug("Checking StereoType constraints has ended.");
    }

    protected void addDefaultStereoTypes() {
        StereoTypeModel model = new StereoTypeModel(Model.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
        model = new StereoTypeModel(javax.decorator.Decorator.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
        model = new StereoTypeModel(javax.interceptor.Interceptor.class);
        StereoTypeManager.getInstance().addStereoTypeModel(model);
    }

    protected <T> void defineManagedBean(Class<T> clazz) {
        Object annotatedType = AnnotatedElementFactory.newAnnotatedType(clazz);
        GProcessAnnotatedType processAnnotatedEvent = WebBeansUtil.fireProcessAnnotatedTypeEvent(annotatedType);
        ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED);
        ManagedBeanCreatorImpl<T> managedBeanCreator = new ManagedBeanCreatorImpl<T>(managedBean);
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        boolean annotationTypeSet = false;
        if (processAnnotatedEvent.isSet()) {
            annotationTypeSet = true;
            managedBean.setAnnotatedType((AnnotatedType<T>)annotatedType);
            annotatedType = processAnnotatedEvent.getAnnotatedType();
            managedBeanCreator.setAnnotatedType((AnnotatedType<T>)annotatedType);
            managedBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
        }
        if (WebBeansAnnotatedTypeUtil.isAnnotatedTypeDecorator(annotatedType)) {
            logger.info("INFO_0012", new Object[]{annotatedType.getJavaClass().getName()});
            if (annotationTypeSet) {
                WebBeansAnnotatedTypeUtil.defineDecorator(annotatedType);
            } else {
                WebBeansUtil.defineDecorator(managedBeanCreator, annotatedType);
            }
        } else if (WebBeansAnnotatedTypeUtil.isAnnotatedTypeInterceptor(annotatedType)) {
            logger.info("INFO_0011", new Object[]{annotatedType.getJavaClass().getName()});
            if (annotationTypeSet) {
                WebBeansAnnotatedTypeUtil.defineInterceptor(annotatedType);
            } else {
                WebBeansUtil.defineInterceptor(managedBeanCreator, annotatedType);
            }
        } else {
            logger.info("INFO_0009", new Object[]{annotatedType.getJavaClass().getName()});
            WebBeansUtil.defineManagedBean(managedBeanCreator, annotatedType);
        }
    }

    protected <T> void defineEnterpriseWebBean(Class<T> clazz) {
        InjectionTargetBean bean = (InjectionTargetBean)EJBWebBeansConfigurator.defineEjbBean(clazz);
        WebBeansUtil.setInjectionTargetBeanEnableFlag(bean);
    }
}

