/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.SessionBeanType;
import javax.interceptor.Interceptor;
import org.apache.webbeans.ejb.component.EjbBean;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class EjbValidator {
    private EjbValidator() {
    }

    public static void validateEjbScopeType(EjbBean<?> ejbBean) {
        Asserts.assertNotNull(ejbBean, (String)"Session Bean can not be null");
        if (ejbBean.getScope() == null) {
            throw new NullPointerException("Session Bean scope can not be null");
        }
        if (ejbBean.getEjbType() == null) {
            throw new NullPointerException("Session Bean type can not be null. It must be one of @Stateless, @Stateful, @Singleton");
        }
        if (ejbBean.getEjbType().equals((Object)SessionBeanType.STATELESS)) {
            if (!ejbBean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Stateless Session Bean class : " + ejbBean.getReturnType() + " " + "can not define scope other than @Dependent");
            }
        } else if (ejbBean.getEjbType().equals((Object)SessionBeanType.SINGLETON) && !ejbBean.getScope().equals(Dependent.class) && !ejbBean.getScope().equals(ApplicationScoped.class)) {
            throw new WebBeansConfigurationException("Singleton Session Bean class : " + ejbBean.getReturnType() + " " + "can not define scope other than @Dependent or @ApplicationScoped");
        }
    }

    public static void validateDecoratorOrInterceptor(Class<?> ejbClass) {
        Asserts.assertNotNull(ejbClass, (String)"ejbClass parameter can not be null");
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Decorator.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Decorator");
        }
        if (AnnotationUtil.hasClassAnnotation(ejbClass, Interceptor.class)) {
            throw new WebBeansConfigurationException("Ejb WebBeans Component with implementation class : " + ejbClass.getName() + " can not annotated with @Interceptor");
        }
    }

    public static void validateGenericBeanType(Class<?> ejbClass, Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(ejbClass, (String)"ejbClass parameter can not be null");
        Asserts.assertNotNull(ejbClass, (String)"scopeType parameter can not be null");
        if (ClassUtil.isDefinitionConstainsTypeVariables(ejbClass) && !scopeType.equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Ejb generic bean class : " + ejbClass.getName() + "scope must be @Dependent");
        }
    }

    public static void validateObserverMethods(EjbBean<?> bean, Set<ObserverMethod<?>> observers) {
        for (ObserverMethod<?> observer : observers) {
            ObserverMethodImpl obs = (ObserverMethodImpl)observer;
            Method method = obs.getObserverMethod();
            List locals = bean.getDeploymentInfo().getBusinessLocalInterfaces();
            if (locals == null) continue;
            Iterator it = locals.iterator();
            boolean found = false;
            while (it.hasNext()) {
                Class clazz = (Class)it.next();
                List methods = ClassUtil.getClassMethodsWithTypes((Class)clazz, (String)method.getName(), Arrays.asList(method.getParameterTypes()));
                if (methods.isEmpty()) continue;
                found = true;
                break;
            }
            if (found || ClassUtil.isStatic((Integer)method.getModifiers())) continue;
            throw new WebBeansConfigurationException("Observer method : " + method.getName() + " in session bean class : " + bean.getBeanClass() + " must be business method");
        }
    }
}

