/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeTokenizerME
implements Tokenizer,
AutoCloseable {
    private final TokenizerModel model;
    private final ThreadLocal<TokenizerME> threadLocal = new ThreadLocal();

    public ThreadSafeTokenizerME(TokenizerModel model) {
        this.model = model;
    }

    private TokenizerME getTokenizer() {
        TokenizerME tokenizer = this.threadLocal.get();
        if (tokenizer == null) {
            tokenizer = new TokenizerME(this.model);
            this.threadLocal.set(tokenizer);
        }
        return tokenizer;
    }

    @Override
    public String[] tokenize(String s) {
        return this.getTokenizer().tokenize(s);
    }

    @Override
    public Span[] tokenizePos(String s) {
        return this.getTokenizer().tokenizePos(s);
    }

    public double[] getProbabilities() {
        return this.getTokenizer().getTokenProbabilities();
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

