/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.model.BaseModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUtil.class);
    private static final String BASE_URL = "https://dlcdn.apache.org/opennlp/";
    private static final String MODELS_UD_MODELS_1_0 = "models/ud-models-1.0/";
    public static final Map<String, Map<ModelType, String>> available_models;

    public static <T extends BaseModel> T downloadModel(String language, ModelType modelType, Class<T> type) throws IOException {
        String url;
        if (available_models.containsKey(language) && (url = available_models.get(language).get((Object)modelType)) != null) {
            return DownloadUtil.downloadModel(new URL(url), type);
        }
        throw new IOException("Invalid model.");
    }

    public static <T extends BaseModel> T downloadModel(URL url, Class<T> type) throws IOException {
        Path homeDirectory = Paths.get(System.getProperty("user.home") + "/.opennlp/", new String[0]);
        if (!Files.isDirectory(homeDirectory, new LinkOption[0])) {
            homeDirectory.toFile().mkdir();
        }
        String filename = url.toString().substring(url.toString().lastIndexOf("/") + 1);
        Path localFile = Paths.get(homeDirectory.toString(), filename);
        if (!Files.exists(localFile, new LinkOption[0])) {
            logger.debug("Downloading model from {} to {}.", (Object)url, (Object)localFile);
            try (InputStream in = url.openStream();){
                Files.copy(in, localFile, StandardCopyOption.REPLACE_EXISTING);
            }
            DownloadUtil.validateModel(new URL(url + ".sha512"), localFile);
            logger.debug("Download complete.");
        }
        try {
            return (T)((BaseModel)type.getConstructor(Path.class).newInstance(localFile));
        }
        catch (Exception e) {
            throw new IOException("Could not initialize Model of type " + type.getTypeName(), e);
        }
    }

    private static void validateModel(URL sha512, Path downloadedModel) throws IOException {
        String expectedChecksum;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(sha512.openStream()));){
            expectedChecksum = reader.readLine();
            if (expectedChecksum != null) {
                expectedChecksum = expectedChecksum.split("\\s")[0].trim();
            }
        }
        String actualChecksum = DownloadUtil.calculateSHA512(downloadedModel);
        if (!actualChecksum.equalsIgnoreCase(expectedChecksum)) {
            throw new IOException("SHA512 checksum validation failed. Expected: " + expectedChecksum + ", but got: " + actualChecksum);
        }
    }

    private static String calculateSHA512(Path file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);
                 DigestInputStream dis = new DigestInputStream(fis, digest);){
                byte[] buffer = new byte[4096];
                while (dis.read(buffer) != -1) {
                }
            }
            return DownloadUtil.byteArrayToHexString(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("SHA-512 algorithm not found", e);
        }
    }

    private static String byteArrayToHexString(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    static {
        try {
            available_models = new DownloadParser(new URL("https://dlcdn.apache.org/opennlp/models/ud-models-1.0/")).getAvailableModels();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Internal
    static class DownloadParser {
        private static final Pattern LINK_PATTERN = Pattern.compile("<a href=\\\"(.*?)\\\">(.*?)</a>", 34);
        private final URL indexUrl;

        DownloadParser(URL indexUrl) {
            Objects.requireNonNull(indexUrl);
            this.indexUrl = indexUrl;
        }

        Map<String, Map<ModelType, String>> getAvailableModels() {
            Matcher matcher = LINK_PATTERN.matcher(this.fetchPageIndex());
            ArrayList<String> links = new ArrayList<String>();
            while (matcher.find()) {
                links.add(matcher.group(1));
            }
            return this.toMap(links);
        }

        private Map<String, Map<ModelType, String>> toMap(List<String> links) {
            HashMap<String, Map<ModelType, String>> result = new HashMap<String, Map<ModelType, String>>();
            for (String link : links) {
                if (!link.endsWith(".bin")) continue;
                if (link.contains("de-ud")) {
                    this.addModel("de", link, result);
                    continue;
                }
                if (link.contains("en-ud")) {
                    this.addModel("en", link, result);
                    continue;
                }
                if (link.contains("it-ud")) {
                    this.addModel("it", link, result);
                    continue;
                }
                if (link.contains("nl-ud")) {
                    this.addModel("nl", link, result);
                    continue;
                }
                if (!link.contains("fr-ud")) continue;
                this.addModel("fr", link, result);
            }
            return result;
        }

        private void addModel(String locale, String link, Map<String, Map<ModelType, String>> result) {
            Map models = result.getOrDefault(locale, new HashMap());
            String url = (Serializable)(this.indexUrl.toString().endsWith("/") ? this.indexUrl : this.indexUrl + "/") + link;
            if (link.contains("sentence")) {
                models.put(ModelType.SENTENCE_DETECTOR, url);
            } else if (link.contains("tokens")) {
                models.put(ModelType.TOKENIZER, url);
            } else if (link.contains("pos")) {
                models.put(ModelType.POS, url);
            }
            result.putIfAbsent(locale, models);
        }

        private String fetchPageIndex() {
            StringBuilder html = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.indexUrl.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    html.append(line);
                }
            }
            catch (IOException e) {
                logger.error("Could not read page index from {}", (Object)this.indexUrl, (Object)e);
            }
            return html.toString();
        }
    }

    public static enum ModelType {
        TOKENIZER("token"),
        SENTENCE_DETECTOR("sent"),
        POS("pos-perceptron"),
        NAME_FINDER("ner"),
        CHUNKER("chunker"),
        PARSER("parser-chunking");

        private final String name;

        private ModelType(String name) {
            this.name = name;
        }
    }
}

