/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import opennlp.tools.commons.ThreadSafe;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.util.Span;

@ThreadSafe
public class ThreadSafeSentenceDetectorME
implements SentenceDetector,
AutoCloseable {
    private final SentenceModel model;
    private final ThreadLocal<SentenceDetectorME> threadLocal = new ThreadLocal();

    public ThreadSafeSentenceDetectorME(SentenceModel model) {
        this.model = model;
    }

    private SentenceDetectorME getSD() {
        SentenceDetectorME sd = this.threadLocal.get();
        if (sd == null) {
            sd = new SentenceDetectorME(this.model);
            this.threadLocal.set(sd);
        }
        return sd;
    }

    public double[] getSentenceProbabilities() {
        return this.getSD().getSentenceProbabilities();
    }

    @Override
    public String[] sentDetect(CharSequence s) {
        return this.getSD().sentDetect(s);
    }

    @Override
    public Span[] sentPosDetect(CharSequence s) {
        return this.getSD().sentPosDetect(s);
    }

    @Override
    public void close() {
        this.threadLocal.remove();
    }
}

