/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.formats.NameFinderCensus90NameStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringList;

public class CensusDictionaryCreatorTool
extends BasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "Converts 1990 US Census names into a dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp(Parameters.class);
    }

    public static Dictionary createDictionary(ObjectStream<StringList> sampleStream) throws IOException {
        Dictionary mNameDictionary = new Dictionary(true);
        StringList entry = sampleStream.read();
        while (entry != null) {
            if (!mNameDictionary.contains(entry)) {
                mNameDictionary.put(entry);
            }
            entry = sampleStream.read();
        }
        return mNameDictionary;
    }

    @Override
    public void run(String[] args) {
        Dictionary mDictionary;
        Parameters params = this.validateAndParseParams(args, Parameters.class);
        File testData = new File(params.getCensusData());
        File dictOutFile = new File(params.getDict());
        CmdLineUtil.checkInputFile("Name data", testData);
        CmdLineUtil.checkOutputFile("Dictionary file", dictOutFile);
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(testData);
        NameFinderCensus90NameStream sampleStream = new NameFinderCensus90NameStream(sampleDataIn, Charset.forName(params.getEncoding()));
        try {
            System.out.println("Creating Dictionary...");
            mDictionary = CensusDictionaryCreatorTool.createDictionary(sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("Saving Dictionary...");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dictOutFile);
            mDictionary.serialize(out);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while writing dictionary file: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    throw new TerminateToolException(-1, "Attention: Failed to correctly write dictionary:" + e.getMessage(), e);
                }
            }
        }
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="code")
        @ArgumentParser.OptionalParameter(defaultValue="en")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="charsetName")
        @ArgumentParser.OptionalParameter(defaultValue="UTF-8")
        public String getEncoding();

        @ArgumentParser.ParameterDescription(valueName="censusDict")
        public String getCensusData();

        @ArgumentParser.ParameterDescription(valueName="dict")
        public String getDict();
    }
}

