/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.BaseModel;

public final class CmdLineUtil {
    static final int IO_BUFFER_SIZE = 0x100000;

    private CmdLineUtil() {
    }

    public static void checkInputFile(String name, File inFile) {
        String isFailure = null;
        if (inFile.isDirectory()) {
            isFailure = "The " + name + " file is a directory!";
        } else if (!inFile.exists()) {
            isFailure = "The " + name + " file does not exist!";
        } else if (!inFile.canRead()) {
            isFailure = "No permissions to read the " + name + " file!";
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + inFile.getAbsolutePath());
        }
    }

    public static void checkOutputFile(String name, File outFile) {
        String isFailure = null;
        if (outFile.exists()) {
            if (outFile.isDirectory()) {
                isFailure = "The " + name + " file is a directory!";
            } else if (outFile.isFile()) {
                if (!outFile.canWrite()) {
                    isFailure = "No permissions to write the " + name + " file!";
                }
            } else {
                isFailure = "The " + name + " file is not a normal file!";
            }
        } else {
            File parentDir = outFile.getAbsoluteFile().getParentFile();
            if (parentDir != null && parentDir.exists()) {
                if (!parentDir.canWrite()) {
                    isFailure = "No permissions to create the " + name + " file!";
                }
            } else {
                isFailure = "The parent directory of the " + name + " file does not exist, " + "please create it first!";
            }
        }
        if (null != isFailure) {
            throw new TerminateToolException(-1, isFailure + " Path: " + outFile.getAbsolutePath());
        }
    }

    public static FileInputStream openInFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", e);
        }
    }

    public static InputStreamFactory createInputStreamFactory(File file) {
        try {
            return new MarkableFileInputStreamFactory(file);
        }
        catch (FileNotFoundException e) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", e);
        }
    }

    public static void writeModel(String modelName, File modelFile, BaseModel model) {
        CmdLineUtil.checkOutputFile(modelName + " model", modelFile);
        System.err.print("Writing " + modelName + " model ... ");
        long beginModelWritingTime = System.currentTimeMillis();
        OutputStream modelOut = null;
        try {
            modelOut = new BufferedOutputStream(new FileOutputStream(modelFile), 0x100000);
            model.serialize(modelOut);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "Error during writing model file '" + modelFile + "'", e);
        }
        finally {
            if (modelOut != null) {
                try {
                    modelOut.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to properly close model file '" + modelFile + "': " + e.getMessage());
                }
            }
        }
        long modelWritingDuration = System.currentTimeMillis() - beginModelWritingTime;
        System.err.printf("done (%.3fs)\n", (double)modelWritingDuration / 1000.0);
        System.err.println();
        System.err.println("Wrote " + modelName + " model to");
        System.err.println("path: " + modelFile.getAbsolutePath());
        System.err.println();
    }

    public static int getParameterIndex(String param, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !args[i].equals(param)) continue;
            return i;
        }
        return -1;
    }

    public static String getParameter(String param, String[] args) {
        int i = CmdLineUtil.getParameterIndex(param, args);
        if (-1 < i && ++i < args.length) {
            return args[i];
        }
        return null;
    }

    public static Integer getIntParameter(String param, String[] args) {
        String value = CmdLineUtil.getParameter(param, args);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double getDoubleParameter(String param, String[] args) {
        String value = CmdLineUtil.getParameter(param, args);
        try {
            if (value != null) {
                return Double.parseDouble(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static void checkLanguageCode(String code) {
        ArrayList<String> languageCodes = new ArrayList<String>();
        languageCodes.addAll(Arrays.asList(Locale.getISOLanguages()));
        languageCodes.add("x-unspecified");
        if (!languageCodes.contains(code)) {
            throw new TerminateToolException(1, "Unknown language code " + code + ", " + "must be an ISO 639 code!");
        }
    }

    public static boolean containsParam(String param, String[] args) {
        for (String arg : args) {
            if (!arg.equals(param)) continue;
            return true;
        }
        return false;
    }

    public static void handleStdinIoError(IOException e) {
        throw new TerminateToolException(-1, "IO Error while reading from stdin: " + e.getMessage(), e);
    }

    public static TerminateToolException createObjectStreamError(IOException e) {
        return new TerminateToolException(-1, "IO Error while creating an Input Stream: " + e.getMessage(), e);
    }

    public static void handleCreateObjectStreamError(IOException e) {
        throw CmdLineUtil.createObjectStreamError(e);
    }

    public static TrainingParameters loadTrainingParameters(String paramFile, boolean supportSequenceTraining) {
        TrainingParameters params = null;
        if (paramFile != null) {
            CmdLineUtil.checkInputFile("Training Parameter", new File(paramFile));
            InputStream paramsIn = null;
            try {
                paramsIn = new FileInputStream(new File(paramFile));
                params = new TrainingParameters(paramsIn);
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (paramsIn != null) {
                        paramsIn.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!TrainerFactory.isValid(params.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + paramFile + "' is invalid!");
            }
            if (!supportSequenceTraining && TrainerFactory.isSupportEventModelSequenceTraining(params.getSettings())) {
                throw new TerminateToolException(1, "Sequence training is not supported!");
            }
        }
        return params;
    }
}

