/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.model;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.BinaryFileDataReader;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.model.GenericModelReader;
import opennlp.tools.ml.model.GenericModelWriter;
import opennlp.tools.util.model.ArtifactSerializer;

public class GenericModelSerializer
implements ArtifactSerializer<AbstractModel> {
    public AbstractModel create(InputStream in) throws IOException {
        return new GenericModelReader((DataReader)new BinaryFileDataReader(in)).getModel();
    }

    public void serialize(AbstractModel artifact, final OutputStream out) throws IOException {
        Objects.requireNonNull(artifact, "model parameter must not be null");
        Objects.requireNonNull(out, "out parameter must not be null");
        GenericModelWriter modelWriter = new GenericModelWriter(artifact, new DataOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        }));
        modelWriter.persist();
    }

    public static void register(Map<String, ArtifactSerializer<?>> factories) {
        factories.put("model", new GenericModelSerializer());
    }
}

