/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.spi.LoadState;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.util.ImplHelper;

public class OpenJPAPersistenceUtil {
    public static Object getIdentifier(Object entity) {
        return OpenJPAPersistenceUtil.getIdentifier(null, entity);
    }

    public static Object getIdentifier(OpenJPAEntityManagerFactory emf, Object entity) {
        if (entity instanceof PersistenceCapable) {
            PersistenceCapable pc = (PersistenceCapable)entity;
            if (emf != null && !OpenJPAPersistenceUtil.isManagedBy(emf, pc)) {
                return null;
            }
            StateManager sm = pc.pcGetStateManager();
            if (sm != null && sm instanceof OpenJPAStateManager) {
                OpenJPAStateManager osm = (OpenJPAStateManager)sm;
                return osm.getObjectId();
            }
        }
        return null;
    }

    public static boolean isManagedBy(OpenJPAEntityManagerFactory emf, Object entity) {
        if (emf == null || !emf.isOpen() || !ImplHelper.isManageable((Object)entity)) {
            return false;
        }
        PersistenceCapable pc = (PersistenceCapable)entity;
        if (!(pc.pcGetGenericContext() instanceof Broker)) {
            return false;
        }
        Broker broker = (Broker)pc.pcGetGenericContext();
        if (broker == null || broker.isClosed()) {
            return false;
        }
        OpenJPAEntityManagerFactory eemf = JPAFacadeHelper.toEntityManagerFactory(broker.getBrokerFactory());
        return eemf == emf && eemf.isOpen();
    }

    public static LoadState isLoaded(Object obj, String attr) {
        PersistenceCapable pc;
        StateManager sm;
        if (obj == null) {
            return LoadState.UNKNOWN;
        }
        if (obj instanceof PersistenceCapable && (sm = (pc = (PersistenceCapable)obj).pcGetStateManager()) != null && sm instanceof OpenJPAStateManager) {
            return OpenJPAPersistenceUtil.isLoaded((OpenJPAStateManager)sm, attr, null);
        }
        return LoadState.UNKNOWN;
    }

    private static LoadState isLoaded(OpenJPAStateManager sm, String attr, HashSet<OpenJPAStateManager> pcs) {
        boolean isLoaded = true;
        try {
            BitSet loadSet = sm.getLoaded();
            if (attr != null) {
                FieldMetaData fmd = sm.getMetaData().getField(attr);
                if (fmd == null) {
                    return LoadState.UNKNOWN;
                }
                if (!loadSet.get(fmd.getIndex())) {
                    return LoadState.NOT_LOADED;
                }
            }
            if (pcs != null && pcs.contains(sm)) {
                return LoadState.LOADED;
            }
            FieldMetaData[] fmds = sm.getMetaData().getFields();
            if (fmds != null && fmds.length > 0) {
                pcs = OpenJPAPersistenceUtil.addToLoadSet(pcs, sm);
                for (FieldMetaData fmd : fmds) {
                    if (!OpenJPAPersistenceUtil.requiresFetch(sm, fmd) || OpenJPAPersistenceUtil.isLoadedField(sm, fmd, pcs)) continue;
                    isLoaded = false;
                    break;
                }
                pcs.remove(sm);
            }
        }
        catch (RuntimeException e) {
            return LoadState.UNKNOWN;
        }
        return isLoaded ? LoadState.LOADED : LoadState.NOT_LOADED;
    }

    private static boolean requiresFetch(OpenJPAStateManager sm, FieldMetaData fmd) {
        if (sm instanceof StateManagerImpl) {
            return ((StateManagerImpl)sm).requiresFetch(fmd);
        }
        return fmd.isInDefaultFetchGroup();
    }

    private static HashSet<OpenJPAStateManager> addToLoadSet(HashSet<OpenJPAStateManager> pcs, OpenJPAStateManager sm) {
        if (pcs == null) {
            pcs = new HashSet();
        }
        pcs.add(sm);
        return pcs;
    }

    private static boolean isLoadedField(OpenJPAStateManager sm, FieldMetaData fmd, HashSet<OpenJPAStateManager> pcs) {
        BitSet loadSet = sm.getLoaded();
        if (!loadSet.get(fmd.getIndex())) {
            return false;
        }
        Object field = sm.fetchField(fmd.getIndex(), false);
        OpenJPAStateManager ofsm = OpenJPAPersistenceUtil.getStateManager(field);
        if (ofsm != null && pcs.contains(ofsm)) {
            return true;
        }
        switch (fmd.getDeclaredTypeCode()) {
            case 12: {
                return OpenJPAPersistenceUtil.isLoadedCollection(sm, fmd.getElement(), (Collection)field, pcs);
            }
            case 13: {
                return OpenJPAPersistenceUtil.isLoadedMap(sm, fmd, (Map)field, pcs);
            }
            case 11: {
                return OpenJPAPersistenceUtil.isLoadedArray(sm, fmd.getElement(), (Object[])field, pcs);
            }
        }
        if (ofsm != null && fmd.isDeclaredTypePC()) {
            return OpenJPAPersistenceUtil.isLoaded(ofsm, null, pcs) == LoadState.LOADED;
        }
        return true;
    }

    private static boolean isLoadedCollection(OpenJPAStateManager sm, ValueMetaData vmd, Collection<?> coll, HashSet<OpenJPAStateManager> pcs) {
        if (sm == null || coll == null || coll.size() == 0) {
            return true;
        }
        Object[] arr = coll.toArray();
        return OpenJPAPersistenceUtil.isLoadedArray(sm, vmd, arr, pcs);
    }

    private static boolean isLoadedArray(OpenJPAStateManager sm, ValueMetaData vmd, Object[] arr, HashSet<OpenJPAStateManager> pcs) {
        if (sm == null || arr == null || arr.length == 0) {
            return true;
        }
        if (!vmd.isDeclaredTypePC()) {
            return true;
        }
        for (Object pc : arr) {
            OpenJPAStateManager esm = OpenJPAPersistenceUtil.getStateManager(pc);
            if (esm == null) {
                return true;
            }
            if (OpenJPAPersistenceUtil.isLoaded(esm, null, pcs) == LoadState.LOADED) continue;
            return false;
        }
        return true;
    }

    private static boolean isLoadedMap(OpenJPAStateManager sm, FieldMetaData fmd, Map<?, ?> map, HashSet<OpenJPAStateManager> pcs) {
        Object[] arr;
        if (sm == null || map == null || map.size() == 0) {
            return true;
        }
        boolean keyIsPC = fmd.getKey().isDeclaredTypePC();
        boolean valIsPC = fmd.getElement().isDeclaredTypePC();
        if (!keyIsPC && !valIsPC) {
            return true;
        }
        for (Object key : arr = map.keySet().toArray()) {
            if (keyIsPC) {
                OpenJPAStateManager ksm = OpenJPAPersistenceUtil.getStateManager(key);
                if (ksm == null) {
                    return true;
                }
                if (OpenJPAPersistenceUtil.isLoaded(ksm, null, pcs) != LoadState.LOADED) {
                    return false;
                }
            }
            if (!valIsPC) continue;
            Object value = map.get(key);
            OpenJPAStateManager vsm = OpenJPAPersistenceUtil.getStateManager(value);
            if (vsm == null) {
                return true;
            }
            if (OpenJPAPersistenceUtil.isLoaded(vsm, null, pcs) == LoadState.LOADED) continue;
            return false;
        }
        return true;
    }

    private static OpenJPAStateManager getStateManager(Object obj) {
        if (obj == null || !(obj instanceof PersistenceCapable)) {
            return null;
        }
        PersistenceCapable pc = (PersistenceCapable)obj;
        StateManager sm = pc.pcGetStateManager();
        if (sm == null || !(sm instanceof OpenJPAStateManager)) {
            return null;
        }
        return (OpenJPAStateManager)sm;
    }
}

