/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event.kubernetes;

import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.readiness.Readiness;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.openjpa.event.DynamicTCPRemoteCommitProvider;
import org.apache.openjpa.lib.util.Localizer;

public class KubernetesTCPRemoteCommitProvider
extends DynamicTCPRemoteCommitProvider {
    private static final Localizer s_loc = Localizer.forPackage(KubernetesTCPRemoteCommitProvider.class);
    private String _namespace = "<namespace>";
    private String _label = "<label>";

    public String getNamespace() {
        return this._namespace;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    protected KubernetesClient kubernetesClient() throws KubernetesClientException {
        return new KubernetesClientBuilder().build();
    }

    protected List<String> fetchDynamicAddresses() {
        ArrayList<String> podIPs;
        block9: {
            podIPs = new ArrayList<String>();
            try (KubernetesClient client = this.kubernetesClient();){
                podIPs.addAll(((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(this._namespace)).withLabel(this._label)).list()).getItems().stream().filter(Readiness::isPodReady).map(pod -> pod.getStatus().getPodIP()).collect(Collectors.toList()));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)s_loc.get("kubernetestcp-pods", podIPs));
                }
            }
            catch (KubernetesClientException e) {
                if (!this.log.isFatalEnabled()) break block9;
                this.log.fatal((Object)s_loc.get("kubernetestcp-error"), (Throwable)e);
            }
        }
        return podIPs;
    }
}

