/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.ManagedInstanceProvider;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.ReflectingPersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.UUIDGenerator;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.util.GeneralException;

public class ImplHelper {
    private static final Map _assignableTypes = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    public static final Map _unenhancedInstanceMap = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD){

        protected boolean eq(Object x, Object y) {
            if (x instanceof Map.Entry) {
                return super.eq(x, y);
            }
            return x == y;
        }

        protected int hc(Object o) {
            if (o instanceof Map.Entry) {
                return super.hc(o);
            }
            return System.identityHashCode(o);
        }
    };

    public static Collection loadAll(Collection sms, StoreManager store, PCState state, int load, FetchConfiguration fetch, Object context) {
        Collection failed = null;
        for (OpenJPAStateManager sm : sms) {
            if (sm.getManagedInstance() == null) {
                if (store.initialize(sm, state, fetch, context)) continue;
                failed = ImplHelper.addFailedId(sm, failed);
                continue;
            }
            if (load != 0 || sm.getPCState() == PCState.HOLLOW) {
                LockManager lm = sm.getContext().getLockManager();
                if (store.load(sm, sm.getUnloaded(fetch), fetch, lm.getLockLevel(sm), context)) continue;
                failed = ImplHelper.addFailedId(sm, failed);
                continue;
            }
            if (store.exists(sm, context)) continue;
            failed = ImplHelper.addFailedId(sm, failed);
        }
        return failed == null ? Collections.EMPTY_LIST : failed;
    }

    private static Collection addFailedId(OpenJPAStateManager sm, Collection failed) {
        if (failed == null) {
            failed = new ArrayList<Object>();
        }
        failed.add(sm.getId());
        return failed;
    }

    public static Object generateIdentityValue(StoreContext ctx, ClassMetaData meta, int typeCode) {
        return ImplHelper.generateValue(ctx, meta, null, typeCode);
    }

    public static Object generateFieldValue(StoreContext ctx, FieldMetaData fmd) {
        return ImplHelper.generateValue(ctx, fmd.getDefiningMetaData(), fmd, fmd.getDeclaredTypeCode());
    }

    private static Object generateValue(StoreContext ctx, ClassMetaData meta, FieldMetaData fmd, int typeCode) {
        int strategy = fmd == null ? meta.getIdentityStrategy() : fmd.getValueStrategy();
        switch (strategy) {
            case 2: {
                SequenceMetaData smd = fmd == null ? meta.getIdentitySequenceMetaData() : fmd.getValueSequenceMetaData();
                return JavaTypes.convert(smd.getInstance(ctx.getClassLoader()).next(ctx, meta), typeCode);
            }
            case 5: {
                return UUIDGenerator.nextString((int)1);
            }
            case 6: {
                return UUIDGenerator.nextHex((int)1);
            }
            case 7: {
                return UUIDGenerator.nextString((int)4);
            }
            case 8: {
                return UUIDGenerator.nextHex((int)4);
            }
        }
        return null;
    }

    public static BitSet getUpdateFields(OpenJPAStateManager sm) {
        if (sm.getPCState() == PCState.PDIRTY && (!sm.isFlushed() || sm.isFlushedDirty()) || sm.getPCState() == PCState.PNEW && sm.isFlushedDirty()) {
            BitSet dirty = sm.getDirty();
            if (sm.isFlushed()) {
                dirty = (BitSet)dirty.clone();
                dirty.andNot(sm.getFlushed());
            }
            if (dirty.length() > 0) {
                return dirty;
            }
        }
        return null;
    }

    public static void close(Object o) {
        try {
            if (o instanceof Closeable) {
                ((Closeable)o).close();
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public static boolean isManagedType(OpenJPAConfiguration conf, Class type) {
        return PersistenceCapable.class.isAssignableFrom(type) || type != null && (conf == null || conf.getRuntimeUnenhancedClassesConstant() == 0) && PCRegistry.isRegistered(type);
    }

    public static boolean isManageable(Object instance) {
        return instance instanceof PersistenceCapable || instance != null && PCRegistry.isRegistered(instance.getClass());
    }

    public static boolean isAssignable(Class from, Class to) {
        if (from == null || to == null) {
            return false;
        }
        Boolean isAssignable = null;
        Map assignableTo = (Map)_assignableTypes.get(from);
        if (assignableTo == null) {
            assignableTo = new ConcurrentReferenceHashMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
            _assignableTypes.put(from, assignableTo);
        } else {
            isAssignable = (Boolean)assignableTo.get(to);
        }
        if (isAssignable == null) {
            isAssignable = from.isAssignableFrom(to);
            assignableTo.put(to, isAssignable);
        }
        return isAssignable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceCapable toPersistenceCapable(Object o, Object ctx) {
        if (o instanceof PersistenceCapable) {
            return (PersistenceCapable)o;
        }
        OpenJPAConfiguration conf = null;
        if (ctx instanceof OpenJPAConfiguration) {
            conf = (OpenJPAConfiguration)ctx;
        } else if (ctx instanceof StateManager && ((StateManager)ctx).getGenericContext() instanceof StoreContext) {
            conf = ((StoreContext)((StateManager)ctx).getGenericContext()).getConfiguration();
        }
        if (!ImplHelper.isManageable(o)) {
            return null;
        }
        Object object = o;
        synchronized (object) {
            PersistenceCapable pc = (PersistenceCapable)_unenhancedInstanceMap.get(o);
            if (pc != null) {
                return pc;
            }
            if (conf == null) {
                return null;
            }
            pc = new ReflectingPersistenceCapable(o, conf);
            _unenhancedInstanceMap.put(o, pc);
            return pc;
        }
    }

    public static void registerPersistenceCapable(ReflectingPersistenceCapable pc) {
        _unenhancedInstanceMap.put(pc.getManagedInstance(), pc);
    }

    public static Object getManagedInstance(Object o) {
        if (o instanceof ManagedInstanceProvider) {
            return ((ManagedInstanceProvider)o).getManagedInstance();
        }
        return o;
    }
}

