/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.junit5.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.JULLogFactory;
import org.apache.openjpa.lib.log.LogFactory;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.log.SLF4JLogFactory;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.xbean.asm9.AnnotationVisitor;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.shade.commons.EmptyVisitor;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.util.Files;

public class OpenJPADirectoriesEnhancer
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(OpenJPADirectoriesEnhancer.class.getName());
    public static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private static final AtomicBoolean AUTO_DONE = new AtomicBoolean(false);
    private final boolean auto;
    private final String[] entities;
    private final Class<?> logFactory;

    public OpenJPADirectoriesEnhancer(boolean auto, String[] entities, Class<?> logFactory) {
        this.auto = auto;
        this.entities = entities;
        this.logFactory = logFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block6: {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            OpenJpaClassLoader enhancementClassLoader = new OpenJpaClassLoader(classLoader, this.createLogFactory(classLoader));
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(enhancementClassLoader);
            try {
                if (this.auto) {
                    if (!AUTO_DONE.compareAndSet(false, true)) break block6;
                    try {
                        ClassLoaders.findUrls((ClassLoader)enhancementClassLoader.getParent()).stream().map(Files::toFile).filter(File::isDirectory).map(File::toPath).forEach(dir -> {
                            LOGGER.fine(() -> "Enhancing folder '" + dir + "'");
                            try {
                                this.enhanceDirectory(enhancementClassLoader, (Path)dir);
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                        });
                        break block6;
                    }
                    catch (IOException e2) {
                        throw new IllegalStateException(e2);
                    }
                }
                Stream.of(this.entities).forEach(e -> {
                    try {
                        enhancementClassLoader.loadClass((String)e);
                    }
                    catch (ClassNotFoundException e1) {
                        throw new IllegalArgumentException(e1);
                    }
                });
            }
            finally {
                thread.setContextClassLoader(enhancementClassLoader.getParent());
            }
        }
    }

    private LogFactory createLogFactory(ClassLoader classLoader) {
        try {
            if (this.logFactory == null || this.logFactory == LogFactory.class) {
                try {
                    return new SLF4JLogFactory();
                }
                catch (Error | Exception e) {
                    try {
                        return new LogFactoryImpl();
                    }
                    catch (Error | Exception e2) {
                        return new JULLogFactory();
                    }
                }
            }
            return this.logFactory.asSubclass(LogFactory.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void enhanceDirectory(final OpenJpaClassLoader enhancementClassLoader, final Path dir) throws IOException {
        java.nio.file.Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".class")) {
                    String relativeName = dir.relativize(file).toString();
                    try {
                        enhancementClassLoader.handleEnhancement(relativeName.substring(0, relativeName.length() - ".class".length()));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    private static class AlreadyEnhanced
    extends RuntimeException {
        private AlreadyEnhanced() {
            this.setStackTrace(NO_STACK_TRACE);
        }
    }

    private static class MissingEnhancement
    extends RuntimeException {
        private MissingEnhancement() {
            this.setStackTrace(NO_STACK_TRACE);
        }
    }

    private static class CompanionLoader
    extends BaseClassLoader {
        private CompanionLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> doLoadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            byte[] content = this.loadBytes(name);
            if (content != null) {
                Class<?> value = super.defineClass(name, content, 0, content.length);
                if (resolve) {
                    this.resolveClass(value);
                }
                return value;
            }
            return this.defaultLoadClass(name, resolve);
        }
    }

    private static class OpenJpaClassLoader
    extends BaseClassLoader {
        private static final String PERSITENCE_CAPABLE = Type.getDescriptor(PersistenceCapable.class);
        private static final String ENTITY = "Ljavax/persistence/Entity;";
        private static final String ENTITY2 = "Ljakarta/persistence/Entity;";
        private static final String EMBEDDABLE = "Ljavax/persistence/Entity;";
        private static final String EMBEDDABLE2 = "Ljakarta/persistence/Entity;";
        private static final String MAPPED_SUPERCLASS = "Ljavax/persistence/Entity;";
        private static final String MAPPED_SUPERCLASS2 = "Ljakarta/persistence/Entity;";
        private final MetaDataRepository repos;
        private final ClassLoader tmpLoader;
        private final Collection<String> alreadyEnhanced = new ArrayList<String>();

        private OpenJpaClassLoader(ClassLoader parent, LogFactory logFactory) {
            super(parent);
            OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
            conf.setLogFactory(logFactory);
            this.tmpLoader = new CompanionLoader(parent);
            this.repos = new MetaDataRepository();
            this.repos.setConfiguration((Configuration)conf);
            this.repos.setMetaDataFactory((MetaDataFactory)new PersistenceMetaDataFactory());
        }

        @Override
        protected synchronized Class<?> doLoadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            this.handleEnhancement(name);
            return this.defaultLoadClass(name, resolve);
        }

        private void handleEnhancement(String name) throws ClassNotFoundException {
            byte[] enhanced = this.ensureEnhancedIfNeeded(name);
            if (enhanced != null && this.alreadyEnhanced.add(name)) {
                try {
                    java.nio.file.Files.write(this.findTarget(name), enhanced, StandardOpenOption.TRUNCATE_EXISTING);
                    LOGGER.info(() -> "Enhanced '" + name + "'");
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(e.getMessage(), e);
                }
            }
        }

        private Path findTarget(String name) {
            URL url = this.findUrl(name);
            if (!"file".equals(url.getProtocol())) {
                throw new IllegalStateException("Only file urls are supported today: " + url);
            }
            return Paths.get(url.getPath(), new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] enhance(byte[] classBytes) {
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            thread.setContextClassLoader(this.tmpLoader);
            try {
                PCEnhancer enhancer = new PCEnhancer(this.repos.getConfiguration(), new EnhancementProject().loadClass(classBytes, this.tmpLoader), this.repos, this.tmpLoader);
                if (enhancer.run() == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                ClassNodeTracker cnt = enhancer.getPCBytecode();
                byte[] byArray = AsmHelper.toByteArray((ClassNodeTracker)cnt);
                return byArray;
            }
            finally {
                thread.setContextClassLoader(old);
            }
        }

        private boolean isJpaButNotEnhanced(byte[] classBytes) {
            boolean bl;
            ByteArrayInputStream stream = new ByteArrayInputStream(classBytes);
            try {
                ClassReader reader = new ClassReader((InputStream)stream);
                reader.accept((ClassVisitor)new EmptyVisitor(){

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        if (interfaces != null && Arrays.asList(interfaces).contains(PERSITENCE_CAPABLE)) {
                            throw new AlreadyEnhanced();
                        }
                        super.visit(version, access, name, signature, superName, interfaces);
                    }

                    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                        if ("Ljavax/persistence/Entity;".equals(descriptor) || "Ljavax/persistence/Entity;".equals(descriptor) || "Ljavax/persistence/Entity;".equals(descriptor) || "Ljakarta/persistence/Entity;".equals(descriptor) || "Ljakarta/persistence/Entity;".equals(descriptor) || "Ljakarta/persistence/Entity;".equals(descriptor)) {
                            throw new MissingEnhancement();
                        }
                        return new EmptyVisitor().visitAnnotation(descriptor, visible);
                    }
                }, 7);
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (AlreadyEnhanced alreadyEnhanced) {
                    return false;
                }
                catch (MissingEnhancement alreadyEnhanced) {
                    return true;
                }
            }
            ((InputStream)stream).close();
            return bl;
        }

        private byte[] ensureEnhancedIfNeeded(String name) {
            byte[] classBytes = this.loadBytes(name);
            if (classBytes == null) {
                return null;
            }
            if (this.isJpaButNotEnhanced(classBytes)) {
                byte[] enhanced = this.enhance(classBytes);
                if (enhanced != null) {
                    return enhanced;
                }
                LOGGER.info("'" + name + "' already enhanced");
            }
            return null;
        }
    }

    private static abstract class BaseClassLoader
    extends ClassLoader {
        private BaseClassLoader(ClassLoader parent) {
            super(parent);
        }

        protected abstract Class<?> doLoadClass(String var1, boolean var2) throws ClassNotFoundException;

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!(name == null || name.startsWith("java") || name.startsWith("sun") || name.startsWith("jdk"))) {
                return this.doLoadClass(name, resolve);
            }
            return this.defaultLoadClass(name, resolve);
        }

        protected Class<?> defaultLoadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        protected byte[] loadBytes(String name) {
            URL url = this.findUrl(name);
            if (url == null || "jar".equals(url.getProtocol())) {
                return null;
            }
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream inMem = new ByteArrayOutputStream(buffer.length);
            try (InputStream is = url.openStream();){
                int read;
                while ((read = is.read(buffer)) >= 0) {
                    if (read <= 0) continue;
                    inMem.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return inMem.toByteArray();
        }

        protected URL findUrl(String name) {
            return this.getResource(name.replace('.', '/') + ".class");
        }
    }
}

