/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.stats;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;

public final class FetchStatsCollector {
    private static ConcurrentHashMap<String, AtomicInteger> _used = new ConcurrentHashMap();
    private static Set<String> _entities = new TreeSet<String>();
    private static Log _log;
    private static final Localizer _loc;
    private static final int DEFAULT_INTERVAL = 600000;
    private static Timer timer;

    public static void setlogger(Log log) {
        if (_log == null) {
            _log = log;
            _log.info((Object)_loc.get("start-monitoring"));
        }
    }

    public static void registerEntity(ClassMetaData cmd) {
        _entities.add(cmd.getDescribedTypeString());
    }

    public static AtomicInteger registerField(String field) {
        return _used.putIfAbsent(field, new AtomicInteger(0));
    }

    public static void hit(String field) {
        AtomicInteger value = _used.get(field);
        if (value != null) {
            value.incrementAndGet();
        }
    }

    public static Set<String> getStatistics() {
        TreeSet<String> noAccess = new TreeSet<String>();
        for (Map.Entry<String, AtomicInteger> entry : _used.entrySet()) {
            if (entry.getValue().intValue() != 0) continue;
            noAccess.add(entry.getKey());
        }
        return noAccess;
    }

    public static void dump() {
        Set<String> zeroAccessFieldSet = FetchStatsCollector.getStatistics();
        StringBuilder message = new StringBuilder();
        message.append(_loc.get("fields-never-fetched", new Object[]{_entities, zeroAccessFieldSet.size()}).getMessage());
        for (String field : zeroAccessFieldSet) {
            message.append("\n\t" + field);
        }
        _log.info((Object)message);
    }

    public static void clear() {
        for (Map.Entry<String, AtomicInteger> entry : _used.entrySet()) {
            entry.setValue(new AtomicInteger(0));
        }
    }

    static {
        _loc = Localizer.forPackage(FetchStatsCollector.class);
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                TimerTask statsOutputTask = new TimerTask(){

                    @Override
                    public void run() {
                        FetchStatsCollector.dump();
                    }
                };
                timer = new Timer();
                timer.schedule(statsOutputTask, 600000L, 600000L);
                return null;
            }
        });
    }

    static class Container {
        String _name;
        Integer _value;

        public Container(String name, int value) {
            this._name = name;
            this._value = value;
        }

        String getName() {
            return this._name;
        }

        public Integer getValue() {
            return this._value;
        }

        public String toString() {
            return this._name;
        }
    }

    static class Shutdown
    extends Thread {
        Shutdown() {
        }

        @Override
        public void run() {
            timer.cancel();
            FetchStatsCollector.dump();
        }
    }
}

