/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance.stats;

import java.util.Locale;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.stats.FetchStatsCollector;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.AbstractInsnNode;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;

public class FetchStatisticsAuxEnhancer
implements PCEnhancer.AuxiliaryEnhancer {
    private final String IGNORE_METHODS_REGEX = "(pc(.)*GenericContext)?(pc(.)*StateManager)?(pc(.)*DetachedState)?(pc(.)*EnhancementContractVersion)?(pc(.)*ManagedFieldCount)?(pc(.)*GetVersion)?";

    public void run(ClassNode classNode, ClassMetaData cmd) {
        this.addEnhancement(classNode, cmd);
    }

    public boolean skipEnhance(MethodNode m) {
        return false;
    }

    private void addEnhancement(ClassNode classNode, ClassMetaData cmd) {
        Log log = cmd.getRepository().getConfiguration().getLog("openjpa.Runtime");
        FetchStatsCollector.setlogger(log);
        String className = classNode.name.replace("/", ".");
        for (MethodNode meth : classNode.methods) {
            String methodName = meth.name;
            FieldMetaData fmd = this.getFieldName(methodName, cmd);
            if (fmd == null || !this.needsTracking(fmd, methodName, cmd)) continue;
            String fqn = className + "." + fmd.getName();
            FetchStatsCollector.registerField(fqn);
            FetchStatsCollector.registerEntity(cmd);
            InsnList instructions = new InsnList();
            instructions.add(AsmHelper.getLoadConstantInsn((Object)fqn));
            instructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(FetchStatsCollector.class), "hit", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)})));
            meth.instructions.insert(instructions);
        }
    }

    private boolean needsTracking(FieldMetaData fmd, String methName, ClassMetaData cmd) {
        if (fmd.isPrimaryKey() || fmd.isVersion() || !fmd.isInDefaultFetchGroup()) {
            return false;
        }
        if (AccessCode.isField((FieldMetaData)fmd) && methName.toLowerCase(Locale.ENGLISH).startsWith("pcget")) {
            return true;
        }
        return AccessCode.isProperty((FieldMetaData)fmd) && methName.toLowerCase(Locale.ENGLISH).startsWith("get") || methName.toLowerCase(Locale.ENGLISH).startsWith("pcis");
    }

    private FieldMetaData getFieldName(String methName, ClassMetaData cmd) {
        FieldMetaData res = null;
        String fieldName = null;
        if (methName.matches("(pc(.)*GenericContext)?(pc(.)*StateManager)?(pc(.)*DetachedState)?(pc(.)*EnhancementContractVersion)?(pc(.)*ManagedFieldCount)?(pc(.)*GetVersion)?")) {
            return res;
        }
        if (methName.startsWith("pcGet")) {
            fieldName = methName.substring(5);
        } else if (methName.toLowerCase(Locale.ENGLISH).startsWith("get")) {
            fieldName = StringUtil.uncapitalize((String)methName.substring(3));
        } else if (methName.startsWith("pcis")) {
            fieldName = methName.substring(4).toLowerCase(Locale.ENGLISH);
        }
        for (FieldMetaData fmd : cmd.getDeclaredFields()) {
            String fmdName = fmd.getName();
            if (!fmdName.equals(fieldName)) continue;
            return fmd;
        }
        return null;
    }
}

