/*
 * Decompiled with CFR 0.152.
 */
package relations;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Entity
@NamedQueries(value={@NamedQuery(name="siblings", query="select distinct sibling1 from Deity sibling1, Deity sibling2 where sibling1.father = sibling2.father and sibling1.mother = sibling2.mother and sibling2 = ?1 and sibling1 <> ?1"), @NamedQuery(name="half-siblings", query="select distinct sibling1 from Deity sibling1, Deity sibling2 where ((sibling1.father = sibling2.father and sibling1.mother <> sibling2.mother) or (sibling1.father <> sibling2.father and sibling1.mother = sibling2.mother)) and sibling2 = ?1 and sibling1 <> ?1"), @NamedQuery(name="cousins", query="select distinct cousin1 from Deity cousin1, Deity cousin2 where (cousin1.father.father = cousin2.father.father or cousin1.father.mother = cousin2.father.mother or cousin1.mother.father = cousin2.mother.father or cousin1.mother.mother = cousin2.mother.mother) and (cousin1.father <> cousin2.father) and (cousin1.mother <> cousin2.mother) and cousin2 = ?1 and cousin1 <> ?1")})
public class Deity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    private String name;
    @Basic
    @Enumerated(value=EnumType.STRING)
    private Gender gender;
    @OneToOne(cascade={CascadeType.ALL})
    private Deity mother;
    @OneToOne(cascade={CascadeType.ALL})
    private Deity father;
    @OneToMany(cascade={CascadeType.ALL})
    private Set<Deity> children;

    public Deity(String name, Gender gender) {
        this.name = name;
        this.gender = gender;
    }

    public Deity giveBirth(String childName, Deity childFather, Gender gender) {
        if (this.gender != Gender.FEMALE) {
            throw new IllegalArgumentException("Only women can have children!");
        }
        if (childName == null) {
            throw new IllegalArgumentException("No child name!");
        }
        Deity child = new Deity(childName, gender);
        child.mother = this;
        if (this.children == null) {
            this.children = new HashSet<Deity>();
        }
        this.children.add(child);
        if (childFather != null) {
            child.father = childFather;
            if (childFather.children == null) {
                childFather.children = new HashSet<Deity>();
            }
            childFather.children.add(child);
        }
        return child;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setMother(Deity mother) {
        this.mother = mother;
    }

    public Deity getMother() {
        return this.mother;
    }

    public void setFather(Deity father) {
        this.father = father;
    }

    public Deity getFather() {
        return this.father;
    }

    public void setChildren(Set<Deity> children) {
        this.children = children;
    }

    public Set<Deity> getChildren() {
        return this.children;
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

