/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.Arrays;
import java.util.List;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;

public class UpdateStrategies {
    public static final int NONE = 0;
    public static final int IGNORE = 1;
    public static final int RESTRICT = 2;
    private static final Localizer _loc = Localizer.forPackage((Class)UpdateStrategies.class);

    public static String getName(int strategy) {
        switch (strategy) {
            case 0: {
                return "none";
            }
            case 1: {
                return "ignore";
            }
            case 2: {
                return "restrict";
            }
        }
        throw new IllegalArgumentException(String.valueOf(strategy));
    }

    public static int getCode(String val, Object context) {
        if ("none".equals(val)) {
            return 0;
        }
        if ("ignore".equals(val)) {
            return 1;
        }
        if ("restrict".equals(val)) {
            return 2;
        }
        List<String> opts = Arrays.asList("none", "ignore", "restrict");
        String closest = StringDistance.getClosestLevenshteinDistance((String)val, opts, (float)0.5f);
        String msg = closest != null ? _loc.get("bad-update-strategy-hint", new Object[]{context, val, closest, opts}).getMessage() : _loc.get("bad-update-strategy", context, (Object)val, opts).getMessage();
        throw new IllegalArgumentException(msg);
    }
}

