/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;
import serp.util.Strings;

public class Filters {
    private static final BigDecimal ZERO_BIGDECIMAL = new BigDecimal(0.0);
    private static final BigInteger ZERO_BIGINTEGER = new BigInteger("0");
    private static final int OP_ADD = 0;
    private static final int OP_SUBTRACT = 1;
    private static final int OP_MULTIPLY = 2;
    private static final int OP_DIVIDE = 3;
    private static final int OP_MOD = 4;
    private static final Localizer _loc = Localizer.forPackage((Class)Filters.class);

    public static Class wrap(Class c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        return c;
    }

    public static Class unwrap(Class c) {
        if (c.isPrimitive() || c == String.class) {
            return c;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        return c;
    }

    public static Class promote(Class c1, Class c2) {
        Class w2;
        if (c1 == c2) {
            return Filters.unwrap(c1);
        }
        Class w1 = Filters.wrap(c1);
        if (w1 == (w2 = Filters.wrap(c2))) {
            return Filters.unwrap(c1);
        }
        boolean w1Number = Number.class.isAssignableFrom(w1);
        boolean w2Number = Number.class.isAssignableFrom(w2);
        if (!w1Number || !w2Number) {
            if (!w1Number) {
                if (w2Number && (w1 == Character.class || w1 == String.class)) {
                    Class clazz = w2 == Byte.class || w2 == Short.class ? Integer.class : Filters.unwrap(c2);
                    return clazz;
                }
                if (!w2Number && w1 == Character.class && w2 == String.class) {
                    return String.class;
                }
                if (w2Number) {
                    return Filters.unwrap(c2);
                }
            }
            if (!w2Number) {
                if (w1Number && (w2 == Character.class || w2 == String.class)) {
                    Class clazz = w1 == Byte.class || w1 == Short.class ? Integer.class : Filters.unwrap(c1);
                    return clazz;
                }
                if (!w1Number && w2 == Character.class && w1 == String.class) {
                    return String.class;
                }
                if (w1Number) {
                    return Filters.unwrap(c1);
                }
            }
            if (!w1Number && !w2Number) {
                if (w1 == Object.class) {
                    return Filters.unwrap(c2);
                }
                if (w2 == Object.class) {
                    return Filters.unwrap(c1);
                }
                if (w1.isAssignableFrom(w2)) {
                    return Filters.unwrap(c1);
                }
                if (w2.isAssignableFrom(w1)) {
                    return Filters.unwrap(c2);
                }
                if (Filters.isNonstandardType(w1)) {
                    return Filters.isNonstandardType(w2) ? Object.class : Filters.unwrap(c2);
                }
                if (Filters.isNonstandardType(w2)) {
                    return Filters.isNonstandardType(w1) ? Object.class : Filters.unwrap(c1);
                }
            }
            return Object.class;
        }
        if (w1 == BigDecimal.class || w2 == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (w1 == BigInteger.class) {
            if (w2 == Float.class || w2 == Double.class) {
                return BigDecimal.class;
            }
            return BigInteger.class;
        }
        if (w2 == BigInteger.class) {
            if (w1 == Float.class || w1 == Double.class) {
                return BigDecimal.class;
            }
            return BigInteger.class;
        }
        if (w1 == Double.class || w2 == Double.class) {
            return Double.TYPE;
        }
        if (w1 == Float.class || w2 == Float.class) {
            return Float.TYPE;
        }
        if (w1 == Long.class || w2 == Long.class) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    private static boolean isNonstandardType(Class c) {
        switch (JavaTypes.getTypeCode(c)) {
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 27: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    public static boolean canConvert(Class c1, Class c2, boolean strict) {
        c1 = Filters.wrap(c1);
        if ((c2 = Filters.wrap(c2)).isAssignableFrom(c1)) {
            return true;
        }
        boolean c1Number = Number.class.isAssignableFrom(c1);
        boolean c2Number = Number.class.isAssignableFrom(c2);
        if (c1Number && c2Number) {
            return true;
        }
        if (c1Number && (c2 == Character.class || !strict && c2 == String.class) || c2Number && (c1 == Character.class || !strict && c1 == String.class)) {
            return true;
        }
        if (c1 == String.class && c2 == Character.class) {
            return true;
        }
        if (c2 == String.class) {
            return !strict;
        }
        return false;
    }

    public static Object convert(Object o, Class type) {
        if (o == null) {
            return null;
        }
        if (o.getClass() == type) {
            return o;
        }
        if ((type = Filters.wrap(type)).isAssignableFrom(o.getClass())) {
            return o;
        }
        boolean num = o instanceof Number;
        if (!num) {
            if (type == String.class) {
                return o.toString();
            }
            if (type == Character.class) {
                String str = o.toString();
                if (str != null && str.length() == 1) {
                    return new Character(str.charAt(0));
                }
            } else {
                if (Calendar.class.isAssignableFrom(type) && o instanceof Date) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime((Date)o);
                    return cal;
                }
                if (Date.class.isAssignableFrom(type) && o instanceof Calendar) {
                    return ((Calendar)o).getTime();
                }
                if (Number.class.isAssignableFrom(type)) {
                    Integer i = null;
                    if (o instanceof Character) {
                        i = Numbers.valueOf((int)((Character)o).charValue());
                    } else if (o instanceof String && ((String)o).length() == 1) {
                        i = Numbers.valueOf((int)((String)o).charAt(0));
                    }
                    if (i != null) {
                        if (type == Integer.class) {
                            return i;
                        }
                        num = true;
                    }
                }
            }
        }
        if (!num) {
            throw new ClassCastException(_loc.get("cant-convert", o, o.getClass(), (Object)type).getMessage());
        }
        if (type == Integer.class) {
            return Numbers.valueOf((int)((Number)o).intValue());
        }
        if (type == Float.class) {
            return new Float(((Number)o).floatValue());
        }
        if (type == Double.class) {
            return new Double(((Number)o).doubleValue());
        }
        if (type == Long.class) {
            return Numbers.valueOf((long)((Number)o).longValue());
        }
        if (type == BigDecimal.class) {
            double dval = ((Number)o).doubleValue();
            if (Double.isNaN(dval) || Double.isInfinite(dval)) {
                return new Double(dval);
            }
            float fval = ((Number)o).floatValue();
            if (Float.isNaN(fval) || Float.isInfinite(fval)) {
                return new Float(fval);
            }
            return new BigDecimal(o.toString());
        }
        if (type == BigInteger.class) {
            return new BigInteger(o.toString());
        }
        if (type == Short.class) {
            return new Short(((Number)o).shortValue());
        }
        if (type == Byte.class) {
            return new Byte(((Number)o).byteValue());
        }
        return Numbers.valueOf((int)((Number)o).intValue());
    }

    public static Object add(Object o1, Class c1, Object o2, Class c2) {
        return Filters.op(o1, c1, o2, c2, 0);
    }

    public static Object subtract(Object o1, Class c1, Object o2, Class c2) {
        return Filters.op(o1, c1, o2, c2, 1);
    }

    public static Object multiply(Object o1, Class c1, Object o2, Class c2) {
        return Filters.op(o1, c1, o2, c2, 2);
    }

    public static Object divide(Object o1, Class c1, Object o2, Class c2) {
        return Filters.op(o1, c1, o2, c2, 3);
    }

    public static Object mod(Object o1, Class c1, Object o2, Class c2) {
        return Filters.op(o1, c1, o2, c2, 4);
    }

    private static Object op(Object o1, Class c1, Object o2, Class c2, int op) {
        Class promote = Filters.promote(c1, c2);
        if (promote == Integer.TYPE) {
            int n1 = o1 == null ? 0 : ((Number)o1).intValue();
            int n2 = o2 == null ? 0 : ((Number)o2).intValue();
            return Filters.op(n1, n2, op);
        }
        if (promote == Float.TYPE) {
            float n1 = o1 == null ? 0.0f : ((Number)o1).floatValue();
            float n2 = o2 == null ? 0.0f : ((Number)o2).floatValue();
            return Filters.op(n1, n2, op);
        }
        if (promote == Double.TYPE) {
            double n1 = o1 == null ? 0.0 : ((Number)o1).doubleValue();
            double n2 = o2 == null ? 0.0 : ((Number)o2).doubleValue();
            return Filters.op(n1, n2, op);
        }
        if (promote == Long.TYPE) {
            long n1 = o1 == null ? 0L : ((Number)o1).longValue();
            long n2 = o2 == null ? 0L : ((Number)o2).longValue();
            return Filters.op(n1, n2, op);
        }
        if (promote == BigDecimal.class) {
            BigDecimal n1 = o1 == null ? ZERO_BIGDECIMAL : (BigDecimal)Filters.convert(o1, promote);
            BigDecimal n2 = o2 == null ? ZERO_BIGDECIMAL : (BigDecimal)Filters.convert(o2, promote);
            return Filters.op(n1, n2, op);
        }
        if (promote == BigInteger.class) {
            BigInteger n1 = o1 == null ? ZERO_BIGINTEGER : (BigInteger)Filters.convert(o1, promote);
            BigInteger n2 = o2 == null ? ZERO_BIGINTEGER : (BigInteger)Filters.convert(o2, promote);
            return Filters.op(n1, n2, op);
        }
        int n1 = o1 == null ? 0 : ((Number)o1).intValue();
        int n2 = o2 == null ? 0 : ((Number)o2).intValue();
        return Filters.op(n1, n2, op);
    }

    private static Object op(int n1, int n2, int op) {
        int tot;
        switch (op) {
            case 0: {
                tot = n1 + n2;
                break;
            }
            case 1: {
                tot = n1 - n2;
                break;
            }
            case 2: {
                tot = n1 * n2;
                break;
            }
            case 3: {
                tot = n1 / n2;
                break;
            }
            case 4: {
                tot = n1 % n2;
                break;
            }
            default: {
                throw new InternalException();
            }
        }
        return Numbers.valueOf((int)tot);
    }

    private static Object op(float n1, float n2, int op) {
        float tot;
        switch (op) {
            case 0: {
                tot = n1 + n2;
                break;
            }
            case 1: {
                tot = n1 - n2;
                break;
            }
            case 2: {
                tot = n1 * n2;
                break;
            }
            case 3: {
                tot = n1 / n2;
                break;
            }
            case 4: {
                tot = n1 % n2;
                break;
            }
            default: {
                throw new InternalException();
            }
        }
        return new Float(tot);
    }

    private static Object op(double n1, double n2, int op) {
        double tot;
        switch (op) {
            case 0: {
                tot = n1 + n2;
                break;
            }
            case 1: {
                tot = n1 - n2;
                break;
            }
            case 2: {
                tot = n1 * n2;
                break;
            }
            case 3: {
                tot = n1 / n2;
                break;
            }
            case 4: {
                tot = n1 % n2;
                break;
            }
            default: {
                throw new InternalException();
            }
        }
        return new Double(tot);
    }

    private static Object op(long n1, long n2, int op) {
        long tot;
        switch (op) {
            case 0: {
                tot = n1 + n2;
                break;
            }
            case 1: {
                tot = n1 - n2;
                break;
            }
            case 2: {
                tot = n1 * n2;
                break;
            }
            case 3: {
                tot = n1 / n2;
                break;
            }
            case 4: {
                tot = n1 % n2;
                break;
            }
            default: {
                throw new InternalException();
            }
        }
        return Numbers.valueOf((long)tot);
    }

    private static Object op(BigDecimal n1, BigDecimal n2, int op) {
        switch (op) {
            case 0: {
                return n1.add(n2);
            }
            case 1: {
                return n1.subtract(n2);
            }
            case 2: {
                return n1.multiply(n2);
            }
            case 3: {
                int scale = Math.max(n1.scale(), n2.scale());
                return n1.divide(n2, scale, 4);
            }
            case 4: {
                throw new UserException(_loc.get("mod-bigdecimal"));
            }
        }
        throw new InternalException();
    }

    private static Object op(BigInteger n1, BigInteger n2, int op) {
        switch (op) {
            case 0: {
                return n1.add(n2);
            }
            case 1: {
                return n1.subtract(n2);
            }
            case 2: {
                return n1.multiply(n2);
            }
            case 3: {
                return n1.divide(n2);
            }
        }
        throw new InternalException();
    }

    public static List parseDeclaration(String dec, char split, String decType) {
        if (dec == null) {
            return null;
        }
        int bad = 0;
        if (split == 44) {
            bad = 59;
        } else if (split == 59) {
            bad = 44;
        }
        int sentinal = 32;
        int start = 0;
        boolean skipSpace = false;
        ArrayList<String> results = new ArrayList<String>(6);
        for (int i = 0; i < dec.length(); ++i) {
            int cur = dec.charAt(i);
            if (cur == bad) {
                throw new UserException(_loc.get("bad-dec", (Object)dec, (Object)decType));
            }
            if (cur == 32 && skipSpace) {
                ++start;
                continue;
            }
            skipSpace = false;
            if (cur != sentinal) continue;
            sentinal = sentinal == 32 ? split : 32;
            results.add(dec.substring(start, i).trim());
            start = i + 1;
            skipSpace = true;
        }
        if (start < dec.length()) {
            results.add(dec.substring(start));
        }
        if (results.isEmpty() || results.size() % 2 != 0) {
            throw new UserException(_loc.get("bad-dec", (Object)dec, (Object)decType));
        }
        return results;
    }

    public static List splitExpressions(String str, char split, int expected) {
        if (str == null) {
            return null;
        }
        ArrayList<String> exps = null;
        int parenDepth = 0;
        int begin = 0;
        boolean escape = false;
        boolean string = false;
        boolean nonspace = false;
        char quote = '\u0000';
        for (int pos = 0; pos < str.length(); ++pos) {
            char c = str.charAt(pos);
            if (c == '\\') {
                escape = !escape;
                continue;
            }
            if (escape) {
                escape = false;
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    if (string && quote == c) {
                        string = false;
                    } else if (!string) {
                        quote = c;
                        string = true;
                    }
                    nonspace = true;
                    break;
                }
                case '(': {
                    if (!string) {
                        ++parenDepth;
                    }
                    nonspace = true;
                    break;
                }
                case ')': {
                    if (!string) {
                        --parenDepth;
                    }
                    nonspace = true;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (c != split || string || parenDepth != 0 || !nonspace) break;
                    if (exps == null) {
                        exps = new ArrayList(expected);
                    }
                    exps.add(str.substring(begin, pos).trim());
                    begin = pos + 1;
                    nonspace = false;
                    break;
                }
                default: {
                    if (c == split && !string && parenDepth == 0) {
                        if (exps == null) {
                            exps = new ArrayList(expected);
                        }
                        exps.add(str.substring(begin, pos).trim());
                        begin = pos + 1;
                    }
                    nonspace = true;
                }
            }
            escape = false;
        }
        if (exps == null) {
            exps = new ArrayList<String>(1);
            exps.add(str);
            return exps;
        }
        String last = str.substring(begin).trim();
        if (last.length() > 0) {
            exps.add(last);
        }
        return exps;
    }

    public static List addAccessPathMetaDatas(List metas, ClassMetaData[] path) {
        if (path == null || path.length == 0) {
            return metas;
        }
        if (metas == null) {
            metas = new ArrayList<ClassMetaData>();
        }
        int last = metas.size();
        for (int i = 0; i < path.length; ++i) {
            boolean add = true;
            for (int j = 0; add && j < last; ++j) {
                ClassMetaData meta = (ClassMetaData)metas.get(j);
                if (meta.getDescribedType().isAssignableFrom(path[i].getDescribedType())) {
                    add = false;
                    continue;
                }
                if (!path[i].getDescribedType().isAssignableFrom(meta.getDescribedType())) continue;
                add = false;
                metas.set(j, path[i]);
            }
            if (!add) continue;
            metas.add(path[i]);
        }
        return metas;
    }

    public static AggregateListener hintToAggregateListener(Object hint, ClassLoader loader) {
        if (hint == null) {
            return null;
        }
        if (hint instanceof AggregateListener) {
            return (AggregateListener)hint;
        }
        Throwable cause = null;
        if (hint instanceof String) {
            try {
                return (AggregateListener)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName((String)hint, true, loader)));
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                cause = e;
            }
        }
        throw new UserException(_loc.get("bad-agg-listener-hint", hint, hint.getClass())).setCause(cause);
    }

    public static AggregateListener[] hintToAggregateListeners(Object hint, ClassLoader loader) {
        if (hint == null) {
            return null;
        }
        if (hint instanceof AggregateListener[]) {
            return (AggregateListener[])hint;
        }
        if (hint instanceof AggregateListener) {
            return new AggregateListener[]{(AggregateListener)hint};
        }
        if (hint instanceof Collection) {
            Collection c = (Collection)hint;
            return c.toArray(new AggregateListener[c.size()]);
        }
        Throwable cause = null;
        if (hint instanceof String) {
            String[] clss = Strings.split((String)((String)hint), (String)",", (int)0);
            AggregateListener[] aggs = new AggregateListener[clss.length];
            try {
                for (int i = 0; i < clss.length; ++i) {
                    aggs[i] = (AggregateListener)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName(clss[i], true, loader)));
                }
                return aggs;
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                cause = e;
            }
        }
        throw new UserException(_loc.get("bad-agg-listener-hint", hint, hint.getClass())).setCause(cause);
    }

    public static FilterListener hintToFilterListener(Object hint, ClassLoader loader) {
        if (hint == null) {
            return null;
        }
        if (hint instanceof FilterListener) {
            return (FilterListener)hint;
        }
        Throwable cause = null;
        if (hint instanceof String) {
            try {
                return (FilterListener)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName((String)hint, true, loader)));
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                cause = e;
            }
        }
        throw new UserException(_loc.get("bad-filter-listener-hint", hint, hint.getClass())).setCause(cause);
    }

    public static FilterListener[] hintToFilterListeners(Object hint, ClassLoader loader) {
        if (hint == null) {
            return null;
        }
        if (hint instanceof FilterListener[]) {
            return (FilterListener[])hint;
        }
        if (hint instanceof FilterListener) {
            return new FilterListener[]{(FilterListener)hint};
        }
        if (hint instanceof Collection) {
            Collection c = (Collection)hint;
            return c.toArray(new FilterListener[c.size()]);
        }
        Throwable cause = null;
        if (hint instanceof String) {
            String[] clss = Strings.split((String)((String)hint), (String)",", (int)0);
            FilterListener[] filts = new FilterListener[clss.length];
            try {
                for (int i = 0; i < clss.length; ++i) {
                    filts[i] = (FilterListener)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName(clss[i], true, loader)));
                }
                return filts;
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                cause = e;
            }
        }
        throw new UserException(_loc.get("bad-filter-listener-hint", hint, hint.getClass())).setCause(cause);
    }

    public static Object hintToGetter(Object target, String hintKey) {
        if (target == null || hintKey == null) {
            return null;
        }
        Method getter = Reflection.findGetter(target.getClass(), hintKey, true);
        return Reflection.get(target, getter);
    }

    public static void hintToSetter(Object target, String hintKey, Object value) {
        if (target == null || hintKey == null) {
            return;
        }
        Method setter = Reflection.findSetter(target.getClass(), hintKey, true);
        if (value instanceof String) {
            if ("null".equals(value)) {
                value = null;
            } else {
                try {
                    value = Strings.parse((String)((String)value), setter.getParameterTypes()[0]);
                }
                catch (Exception e) {
                    throw new UserException(_loc.get("bad-setter-hint-arg", (Object)hintKey, value, setter.getParameterTypes()[0])).setCause(e);
                }
            }
        }
        Reflection.set(target, setter, value);
    }
}

