/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.domain;

import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;

public enum ODataLinkType {
    ENTITY_NAVIGATION(ContentType.APPLICATION_ATOM_XML_ENTRY),
    ENTITY_SET_NAVIGATION(ContentType.APPLICATION_ATOM_XML_FEED),
    ASSOCIATION(ContentType.APPLICATION_XML),
    MEDIA_EDIT("*/*");

    private String type;

    private ODataLinkType(String type) {
        this.type = type;
    }

    private ODataLinkType(ContentType contentType) {
        this(contentType.toContentTypeString());
    }

    private ODataLinkType setType(String type) {
        this.type = type;
        return this;
    }

    public static ODataLinkType fromString(ODataServiceVersion version, String rel, String type) {
        if (StringUtils.isNotBlank((CharSequence)rel) && rel.startsWith(version.getNamespace(ODataServiceVersion.NamespaceKey.MEDIA_EDIT_LINK_REL))) {
            return MEDIA_EDIT.setType(StringUtils.isBlank((CharSequence)type) ? "*/*" : type);
        }
        if (ODataLinkType.ENTITY_NAVIGATION.type.equals(type)) {
            return ENTITY_NAVIGATION;
        }
        if (ODataLinkType.ENTITY_SET_NAVIGATION.type.equals(type)) {
            return ENTITY_SET_NAVIGATION;
        }
        if (ODataLinkType.ASSOCIATION.type.equals(type)) {
            return ASSOCIATION;
        }
        throw new IllegalArgumentException("Invalid link type: " + type);
    }

    public String toString() {
        return this.type;
    }
}

