/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import java.net.URI;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;

public class ContextURL {
    private URI serviceRoot;
    private String entitySetOrSingletonOrType;
    private String derivedEntity;
    private String selectList;
    private String navOrPropertyPath;
    private Suffix suffix;

    private ContextURL() {
    }

    public URI getServiceRoot() {
        return this.serviceRoot;
    }

    public String getEntitySetOrSingletonOrType() {
        return this.entitySetOrSingletonOrType;
    }

    public String getDerivedEntity() {
        return this.derivedEntity;
    }

    public String getSelectList() {
        return this.selectList;
    }

    public String getNavOrPropertyPath() {
        return this.navOrPropertyPath;
    }

    public Suffix getSuffix() {
        return this.suffix;
    }

    public boolean isEntity() {
        return this.suffix == Suffix.ENTITY;
    }

    public boolean isReference() {
        return this.suffix == Suffix.REFERENCE;
    }

    public boolean isDelta() {
        return this.suffix == Suffix.DELTA;
    }

    public boolean isDeltaDeletedEntity() {
        return this.suffix == Suffix.DELTA_DELETED_ENTITY;
    }

    public boolean isDeltaLink() {
        return this.suffix == Suffix.DELTA_LINK;
    }

    public boolean isDeltaDeletedLink() {
        return this.suffix == Suffix.DELTA_DELETED_LINK;
    }

    public static final class Builder {
        private ContextURL contextURL = new ContextURL();

        private Builder() {
        }

        public static final Builder create() {
            return new Builder();
        }

        public Builder serviceRoot(URI serviceRoot) {
            this.contextURL.serviceRoot = serviceRoot;
            return this;
        }

        public Builder entitySet(EdmEntitySet entitySet) {
            this.contextURL.entitySetOrSingletonOrType = entitySet.getName();
            return this;
        }

        public Builder entitySetOrSingletonOrType(String entitySetOrSingletonOrType) {
            this.contextURL.entitySetOrSingletonOrType = entitySetOrSingletonOrType;
            return this;
        }

        public Builder derived(EdmEntityType derivedType) {
            this.contextURL.derivedEntity = derivedType.getFullQualifiedName().getFullQualifiedNameAsString();
            return this;
        }

        public Builder derivedEntity(String derivedEntity) {
            this.contextURL.derivedEntity = derivedEntity;
            return this;
        }

        public Builder navOrPropertyPath(String navOrPropertyPath) {
            this.contextURL.navOrPropertyPath = navOrPropertyPath;
            return this;
        }

        public Builder selectList(String selectList) {
            this.contextURL.selectList = selectList;
            return this;
        }

        public Builder suffix(Suffix suffix) {
            this.contextURL.suffix = suffix;
            return this;
        }

        public ContextURL build() {
            return this.contextURL;
        }
    }

    public static enum Suffix {
        ENTITY("$entity"),
        REFERENCE("$ref"),
        DELTA("$delta"),
        DELTA_DELETED_ENTITY("$deletedEntity"),
        DELTA_LINK("$link"),
        DELTA_DELETED_LINK("$deletedLink");

        private final String representation;

        private Suffix(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

