/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.api.communication.header;

import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class ODataPreferences {
    final ODataServiceVersion serviceVersion;

    public ODataPreferences(ODataServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String returnContent() {
        return PreferenceNames.returnContent.isSupportedBy(this.serviceVersion).toString();
    }

    public String returnNoContent() {
        return PreferenceNames.returnNoContent.isSupportedBy(this.serviceVersion).toString();
    }

    public String keyAsSegment() {
        return PreferenceNames.keyAsSegment.isSupportedBy(this.serviceVersion).toString();
    }

    public String allowEntityReferences() {
        return PreferenceNames.allowEntityReferences.isSupportedBy(this.serviceVersion).toString();
    }

    public String callback(String url) {
        return PreferenceNames.callback.isSupportedBy(this.serviceVersion).toString() + ";url=\"" + url + "\"";
    }

    public String continueOnError() {
        return PreferenceNames.continueOnError.isSupportedBy(this.serviceVersion).toString();
    }

    public String includeAnnotations(String value) {
        return PreferenceNames.includeAnnotations.isSupportedBy(this.serviceVersion).toString() + "=" + value;
    }

    public String maxPageSize(int size) {
        return PreferenceNames.maxPageSize.isSupportedBy(this.serviceVersion).toString() + "=" + size;
    }

    public String trackChanges() {
        return PreferenceNames.trackChanges.isSupportedBy(this.serviceVersion).toString();
    }

    public String respondAsync() {
        return PreferenceNames.respondAsync.isSupportedBy(this.serviceVersion).toString();
    }

    public String wait(int value) {
        return PreferenceNames.wait.isSupportedBy(this.serviceVersion).toString() + "=" + value;
    }

    public String returnMinimal() {
        return PreferenceNames.odataReturn.isSupportedBy(this.serviceVersion).toString() + "=minimal";
    }

    public String returnRepresentation() {
        return PreferenceNames.odataReturn.isSupportedBy(this.serviceVersion).toString() + "=representation";
    }

    private static enum PreferenceNames {
        returnContent("return-content", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
        returnNoContent("return-no-content", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
        keyAsSegment("KeyAsSegment", Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40)),
        allowEntityReferences("odata.allow-entityreferences", Arrays.asList(ODataServiceVersion.V40)),
        callback("odata.callback", Arrays.asList(ODataServiceVersion.V40)),
        continueOnError("odata.continue-on-error", Arrays.asList(ODataServiceVersion.V40)),
        includeAnnotations("odata.include-annotations", Arrays.asList(ODataServiceVersion.V40)),
        maxPageSize("odata.maxpagesize", Arrays.asList(ODataServiceVersion.V40)),
        trackChanges("odata.track-changes", Arrays.asList(ODataServiceVersion.V40)),
        respondAsync("respond-async", Arrays.asList(ODataServiceVersion.V40)),
        wait("wait", Arrays.asList(ODataServiceVersion.V40)),
        odataReturn("return", Arrays.asList(ODataServiceVersion.V40));

        private final String preferenceName;
        private final List<ODataServiceVersion> supportedVersions;

        private PreferenceNames(String preferenceName, List<ODataServiceVersion> supportedVersions) {
            this.preferenceName = preferenceName;
            this.supportedVersions = supportedVersions;
        }

        final PreferenceNames isSupportedBy(ODataServiceVersion serviceVersion) {
            if (!this.supportedVersions.contains(serviceVersion)) {
                throw new ODataRuntimeException("Unsupported header " + this.toString());
            }
            return this;
        }

        public String toString() {
            return this.preferenceName;
        }
    }
}

