/*
 * Decompiled with CFR 0.152.
 */
package npanday.assembler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import npanday.assembler.AssemblyInfo;
import npanday.assembler.AssemblyInfoMarshaller;
import npanday.model.assembly.plugins.AssemblyPlugin;
import org.apache.maven.project.MavenProject;

final class JavaAssemblyInfoMarshaller
implements AssemblyInfoMarshaller {
    private AssemblyPlugin plugin;

    JavaAssemblyInfoMarshaller() {
    }

    public void marshal(AssemblyInfo assemblyInfo, MavenProject mavenProject, OutputStream outputStream) throws IOException {
        String src = mavenProject.getBasedir() + "/target/build-sources";
        StringBuffer sb = new StringBuffer();
        sb.append("import System.Reflection;\r\n").append("import System.Runtime.CompilerServices.*;r\n").append(this.createEntry("Description", assemblyInfo.getDescription())).append(this.createEntry("Title", assemblyInfo.getTitle())).append(this.createEntry("Company", assemblyInfo.getCompany())).append(this.createEntry("Product", assemblyInfo.getProduct())).append(this.createEntry("Copyright", assemblyInfo.getCopyright().replace("\"", "\\"))).append(this.createEntry("Trademark", assemblyInfo.getTrademark())).append(this.createEntry("Culture", assemblyInfo.getCulture())).append(this.createEntry("Version", assemblyInfo.getVersion())).append(this.createEntry("Configuration", assemblyInfo.getConfiguration()));
        FileOutputStream man = null;
        try {
            String groupIdAsDir = mavenProject.getGroupId().replace(".", File.separator);
            File file = new File(src + "/META-INF/" + groupIdAsDir);
            file.mkdirs();
            man = new FileOutputStream(src + "/META-INF/" + groupIdAsDir + File.separator + "AssemblyInfo." + this.plugin.getExtension());
            man.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new IOException();
        }
        finally {
            if (man != null) {
                man.close();
            }
        }
    }

    public AssemblyInfo unmarshall(InputStream inputStream) throws IOException {
        throw new IOException("This method is not implemented");
    }

    public void init(AssemblyPlugin plugin) {
        this.plugin = plugin;
    }

    private String createEntry(String name, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("/**@assembly: Assembly").append(name).append("(\"").append(value).append("\")*/").append("\r\n");
        return sb.toString();
    }
}

