/*
 * Decompiled with CFR 0.152.
 */
package npanday.assembler.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import npanday.assembler.AssemblyInfo;
import npanday.assembler.AssemblyInfoException;
import npanday.assembler.AssemblyInfoMarshaller;
import npanday.model.assembly.plugins.AssemblyPlugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

final class DefaultAssemblyInfoMarshaller
implements AssemblyInfoMarshaller {
    private AssemblyPlugin plugin;

    DefaultAssemblyInfoMarshaller() {
    }

    public void marshal(AssemblyInfo assemblyInfo, MavenProject mavenProject, OutputStream outputStream) throws AssemblyInfoException, IOException {
        String src = mavenProject.getBuild().getDirectory() + "/build-sources";
        StringBuffer sb = new StringBuffer();
        sb.append("using System.Reflection;\r\n").append("using System.Runtime.CompilerServices;\r\n").append(this.createEntry("Description", assemblyInfo.getDescription())).append(this.createEntry("Title", assemblyInfo.getTitle())).append(this.createEntry("Company", assemblyInfo.getCompany())).append(this.createEntry("Product", assemblyInfo.getProduct())).append(this.createEntry("Copyright", assemblyInfo.getCopyright().replace("\"", "\\"))).append(this.createEntry("Trademark", assemblyInfo.getTrademark())).append(this.createEntry("Culture", assemblyInfo.getCulture())).append(this.createEntry("Version", assemblyInfo.getVersion())).append(this.createEntry("InformationalVersion", assemblyInfo.getInformationalVersion())).append(this.createEntry("Configuration", assemblyInfo.getConfiguration()));
        if (assemblyInfo.getKeyName() != null) {
            sb.append(this.createEntry("KeyName", assemblyInfo.getKeyName()));
        }
        if (assemblyInfo.getKeyFile() != null) {
            sb.append(this.createEntry("KeyFile", assemblyInfo.getKeyFile().getAbsolutePath().replace("\\", "\\\\")));
        }
        boolean wroteCustomStringAttribute = false;
        for (Map.Entry<String, String> e : assemblyInfo.getCustomStringAttributes().entrySet()) {
            if (StringUtils.isEmpty((String)e.getValue())) continue;
            sb.append(this.createCustomStringEntry(e.getKey(), e.getValue()));
            wroteCustomStringAttribute = true;
        }
        if (wroteCustomStringAttribute) {
            String customClass = "\n[System.AttributeUsage(System.AttributeTargets.Assembly, AllowMultiple = true)]\nclass CustomStringAttribute : System.Attribute {\n  public CustomStringAttribute(string name, string value) {\n  }\n}\n";
            sb.append("\n[System.AttributeUsage(System.AttributeTargets.Assembly, AllowMultiple = true)]\nclass CustomStringAttribute : System.Attribute {\n  public CustomStringAttribute(string name, string value) {\n  }\n}\n");
        }
        FileOutputStream man = null;
        try {
            String groupIdAsDir = mavenProject.getGroupId().replace(".", File.separator);
            File file = new File(src + "/META-INF/" + groupIdAsDir);
            file.mkdirs();
            man = new FileOutputStream(src + "/META-INF/" + groupIdAsDir + File.separator + "AssemblyInfo." + this.plugin.getExtension());
            man.write(sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new AssemblyInfoException("NPANDAY-022-000: Failed to generate AssemblyInfo", e);
        }
        finally {
            if (man != null) {
                man.close();
            }
        }
    }

    public void init(AssemblyPlugin plugin) {
        this.plugin = plugin;
    }

    public AssemblyInfo unmarshall(InputStream inputStream) throws IOException, AssemblyInfoException {
        String line;
        AssemblyInfo assemblyInfo = new AssemblyInfo();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            String[] tokens;
            if (line.trim().startsWith("//") || (tokens = line.split("[:]")).length != 2) continue;
            String[] assemblyTokens = tokens[1].split("[(]");
            String name = assemblyTokens[0].trim();
            String value = assemblyTokens[1].trim().split("[\"]")[1].trim();
            this.setAssemblyInfo(assemblyInfo, name, value);
        }
        return assemblyInfo;
    }

    private void setAssemblyInfo(AssemblyInfo assemblyInfo, String name, String value) throws AssemblyInfoException {
        if (!name.startsWith("Assembly")) {
            throw new AssemblyInfoException("NPANDAY-022-001: Invalid assembly info parameter: Name = " + name + ", Value = " + value);
        }
        if (name.equals("AssemblyDescription")) {
            assemblyInfo.setDescription(value);
        } else if (name.equals("AssemblyInformationalVersion")) {
            assemblyInfo.setInformationalVersion(value);
        } else if (name.equals("AssemblyTitle")) {
            assemblyInfo.setTitle(value);
        } else if (name.equals("AssemblyCompany")) {
            assemblyInfo.setCompany(value);
        } else if (name.equals("AssemblyProduct")) {
            assemblyInfo.setProduct(value);
        } else if (name.equals("AssemblyCopyright")) {
            assemblyInfo.setCopyright(value);
        } else if (name.equals("AssemblyTrademark")) {
            assemblyInfo.setTrademark(value);
        } else if (name.equals("AssemblyCulture")) {
            assemblyInfo.setCulture(value);
        } else if (name.equals("AssemblyVersion")) {
            assemblyInfo.setVersion(value);
        } else if (name.equals("AssemblyConfiguration")) {
            assemblyInfo.setConfiguration(value);
        } else if (name.equals("AssemblyKeyFile")) {
            assemblyInfo.setConfiguration(value);
        } else if (name.equals("AssemblyKeyName")) {
            assemblyInfo.setConfiguration(value);
        }
    }

    private String createEntry(String name, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append("[assembly: Assembly").append(name).append("(\"").append(value).append("\")]").append("\r\n");
        return sb.toString();
    }

    private String createCustomStringEntry(String name, String value) {
        return "[assembly: CustomStringAttribute(\"" + name + "\", \"" + value + "\")]\r\n";
    }
}

