/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.extension.ExtensionFilterParams;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.TagCount;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ProvidedServiceAPI;
import org.apache.nifi.registry.RegistryConfiguration;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.authorization.CurrentUser;
import org.apache.nifi.registry.authorization.Resource;
import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoArtifact;
import org.apache.nifi.registry.extension.repo.ExtensionRepoBucket;
import org.apache.nifi.registry.extension.repo.ExtensionRepoExtensionMetadata;
import org.apache.nifi.registry.extension.repo.ExtensionRepoGroup;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersion;
import org.apache.nifi.registry.extension.repo.ExtensionRepoVersionSummary;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.link.LinkableEntity;
import org.apache.nifi.registry.revision.api.InvalidRevisionException;
import org.apache.nifi.registry.revision.entity.RevisableEntity;
import org.apache.nifi.registry.revision.entity.RevisableEntityService;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.security.authorization.AuthorizableLookup;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.service.AuthorizationService;
import org.apache.nifi.registry.service.RegistryService;
import org.apache.nifi.registry.service.extension.ExtensionService;
import org.apache.nifi.registry.web.link.LinkService;
import org.apache.nifi.registry.web.security.PermissionsService;
import org.apache.nifi.registry.web.service.ExportedVersionedFlowSnapshot;
import org.apache.nifi.registry.web.service.RevisionFeature;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.apache.nifi.registry.web.service.StreamingContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Throwable.class})
public class StandardServiceFacade
implements ServiceFacade {
    private static final String INVALID_REVISION_MSG = "The %s you attempted to %s with id '%s' is out of date with the server. You may need to refresh your client and try again.";
    public static final String USER_GROUP_ENTITY_TYPE = "User Group";
    public static final String USER_ENTITY_TYPE = "User";
    public static final String ACCESS_POLICY_ENTITY_TYPE = "Access Policy";
    public static final String VERSIONED_FLOW_ENTITY_TYPE = "Versioned Flow";
    public static final String BUCKET_ENTITY_TYPE = "Bucket";
    private final RegistryService registryService;
    private final ExtensionService extensionService;
    private final AuthorizationService authorizationService;
    private final AuthorizableLookup authorizableLookup;
    private final RevisableEntityService entityService;
    private final RevisionFeature revisionFeature;
    private final PermissionsService permissionsService;
    private final LinkService linkService;
    private static final int LATEST_VERSION = -1;

    @Autowired
    public StandardServiceFacade(RegistryService registryService, ExtensionService extensionService, AuthorizationService authorizationService, AuthorizableLookup authorizableLookup, RevisableEntityService entityService, RevisionFeature revisionFeature, PermissionsService permissionsService, LinkService linkService) {
        this.registryService = registryService;
        this.extensionService = extensionService;
        this.authorizationService = authorizationService;
        this.authorizableLookup = authorizableLookup;
        this.entityService = entityService;
        this.revisionFeature = revisionFeature;
        this.permissionsService = permissionsService;
        this.linkService = linkService;
    }

    private String currentUserIdentity() {
        return NiFiUserUtils.getNiFiUserIdentity();
    }

    public Bucket createBucket(Bucket bucket) {
        this.authorizeBucketsAccess(RequestAction.WRITE);
        this.validateCreationOfRevisableEntity((RevisableEntity)bucket, BUCKET_ENTITY_TYPE);
        this.validateIdentifierNotPresent((RevisableEntity)bucket, BUCKET_ENTITY_TYPE);
        bucket.setIdentifier(UUID.randomUUID().toString());
        Bucket createdBucket = (Bucket)this.createRevisableEntity((RevisableEntity)bucket, BUCKET_ENTITY_TYPE, this.currentUserIdentity(), () -> this.registryService.createBucket(bucket));
        this.permissionsService.populateBucketPermissions(createdBucket);
        this.linkService.populateLinks((LinkableEntity)createdBucket);
        return createdBucket;
    }

    public Bucket getBucket(String bucketIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        Bucket bucket = (Bucket)this.getRevisableEntity(() -> this.registryService.getBucket(bucketIdentifier));
        this.permissionsService.populateBucketPermissions(bucket);
        this.linkService.populateLinks((LinkableEntity)bucket);
        return bucket;
    }

    public List<Bucket> getBuckets() {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return Collections.emptyList();
        }
        List buckets = this.getRevisableEntities(() -> this.registryService.getBuckets(authorizedBucketIds));
        this.permissionsService.populateBucketPermissions((Iterable)buckets);
        this.linkService.populateLinks((Iterable)buckets);
        return buckets;
    }

    public Bucket updateBucket(Bucket bucket) {
        this.authorizeBucketAccess(RequestAction.WRITE, bucket.getIdentifier());
        this.validateUpdateOfRevisableEntity((RevisableEntity)bucket, BUCKET_ENTITY_TYPE);
        this.registryService.verifyBucketExists(bucket.getIdentifier());
        Bucket updatedBucket = (Bucket)this.updateRevisableEntity((RevisableEntity)bucket, BUCKET_ENTITY_TYPE, this.currentUserIdentity(), () -> this.registryService.updateBucket(bucket));
        this.permissionsService.populateBucketPermissions(updatedBucket);
        this.linkService.populateLinks((LinkableEntity)updatedBucket);
        return updatedBucket;
    }

    public Bucket deleteBucket(String bucketIdentifier, RevisionInfo revisionInfo) {
        this.authorizeBucketAccess(RequestAction.DELETE, bucketIdentifier);
        this.validateDeleteOfRevisableEntity(bucketIdentifier, revisionInfo, BUCKET_ENTITY_TYPE);
        this.registryService.verifyBucketExists(bucketIdentifier);
        return (Bucket)this.deleteRevisableEntity(bucketIdentifier, BUCKET_ENTITY_TYPE, revisionInfo, () -> this.registryService.deleteBucket(bucketIdentifier));
    }

    public List<BucketItem> getBucketItems(String bucketIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        List items = this.registryService.getBucketItems(bucketIdentifier);
        this.populateRevisableEntities(items);
        this.permissionsService.populateItemPermissions((Iterable)items);
        this.linkService.populateLinks((Iterable)items);
        return items;
    }

    public List<BucketItem> getBucketItems() {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return new ArrayList<BucketItem>();
        }
        List items = this.registryService.getBucketItems(authorizedBucketIds);
        this.populateRevisableEntities(items);
        this.permissionsService.populateItemPermissions((Iterable)items);
        this.linkService.populateLinks((Iterable)items);
        return items;
    }

    public VersionedFlow createFlow(String bucketIdentifier, VersionedFlow versionedFlow) {
        this.authorizeBucketAccess(RequestAction.WRITE, bucketIdentifier);
        this.validateCreationOfRevisableEntity((RevisableEntity)versionedFlow, VERSIONED_FLOW_ENTITY_TYPE);
        if (versionedFlow.getIdentifier() == null) {
            versionedFlow.setIdentifier(UUID.randomUUID().toString());
        }
        VersionedFlow createdFlow = (VersionedFlow)this.createRevisableEntity((RevisableEntity)versionedFlow, VERSIONED_FLOW_ENTITY_TYPE, this.currentUserIdentity(), () -> this.registryService.createFlow(bucketIdentifier, versionedFlow));
        this.permissionsService.populateItemPermissions((BucketItem)createdFlow);
        this.linkService.populateLinks((LinkableEntity)createdFlow);
        return createdFlow;
    }

    public VersionedFlow getFlow(String bucketIdentifier, String flowIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        VersionedFlow flow = (VersionedFlow)this.getRevisableEntity(() -> this.registryService.getFlow(bucketIdentifier, flowIdentifier));
        this.permissionsService.populateItemPermissions((BucketItem)flow);
        this.linkService.populateLinks((LinkableEntity)flow);
        return flow;
    }

    public VersionedFlow getFlow(String flowIdentifier) {
        VersionedFlow flow = (VersionedFlow)this.getRevisableEntity(() -> this.registryService.getFlow(flowIdentifier));
        this.authorizeBucketAccess(RequestAction.READ, flow);
        this.permissionsService.populateItemPermissions((BucketItem)flow);
        this.linkService.populateLinks((LinkableEntity)flow);
        return flow;
    }

    public List<VersionedFlow> getFlows(String bucketIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        List flows = this.getRevisableEntities(() -> this.registryService.getFlows(bucketIdentifier));
        this.permissionsService.populateItemPermissions((Iterable)flows);
        this.linkService.populateLinks((Iterable)flows);
        return flows;
    }

    public VersionedFlow updateFlow(VersionedFlow versionedFlow) {
        this.authorizeBucketAccess(RequestAction.WRITE, versionedFlow);
        this.validateUpdateOfRevisableEntity((RevisableEntity)versionedFlow, VERSIONED_FLOW_ENTITY_TYPE);
        this.registryService.verifyFlowExists(versionedFlow.getIdentifier());
        VersionedFlow updatedFlow = (VersionedFlow)this.updateRevisableEntity((RevisableEntity)versionedFlow, VERSIONED_FLOW_ENTITY_TYPE, this.currentUserIdentity(), () -> this.registryService.updateFlow(versionedFlow));
        this.permissionsService.populateItemPermissions((BucketItem)updatedFlow);
        this.linkService.populateLinks((LinkableEntity)updatedFlow);
        return updatedFlow;
    }

    public VersionedFlow deleteFlow(String bucketIdentifier, String flowIdentifier, RevisionInfo revisionInfo) {
        this.authorizeBucketAccess(RequestAction.DELETE, bucketIdentifier);
        this.validateDeleteOfRevisableEntity(flowIdentifier, revisionInfo, VERSIONED_FLOW_ENTITY_TYPE);
        this.registryService.verifyFlowExists(flowIdentifier);
        return (VersionedFlow)this.deleteRevisableEntity(flowIdentifier, VERSIONED_FLOW_ENTITY_TYPE, revisionInfo, () -> this.registryService.deleteFlow(bucketIdentifier, flowIdentifier));
    }

    public VersionedFlowSnapshot createFlowSnapshot(VersionedFlowSnapshot flowSnapshot) {
        this.authorizeBucketAccess(RequestAction.WRITE, flowSnapshot);
        VersionedFlowSnapshot createdSnapshot = this.registryService.createFlowSnapshot(flowSnapshot);
        this.populateLinksAndPermissions(createdSnapshot);
        return createdSnapshot;
    }

    public VersionedFlowSnapshot getFlowSnapshot(String bucketIdentifier, String flowIdentifier, Integer version) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        VersionedFlowSnapshot snapshot = this.registryService.getFlowSnapshot(bucketIdentifier, flowIdentifier, version);
        this.populateLinksAndPermissions(snapshot);
        return snapshot;
    }

    public VersionedFlowSnapshot getFlowSnapshot(String flowIdentifier, Integer version) {
        VersionedFlowSnapshotMetadata latestMetadata = this.registryService.getLatestFlowSnapshotMetadata(flowIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, latestMetadata);
        String bucketIdentifier = latestMetadata.getBucketIdentifier();
        VersionedFlowSnapshot snapshot = this.registryService.getFlowSnapshot(bucketIdentifier, flowIdentifier, version);
        this.populateLinksAndPermissions(snapshot);
        return snapshot;
    }

    public VersionedFlowSnapshot getLatestFlowSnapshot(String bucketIdentifier, String flowIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        VersionedFlowSnapshotMetadata latestMetadata = this.getLatestFlowSnapshotMetadata(bucketIdentifier, flowIdentifier);
        VersionedFlowSnapshot lastSnapshot = this.getFlowSnapshot(bucketIdentifier, flowIdentifier, Integer.valueOf(latestMetadata.getVersion()));
        this.populateLinksAndPermissions(lastSnapshot);
        return lastSnapshot;
    }

    public VersionedFlowSnapshot getLatestFlowSnapshot(String flowIdentifier) {
        VersionedFlowSnapshotMetadata latestMetadata = this.registryService.getLatestFlowSnapshotMetadata(flowIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, latestMetadata);
        String bucketIdentifier = latestMetadata.getBucketIdentifier();
        Integer latestVersion = latestMetadata.getVersion();
        VersionedFlowSnapshot lastSnapshot = this.registryService.getFlowSnapshot(bucketIdentifier, flowIdentifier, latestVersion);
        this.populateLinksAndPermissions(lastSnapshot);
        return lastSnapshot;
    }

    public VersionedFlowSnapshot importVersionedFlowSnapshot(VersionedFlowSnapshot versionedFlowSnapshot, String bucketIdentifier, String flowIdentifier, String comments) {
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setBucketIdentifier(bucketIdentifier);
        metadata.setFlowIdentifier(flowIdentifier);
        metadata.setVersion(-1);
        if (StringUtils.isNotBlank((CharSequence)comments)) {
            metadata.setComments(comments);
        } else if (versionedFlowSnapshot.getSnapshotMetadata() != null && StringUtils.isNotBlank((CharSequence)versionedFlowSnapshot.getSnapshotMetadata().getComments())) {
            metadata.setComments(versionedFlowSnapshot.getSnapshotMetadata().getComments());
        }
        versionedFlowSnapshot.setSnapshotMetadata(metadata);
        String userIdentity = NiFiUserUtils.getNiFiUserIdentity();
        versionedFlowSnapshot.getSnapshotMetadata().setAuthor(userIdentity);
        return this.createFlowSnapshot(versionedFlowSnapshot);
    }

    public ExportedVersionedFlowSnapshot exportFlowSnapshot(String bucketIdentifier, String flowIdentifier, Integer versionNumber) {
        VersionedFlowSnapshot versionedFlowSnapshot = this.getFlowSnapshot(bucketIdentifier, flowIdentifier, versionNumber);
        String flowName = versionedFlowSnapshot.getFlow().getName();
        String dashFlowName = flowName.replaceAll("\\s", "-");
        String filename = String.format("%s-version-%d.json", dashFlowName, versionedFlowSnapshot.getSnapshotMetadata().getVersion());
        versionedFlowSnapshot.setFlow(null);
        versionedFlowSnapshot.setBucket(null);
        versionedFlowSnapshot.getSnapshotMetadata().setBucketIdentifier(null);
        versionedFlowSnapshot.getSnapshotMetadata().setFlowIdentifier(null);
        versionedFlowSnapshot.getSnapshotMetadata().setLink(null);
        return new ExportedVersionedFlowSnapshot(versionedFlowSnapshot, filename);
    }

    public SortedSet<VersionedFlowSnapshotMetadata> getFlowSnapshots(String bucketIdentifier, String flowIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        SortedSet snapshots = this.registryService.getFlowSnapshots(bucketIdentifier, flowIdentifier);
        this.linkService.populateLinks((Iterable)snapshots);
        return snapshots;
    }

    public SortedSet<VersionedFlowSnapshotMetadata> getFlowSnapshots(String flowIdentifier) {
        VersionedFlow flow = this.registryService.getFlow(flowIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, flow);
        String bucketIdentifier = flow.getBucketIdentifier();
        SortedSet snapshots = this.registryService.getFlowSnapshots(bucketIdentifier, flowIdentifier);
        this.linkService.populateLinks((Iterable)snapshots);
        return snapshots;
    }

    public VersionedFlowSnapshotMetadata getLatestFlowSnapshotMetadata(String bucketIdentifier, String flowIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        VersionedFlowSnapshotMetadata latest = this.registryService.getLatestFlowSnapshotMetadata(bucketIdentifier, flowIdentifier);
        this.linkService.populateLinks((LinkableEntity)latest);
        return latest;
    }

    public VersionedFlowSnapshotMetadata getLatestFlowSnapshotMetadata(String flowIdentifier) {
        VersionedFlowSnapshotMetadata latest = this.registryService.getLatestFlowSnapshotMetadata(flowIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, latest);
        this.linkService.populateLinks((LinkableEntity)latest);
        return latest;
    }

    public VersionedFlowDifference getFlowDiff(String bucketIdentifier, String flowIdentifier, Integer versionA, Integer versionB) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        return this.registryService.getFlowDiff(bucketIdentifier, flowIdentifier, versionA, versionB);
    }

    private void populateLinksAndPermissions(VersionedFlowSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (snapshot.getSnapshotMetadata() != null) {
            this.linkService.populateLinks((LinkableEntity)snapshot.getSnapshotMetadata());
        }
        if (snapshot.getFlow() != null) {
            this.linkService.populateLinks((LinkableEntity)snapshot.getFlow());
        }
        if (snapshot.getBucket() != null) {
            this.permissionsService.populateBucketPermissions(snapshot.getBucket());
            this.linkService.populateLinks((LinkableEntity)snapshot.getBucket());
        }
    }

    public List<Bundle> getBundles(BundleFilterParams filterParams) {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return new ArrayList<Bundle>();
        }
        List bundles = this.extensionService.getBundles(authorizedBucketIds, filterParams);
        this.permissionsService.populateItemPermissions((Iterable)bundles);
        this.linkService.populateLinks((Iterable)bundles);
        return bundles;
    }

    public List<Bundle> getBundlesByBucket(String bucketIdentifier) {
        this.authorizeBucketAccess(RequestAction.READ, bucketIdentifier);
        List bundles = this.extensionService.getBundlesByBucket(bucketIdentifier);
        this.permissionsService.populateItemPermissions((Iterable)bundles);
        this.linkService.populateLinks((Iterable)bundles);
        return bundles;
    }

    public Bundle getBundle(String bundleIdentifier) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        this.permissionsService.populateItemPermissions((BucketItem)bundle);
        this.linkService.populateLinks((LinkableEntity)bundle);
        return bundle;
    }

    public Bundle deleteBundle(String bundleIdentifier) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        this.authorizeBucketAccess(RequestAction.DELETE, bundle);
        Bundle deletedBundle = this.extensionService.deleteBundle(bundle);
        this.permissionsService.populateItemPermissions((BucketItem)deletedBundle);
        this.linkService.populateLinks((LinkableEntity)deletedBundle);
        return deletedBundle;
    }

    public BundleVersion createBundleVersion(String bucketIdentifier, BundleType bundleType, InputStream inputStream, String clientSha256) throws IOException {
        this.authorizeBucketAccess(RequestAction.WRITE, bucketIdentifier);
        BundleVersion createdBundleVersion = this.extensionService.createBundleVersion(bucketIdentifier, bundleType, inputStream, clientSha256);
        this.linkService.populateLinks((LinkableEntity)createdBundleVersion.getVersionMetadata());
        this.linkService.populateLinks((LinkableEntity)createdBundleVersion.getBundle());
        this.linkService.populateLinks((LinkableEntity)createdBundleVersion.getBucket());
        this.permissionsService.populateItemPermissions((BucketItem)createdBundleVersion.getBundle());
        return createdBundleVersion;
    }

    public SortedSet<BundleVersionMetadata> getBundleVersions(BundleVersionFilterParams filterParams) {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return Collections.emptySortedSet();
        }
        SortedSet bundleVersions = this.extensionService.getBundleVersions(authorizedBucketIds, filterParams);
        this.linkService.populateLinks((Iterable)bundleVersions);
        return bundleVersions;
    }

    public SortedSet<BundleVersionMetadata> getBundleVersions(String bundleIdentifier) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        SortedSet bundleVersions = this.extensionService.getBundleVersions(bundleIdentifier);
        this.linkService.populateLinks((Iterable)bundleVersions);
        return bundleVersions;
    }

    public BundleVersion getBundleVersion(String bundleIdentifier, String version) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        this.linkService.populateLinks((LinkableEntity)bundleVersion);
        return bundleVersion;
    }

    public StreamingContent getBundleVersionContent(String bundleIdentifier, String version) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeBundleVersionContent(bundleVersion, output);
        return new StreamingContent(streamingOutput, bundleVersion.getFilename());
    }

    public BundleVersion deleteBundleVersion(String bundleIdentifier, String version) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        this.authorizeBucketAccess(RequestAction.DELETE, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        BundleVersion deletedBundleVersion = this.extensionService.deleteBundleVersion(bundleVersion);
        this.linkService.populateLinks((LinkableEntity)deletedBundleVersion);
        return deletedBundleVersion;
    }

    public SortedSet<ExtensionMetadata> getExtensionMetadata(ExtensionFilterParams filterParams) {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return Collections.emptySortedSet();
        }
        SortedSet metadata = this.extensionService.getExtensionMetadata(authorizedBucketIds, filterParams);
        this.linkService.populateLinks((Iterable)metadata);
        return metadata;
    }

    public SortedSet<ExtensionMetadata> getExtensionMetadata(ProvidedServiceAPI serviceAPI) {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return Collections.emptySortedSet();
        }
        SortedSet metadata = this.extensionService.getExtensionMetadata(authorizedBucketIds, serviceAPI);
        this.linkService.populateLinks((Iterable)metadata);
        return metadata;
    }

    public SortedSet<ExtensionMetadata> getExtensionMetadata(String bundleIdentifier, String version) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        SortedSet extensions = this.extensionService.getExtensionMetadata(bundleVersion);
        this.linkService.populateLinks((Iterable)extensions);
        return extensions;
    }

    public Extension getExtension(String bundleIdentifier, String version, String name) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        return this.extensionService.getExtension(bundleVersion, name);
    }

    public StreamingOutput getExtensionDocs(String bundleIdentifier, String version, String name) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeExtensionDocs(bundleVersion, name, output);
        return streamingOutput;
    }

    public StreamingOutput getAdditionalDetailsDocs(String bundleIdentifier, String version, String name) {
        Bundle bundle = this.extensionService.getBundle(bundleIdentifier);
        this.authorizeBucketAccess(RequestAction.READ, bundle);
        String bucketIdentifier = bundle.getBucketIdentifier();
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucketIdentifier, bundleIdentifier, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeAdditionalDetailsDocs(bundleVersion, name, output);
        return streamingOutput;
    }

    public SortedSet<TagCount> getExtensionTags() {
        return this.extensionService.getExtensionTags();
    }

    public SortedSet<ExtensionRepoBucket> getExtensionRepoBuckets(URI baseUri) {
        Set authorizedBucketIds = this.getAuthorizedBucketIds(RequestAction.READ);
        if (authorizedBucketIds == null || authorizedBucketIds.isEmpty()) {
            return Collections.emptySortedSet();
        }
        SortedSet repoBuckets = this.extensionService.getExtensionRepoBuckets(authorizedBucketIds);
        this.linkService.populateFullLinks((Iterable)repoBuckets, baseUri);
        return repoBuckets;
    }

    public SortedSet<ExtensionRepoGroup> getExtensionRepoGroups(URI baseUri, String bucketName) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        SortedSet repoGroups = this.extensionService.getExtensionRepoGroups(bucket);
        this.linkService.populateFullLinks((Iterable)repoGroups, baseUri);
        return this.extensionService.getExtensionRepoGroups(bucket);
    }

    public SortedSet<ExtensionRepoArtifact> getExtensionRepoArtifacts(URI baseUri, String bucketName, String groupId) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        SortedSet repoArtifacts = this.extensionService.getExtensionRepoArtifacts(bucket, groupId);
        this.linkService.populateFullLinks((Iterable)repoArtifacts, baseUri);
        return repoArtifacts;
    }

    public SortedSet<ExtensionRepoVersionSummary> getExtensionRepoVersions(URI baseUri, String bucketName, String groupId, String artifactId) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        SortedSet repoVersions = this.extensionService.getExtensionRepoVersions(bucket, groupId, artifactId);
        this.linkService.populateFullLinks((Iterable)repoVersions, baseUri);
        return repoVersions;
    }

    public ExtensionRepoVersion getExtensionRepoVersion(URI baseUri, String bucketName, String groupId, String artifactId, String version) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        String extensionsUri = this.generateResourceUri(baseUri, new String[]{"extension-repository", bundleVersion.getBucket().getName(), bundleVersion.getBundle().getGroupId(), bundleVersion.getBundle().getArtifactId(), bundleVersion.getVersionMetadata().getVersion(), "extensions"});
        String downloadUri = this.generateResourceUri(baseUri, new String[]{"extension-repository", bundleVersion.getBucket().getName(), bundleVersion.getBundle().getGroupId(), bundleVersion.getBundle().getArtifactId(), bundleVersion.getVersionMetadata().getVersion(), "content"});
        String sha256Uri = this.generateResourceUri(baseUri, new String[]{"extension-repository", bundleVersion.getBucket().getName(), bundleVersion.getBundle().getGroupId(), bundleVersion.getBundle().getArtifactId(), bundleVersion.getVersionMetadata().getVersion(), "sha256"});
        ExtensionRepoVersion repoVersion = new ExtensionRepoVersion();
        repoVersion.setExtensionsLink(Link.fromUri((String)extensionsUri).rel("extensions").build(new Object[0]));
        repoVersion.setDownloadLink(Link.fromUri((String)downloadUri).rel("content").build(new Object[0]));
        repoVersion.setSha256Link(Link.fromUri((String)sha256Uri).rel("sha256").build(new Object[0]));
        repoVersion.setSha256Supplied(bundleVersion.getVersionMetadata().getSha256Supplied());
        return repoVersion;
    }

    public StreamingContent getExtensionRepoVersionContent(String bucketName, String groupId, String artifactId, String version) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeBundleVersionContent(bundleVersion, output);
        return new StreamingContent(streamingOutput, bundleVersion.getFilename());
    }

    public String getExtensionRepoVersionSha256(String bucketName, String groupId, String artifactId, String version) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        String sha256Hex = bundleVersion.getVersionMetadata().getSha256();
        return sha256Hex;
    }

    public List<ExtensionRepoExtensionMetadata> getExtensionRepoExtensions(URI baseUri, String bucketName, String groupId, String artifactId, String version) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        SortedSet extensions = this.extensionService.getExtensionMetadata(bundleVersion);
        ArrayList<ExtensionRepoExtensionMetadata> extensionRepoExtensions = new ArrayList<ExtensionRepoExtensionMetadata>(extensions.size());
        extensions.forEach(e -> extensionRepoExtensions.add(new ExtensionRepoExtensionMetadata(e)));
        this.linkService.populateFullLinks(extensionRepoExtensions, baseUri);
        return extensionRepoExtensions;
    }

    public Extension getExtensionRepoExtension(URI baseUri, String bucketName, String groupId, String artifactId, String version, String extensionName) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        Extension extension = this.extensionService.getExtension(bundleVersion, extensionName);
        return extension;
    }

    public StreamingOutput getExtensionRepoExtensionDocs(URI baseUri, String bucketName, String groupId, String artifactId, String version, String extensionName) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeExtensionDocs(bundleVersion, extensionName, output);
        return streamingOutput;
    }

    public StreamingOutput getExtensionRepoExtensionAdditionalDocs(URI baseUri, String bucketName, String groupId, String artifactId, String version, String extensionName) {
        Bucket bucket = this.registryService.getBucketByName(bucketName);
        this.authorizeBucketAccess(RequestAction.READ, bucket.getIdentifier());
        BundleVersion bundleVersion = this.extensionService.getBundleVersion(bucket.getIdentifier(), groupId, artifactId, version);
        StreamingOutput streamingOutput = output -> this.extensionService.writeAdditionalDetailsDocs(bundleVersion, extensionName, output);
        return streamingOutput;
    }

    public Set<String> getBucketFields() {
        return this.registryService.getBucketFields();
    }

    public Set<String> getBucketItemFields() {
        return this.registryService.getBucketItemFields();
    }

    public Set<String> getFlowFields() {
        return this.registryService.getFlowFields();
    }

    public User createUser(User user) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.WRITE);
        this.validateCreationOfRevisableEntity((RevisableEntity)user, USER_ENTITY_TYPE);
        this.validateIdentifierNotPresent((RevisableEntity)user, USER_ENTITY_TYPE);
        user.setIdentifier(UUID.randomUUID().toString());
        return (User)this.createRevisableEntity((RevisableEntity)user, USER_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.createUser(user));
    }

    public List<User> getUsers() {
        this.verifyAuthorizerIsManaged();
        this.authorizeTenantsAccess(RequestAction.READ);
        return this.getRevisableEntities(() -> this.authorizationService.getUsers());
    }

    public User getUser(String identifier) {
        this.verifyAuthorizerIsManaged();
        this.authorizeTenantsAccess(RequestAction.READ);
        return (User)this.getRevisableEntity(() -> this.authorizationService.getUser(identifier));
    }

    public User updateUser(User user) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.WRITE);
        this.validateUpdateOfRevisableEntity((RevisableEntity)user, USER_ENTITY_TYPE);
        this.authorizationService.verifyUserExists(user.getIdentifier());
        return (User)this.updateRevisableEntity((RevisableEntity)user, USER_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.updateUser(user));
    }

    public User deleteUser(String identifier, RevisionInfo revisionInfo) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.DELETE);
        this.validateDeleteOfRevisableEntity(identifier, revisionInfo, USER_ENTITY_TYPE);
        this.authorizationService.verifyUserExists(identifier);
        return (User)this.deleteRevisableEntity(identifier, USER_ENTITY_TYPE, revisionInfo, () -> this.authorizationService.deleteUser(identifier));
    }

    public UserGroup createUserGroup(UserGroup userGroup) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.WRITE);
        this.validateCreationOfRevisableEntity((RevisableEntity)userGroup, USER_GROUP_ENTITY_TYPE);
        this.validateIdentifierNotPresent((RevisableEntity)userGroup, USER_GROUP_ENTITY_TYPE);
        userGroup.setIdentifier(UUID.randomUUID().toString());
        return (UserGroup)this.createRevisableEntity((RevisableEntity)userGroup, USER_GROUP_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.createUserGroup(userGroup));
    }

    public List<UserGroup> getUserGroups() {
        this.verifyAuthorizerIsManaged();
        this.authorizeTenantsAccess(RequestAction.READ);
        return this.getRevisableEntities(() -> this.authorizationService.getUserGroups());
    }

    public UserGroup getUserGroup(String identifier) {
        this.verifyAuthorizerIsManaged();
        this.authorizeTenantsAccess(RequestAction.READ);
        return (UserGroup)this.getRevisableEntity(() -> this.authorizationService.getUserGroup(identifier));
    }

    public UserGroup updateUserGroup(UserGroup userGroup) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.WRITE);
        this.validateUpdateOfRevisableEntity((RevisableEntity)userGroup, USER_GROUP_ENTITY_TYPE);
        this.authorizationService.verifyUserGroupExists(userGroup.getIdentifier());
        return (UserGroup)this.updateRevisableEntity((RevisableEntity)userGroup, USER_GROUP_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.updateUserGroup(userGroup));
    }

    public UserGroup deleteUserGroup(String identifier, RevisionInfo revisionInfo) {
        this.verifyAuthorizerSupportsConfigurableUserGroups();
        this.authorizeTenantsAccess(RequestAction.DELETE);
        this.validateDeleteOfRevisableEntity(identifier, revisionInfo, USER_GROUP_ENTITY_TYPE);
        this.authorizationService.verifyUserGroupExists(identifier);
        return (UserGroup)this.deleteRevisableEntity(identifier, USER_GROUP_ENTITY_TYPE, revisionInfo, () -> this.authorizationService.deleteUserGroup(identifier));
    }

    public AccessPolicy createAccessPolicy(AccessPolicy accessPolicy) {
        this.verifyAuthorizerSupportsConfigurablePolicies();
        this.authorizePoliciesAccess(RequestAction.WRITE);
        this.validateCreationOfRevisableEntity((RevisableEntity)accessPolicy, ACCESS_POLICY_ENTITY_TYPE);
        this.validateIdentifierNotPresent((RevisableEntity)accessPolicy, ACCESS_POLICY_ENTITY_TYPE);
        accessPolicy.setIdentifier(UUID.randomUUID().toString());
        return (AccessPolicy)this.createRevisableEntity((RevisableEntity)accessPolicy, ACCESS_POLICY_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.createAccessPolicy(accessPolicy));
    }

    public AccessPolicy getAccessPolicy(String identifier) {
        this.verifyAuthorizerIsManaged();
        this.authorizePoliciesAccess(RequestAction.READ);
        return (AccessPolicy)this.getRevisableEntity(() -> this.authorizationService.getAccessPolicy(identifier));
    }

    public AccessPolicy getAccessPolicy(String resource, RequestAction action) {
        this.verifyAuthorizerIsManaged();
        this.authorizePoliciesAccess(RequestAction.READ);
        return (AccessPolicy)this.getRevisableEntity(() -> this.authorizationService.getAccessPolicy(resource, action));
    }

    public List<AccessPolicy> getAccessPolicies() {
        this.verifyAuthorizerIsManaged();
        this.authorizePoliciesAccess(RequestAction.READ);
        return this.getRevisableEntities(() -> this.authorizationService.getAccessPolicies());
    }

    public AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) {
        this.verifyAuthorizerSupportsConfigurablePolicies();
        this.authorizePoliciesAccess(RequestAction.WRITE);
        this.validateUpdateOfRevisableEntity((RevisableEntity)accessPolicy, ACCESS_POLICY_ENTITY_TYPE);
        this.authorizationService.verifyAccessPolicyExists(accessPolicy.getIdentifier());
        return (AccessPolicy)this.updateRevisableEntity((RevisableEntity)accessPolicy, ACCESS_POLICY_ENTITY_TYPE, this.currentUserIdentity(), () -> this.authorizationService.updateAccessPolicy(accessPolicy));
    }

    public AccessPolicy deleteAccessPolicy(String identifier, RevisionInfo revisionInfo) {
        this.verifyAuthorizerSupportsConfigurablePolicies();
        this.authorizePoliciesAccess(RequestAction.DELETE);
        this.validateDeleteOfRevisableEntity(identifier, revisionInfo, ACCESS_POLICY_ENTITY_TYPE);
        this.authorizationService.verifyAccessPolicyExists(identifier);
        return (AccessPolicy)this.deleteRevisableEntity(identifier, ACCESS_POLICY_ENTITY_TYPE, revisionInfo, () -> this.authorizationService.deleteAccessPolicy(identifier));
    }

    public List<Resource> getResources() {
        this.authorizePoliciesAccess(RequestAction.READ);
        return this.authorizationService.getResources();
    }

    public CurrentUser getCurrentUser() {
        return this.authorizationService.getCurrentUser();
    }

    private void verifyAuthorizerIsManaged() {
        this.authorizationService.verifyAuthorizerIsManaged();
    }

    private void verifyAuthorizerSupportsConfigurablePolicies() {
        this.authorizationService.verifyAuthorizerSupportsConfigurablePolicies();
    }

    private void verifyAuthorizerSupportsConfigurableUserGroups() {
        this.authorizationService.verifyAuthorizerSupportsConfigurableUserGroups();
    }

    public RegistryConfiguration getRegistryConfiguration() {
        RegistryConfiguration config = new RegistryConfiguration();
        boolean hasAnyConfigurationAccess = false;
        AccessDeniedException lastAccessDeniedException = null;
        try {
            Authorizable policyAuthorizer = this.authorizableLookup.getPoliciesAuthorizable();
            this.authorizationService.authorize(policyAuthorizer, RequestAction.READ);
            config.setSupportsManagedAuthorizer(Boolean.valueOf(this.authorizationService.isManagedAuthorizer()));
            config.setSupportsConfigurableAuthorizer(Boolean.valueOf(this.authorizationService.isConfigurableAccessPolicyProvider()));
            hasAnyConfigurationAccess = true;
        }
        catch (AccessDeniedException e) {
            lastAccessDeniedException = e;
        }
        try {
            this.authorizationService.authorize(this.authorizableLookup.getTenantsAuthorizable(), RequestAction.READ);
            config.setSupportsConfigurableUsersAndGroups(Boolean.valueOf(this.authorizationService.isConfigurableUserGroupProvider()));
            hasAnyConfigurationAccess = true;
        }
        catch (AccessDeniedException e) {
            lastAccessDeniedException = e;
        }
        if (!hasAnyConfigurationAccess) {
            throw lastAccessDeniedException;
        }
        return config;
    }

    private void authorizeBucketsAccess(RequestAction actionType) throws AccessDeniedException {
        Authorizable bucketsAuthorizable = this.authorizableLookup.getBucketsAuthorizable();
        this.authorizationService.authorize(bucketsAuthorizable, actionType);
    }

    private void authorizeBucketAccess(RequestAction actionType, String bucketIdentifier) {
        if (StringUtils.isBlank((CharSequence)bucketIdentifier)) {
            throw new IllegalArgumentException("Unable to authorize access because bucket identifier is null or blank");
        }
        Authorizable bucketAuthorizable = this.authorizableLookup.getBucketAuthorizable(bucketIdentifier);
        this.authorizationService.authorize(bucketAuthorizable, actionType);
    }

    private void authorizeBucketAccess(RequestAction action, Bundle bundle) {
        if (bundle == null) {
            throw new IllegalStateException("Unable to authorize access because bucket identifier is null or blank");
        }
        this.authorizeBucketAccess(action, bundle.getBucketIdentifier());
    }

    private void authorizeBucketAccess(RequestAction action, VersionedFlow flow) {
        if (flow == null) {
            throw new IllegalStateException("Unable to authorize access because bucket identifier is null or blank");
        }
        this.authorizeBucketAccess(action, flow.getBucketIdentifier());
    }

    private void authorizeBucketAccess(RequestAction action, VersionedFlowSnapshot flowSnapshot) {
        if (flowSnapshot == null || flowSnapshot.getSnapshotMetadata() == null) {
            throw new IllegalStateException("Unable to authorize access because bucket identifier is null or blank");
        }
        this.authorizeBucketAccess(action, flowSnapshot.getSnapshotMetadata().getBucketIdentifier());
    }

    private void authorizeBucketAccess(RequestAction action, VersionedFlowSnapshotMetadata flowSnapshotMetadata) {
        if (flowSnapshotMetadata == null) {
            throw new IllegalStateException("Unable to authorize access because bucket identifier is null or blank");
        }
        this.authorizeBucketAccess(action, flowSnapshotMetadata.getBucketIdentifier());
    }

    private Set<String> getAuthorizedBucketIds(RequestAction actionType) {
        return this.authorizationService.getAuthorizedResources(actionType, ResourceType.Bucket).stream().map(StandardServiceFacade::extractBucketIdFromResource).filter(Objects::nonNull).distinct().collect(Collectors.toSet());
    }

    private static String extractBucketIdFromResource(Resource resource) {
        if (resource == null || resource.getIdentifier() == null || !resource.getIdentifier().startsWith("/buckets/")) {
            return null;
        }
        String[] pathComponents = resource.getIdentifier().split("/");
        if (pathComponents.length < 3) {
            return null;
        }
        return pathComponents[2];
    }

    private String generateResourceUri(URI baseUri, String ... path) {
        URI fullUri = UriBuilder.fromUri((URI)baseUri).segment(path).build(new Object[0]);
        return fullUri.toString();
    }

    private void authorizePoliciesAccess(RequestAction actionType) {
        Authorizable policiesAuthorizable = this.authorizableLookup.getPoliciesAuthorizable();
        this.authorizationService.authorize(policiesAuthorizable, actionType);
    }

    private void authorizeTenantsAccess(RequestAction actionType) {
        Authorizable tenantsAuthorizable = this.authorizableLookup.getTenantsAuthorizable();
        this.authorizationService.authorize(tenantsAuthorizable, actionType);
    }

    private void validateCreationOfRevisableEntity(RevisableEntity entity, String entityTypeName) {
        if (entity == null) {
            throw new IllegalArgumentException(entityTypeName + " cannot be null");
        }
        if (!this.revisionFeature.isEnabled()) {
            return;
        }
        if (entity.getRevision() == null || entity.getRevision().getVersion() == null || entity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new " + entityTypeName + ".");
        }
    }

    private void validateIdentifierNotPresent(RevisableEntity entity, String entityTypeName) {
        if (entity.getIdentifier() != null) {
            throw new IllegalArgumentException(entityTypeName + " identifier cannot be specified when creating a new " + entityTypeName.toLowerCase() + ".");
        }
    }

    private void validateUpdateOfRevisableEntity(RevisableEntity entity, String entityTypeName) {
        if (entity == null) {
            throw new IllegalArgumentException(entityTypeName + " cannot be null");
        }
        if (!this.revisionFeature.isEnabled()) {
            return;
        }
        if (entity.getRevision() == null || entity.getRevision().getVersion() == null) {
            throw new IllegalArgumentException("Revision info must be specified.");
        }
    }

    private void validateDeleteOfRevisableEntity(String identifier, RevisionInfo revision, String entityTypeName) {
        if (identifier == null || identifier.trim().isEmpty()) {
            throw new IllegalArgumentException(entityTypeName + " identifier is required");
        }
        if (!this.revisionFeature.isEnabled()) {
            return;
        }
        if (revision == null || revision.getVersion() == null) {
            throw new IllegalArgumentException("Revision info must be specified.");
        }
    }

    private <T extends RevisableEntity> T getRevisableEntity(Supplier<T> getEntity) {
        if (!this.revisionFeature.isEnabled()) {
            RevisableEntity entity = (RevisableEntity)getEntity.get();
            if (entity.getRevision() == null) {
                entity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
            return (T)entity;
        }
        return (T)this.entityService.get(getEntity);
    }

    private <T extends RevisableEntity> List<T> getRevisableEntities(Supplier<List<T>> getEntities) {
        if (!this.revisionFeature.isEnabled()) {
            List<T> entities = getEntities.get();
            for (RevisableEntity entity : entities) {
                if (entity.getRevision() != null) continue;
                entity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
            return entities;
        }
        return this.entityService.getEntities(getEntities);
    }

    private void populateRevisableEntities(List<?> entities) {
        if (!this.revisionFeature.isEnabled()) {
            for (Object entity : entities) {
                RevisableEntity revisableEntity;
                if (!(entity instanceof RevisableEntity) || (revisableEntity = (RevisableEntity)entity).getRevision() != null) continue;
                revisableEntity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
        } else {
            this.entityService.populateRevisions(entities);
        }
    }

    private <T extends RevisableEntity> T createRevisableEntity(T requestEntity, String entityTypeName, String creatorIdentity, Supplier<T> createEntity) {
        if (!this.revisionFeature.isEnabled()) {
            RevisableEntity entity = (RevisableEntity)createEntity.get();
            if (entity.getRevision() == null) {
                entity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
            return (T)entity;
        }
        try {
            return (T)this.entityService.create(requestEntity, creatorIdentity, createEntity);
        }
        catch (InvalidRevisionException e) {
            String msg = String.format(INVALID_REVISION_MSG, entityTypeName, "create", requestEntity.getIdentifier());
            throw new InvalidRevisionException(msg, (Throwable)e);
        }
    }

    private <T extends RevisableEntity> T updateRevisableEntity(T requestEntity, String entityTypeName, String updaterIdentity, Supplier<T> updateEntity) {
        if (!this.revisionFeature.isEnabled()) {
            RevisableEntity entity = (RevisableEntity)updateEntity.get();
            if (entity.getRevision() == null) {
                entity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
            return (T)entity;
        }
        try {
            return (T)this.entityService.update(requestEntity, updaterIdentity, updateEntity);
        }
        catch (InvalidRevisionException e) {
            String msg = String.format(INVALID_REVISION_MSG, entityTypeName, "update", requestEntity.getIdentifier());
            throw new InvalidRevisionException(msg, (Throwable)e);
        }
    }

    private <T extends RevisableEntity> T deleteRevisableEntity(String entityIdentifier, String entityTypeName, RevisionInfo revisionInfo, Supplier<T> deleteEntity) {
        if (!this.revisionFeature.isEnabled()) {
            RevisableEntity entity = (RevisableEntity)deleteEntity.get();
            if (entity.getRevision() == null) {
                entity.setRevision(new RevisionInfo(null, Long.valueOf(0L)));
            }
            return (T)entity;
        }
        try {
            return (T)this.entityService.delete(entityIdentifier, revisionInfo, deleteEntity);
        }
        catch (InvalidRevisionException e) {
            String msg = String.format(INVALID_REVISION_MSG, entityTypeName, "delete", entityIdentifier);
            throw new InvalidRevisionException(msg, (Throwable)e);
        }
    }
}

