/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authorization;

import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.registry.security.authorization.AuthorizableLookup;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.service.AuthorizationService;
import org.apache.nifi.registry.web.security.authorization.HttpMethodAuthorizationRules;
import org.apache.nifi.registry.web.security.authorization.ResourceAuthorizationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.GenericFilterBean;

public class ResourceAuthorizationFilter
extends GenericFilterBean {
    private static final Logger logger = LoggerFactory.getLogger(ResourceAuthorizationFilter.class);
    private Map<ResourceType, HttpMethodAuthorizationRules> resourceTypeAuthorizationRules;
    private AuthorizationService authorizationService;
    private AuthorizableLookup authorizableLookup;

    ResourceAuthorizationFilter(Builder builder) {
        if (builder.getAuthorizationService() == null || builder.getResourceTypeAuthorizationRules() == null) {
            throw new IllegalArgumentException("Builder is missing one or more required fields [authorizationService, resourceTypeAuthorizationRules].");
        }
        this.resourceTypeAuthorizationRules = builder.getResourceTypeAuthorizationRules();
        this.authorizationService = builder.getAuthorizationService();
        this.authorizableLookup = this.authorizationService.getAuthorizableLookup();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String httpMethodStr;
        HttpMethod httpMethod;
        ResourceType resourceType;
        HttpMethodAuthorizationRules authorizationRules;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        boolean authorizationCheckIsRequired = false;
        String resourcePath = null;
        RequestAction action = null;
        if (servletRequest.isSecure() && (resourcePath = httpServletRequest.getServletPath()) != null && (authorizationRules = (HttpMethodAuthorizationRules)this.resourceTypeAuthorizationRules.get(resourceType = ResourceType.mapFullResourcePathToResourceType((String)resourcePath))) != null && (httpMethod = HttpMethod.resolve((String)(httpMethodStr = httpServletRequest.getMethod().toUpperCase()))) != null && authorizationRules.requiresAuthorization(httpMethod)) {
            authorizationCheckIsRequired = true;
            action = authorizationRules.mapHttpMethodToAction(httpMethod);
        }
        if (!authorizationCheckIsRequired) {
            this.forwardRequestWithoutAuthorizationCheck(httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        try {
            this.authorizeAccess(resourcePath, action);
            this.successfulAuthorization(httpServletRequest, httpServletResponse, filterChain);
        }
        catch (Exception e) {
            logger.debug("Exception occurred while performing authorization check.", (Throwable)e);
            this.failedAuthorization(httpServletRequest, httpServletResponse, filterChain, e);
        }
    }

    private boolean userIsAuthenticated() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return user != null && !user.isAnonymous();
    }

    private void authorizeAccess(String path, RequestAction action) throws AccessDeniedException {
        if (path == null || action == null) {
            throw new IllegalArgumentException("Authorization is required, but a required input [resource, action] is absent.");
        }
        Authorizable authorizable = this.authorizableLookup.getAuthorizableByResource(path);
        if (authorizable == null) {
            throw new IllegalStateException("Resource Authorization Filter configured for non-authorizable resource: " + path);
        }
        this.authorizationService.authorize(authorizable, action);
    }

    private void forwardRequestWithoutAuthorizationCheck(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        logger.debug("Request filter authorization check is not required for this HTTP Method on this resource. Allowing request to proceed. An additional authorization check might be performed downstream of this filter.");
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void successfulAuthorization(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        logger.debug("Request filter authorization check passed. Allowing request to proceed.");
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void failedAuthorization(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Exception failure) throws IOException, ServletException {
        logger.debug("Request filter authorization check failed. Blocking access.");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        String identity = user != null ? user.toString() : "<no user found>";
        int status = !this.userIsAuthenticated() ? 401 : 403;
        logger.info("{} does not have permission to perform this action on the requested resource. {} Returning {} response.", new Object[]{identity, failure.getMessage(), status});
        logger.debug("", (Throwable)failure);
        if (!response.isCommitted()) {
            response.setStatus(status);
            response.setContentType("text/plain");
            response.getWriter().println(String.format("Access is denied due to: %s Contact the system administrator.", failure.getLocalizedMessage()));
        }
    }

    public static Builder builder() {
        return new Builder(null);
    }
}

