/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.kerberos;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.IdentityProviderUsage;
import org.apache.nifi.registry.security.authentication.exception.IdentityAccessException;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.util.CryptoUtils;
import org.apache.nifi.registry.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;

public class KerberosSpnegoIdentityProvider
implements IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(KerberosSpnegoIdentityProvider.class);
    private static final String issuer = KerberosSpnegoIdentityProvider.class.getSimpleName();
    private static final IdentityProviderUsage usage = new /* Unavailable Anonymous Inner Class!! */;
    private static final String AUTHORIZATION = "Authorization";
    private static final String AUTHORIZATION_NEGOTIATE = "Negotiate";
    private long expiration = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider;
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;

    @Autowired
    public KerberosSpnegoIdentityProvider(@Nullable KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider, NiFiRegistryProperties properties) {
        this.kerberosServiceAuthenticationProvider = kerberosServiceAuthenticationProvider;
        this.authenticationDetailsSource = new WebAuthenticationDetailsSource();
        String expirationFromProperties = properties.getKerberosSpnegoAuthenticationExpiration();
        if (expirationFromProperties != null) {
            long l = FormatUtils.getTimeDuration((String)expirationFromProperties, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public IdentityProviderUsage getUsageInstructions() {
        return usage;
    }

    public AuthenticationRequest extractCredentials(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        String headerValue = request.getHeader(AUTHORIZATION);
        if (!this.isValidKerberosHeader(headerValue)) {
            return null;
        }
        logger.debug("Detected 'Authorization: Negotiate header in request {}", (Object)request.getRequestURL());
        byte[] base64Token = headerValue.substring(headerValue.indexOf(" ") + 1).getBytes(StandardCharsets.UTF_8);
        byte[] kerberosTicket = Base64.decode((byte[])base64Token);
        return new AuthenticationRequest(null, (Object)kerberosTicket, this.authenticationDetailsSource.buildDetails((Object)request));
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) throws InvalidCredentialsException, IdentityAccessException {
        byte[] kerberosTicket;
        if (authenticationRequest == null) {
            logger.info("Cannot authenticate null authenticationRequest, returning null.");
            return null;
        }
        Object credentials = authenticationRequest.getCredentials();
        byte[] byArray = kerberosTicket = credentials != null && credentials instanceof byte[] ? (byte[])authenticationRequest.getCredentials() : null;
        if (credentials == null) {
            logger.info("Kerberos Ticket not found in authenticationRequest credentials, returning null.");
            return null;
        }
        if (this.kerberosServiceAuthenticationProvider == null) {
            throw new IdentityAccessException("The Kerberos authentication provider is not initialized.");
        }
        try {
            KerberosServiceRequestToken kerberosServiceRequestToken = new KerberosServiceRequestToken(kerberosTicket);
            kerberosServiceRequestToken.setDetails(authenticationRequest.getDetails());
            Authentication authentication = this.kerberosServiceAuthenticationProvider.authenticate((Authentication)kerberosServiceRequestToken);
            if (authentication == null) {
                throw new InvalidCredentialsException("Kerberos credentials could not be authenticated.");
            }
            String kerberosPrincipal = authentication.getName();
            return new AuthenticationResponse(kerberosPrincipal, kerberosPrincipal, this.expiration, issuer);
        }
        catch (AuthenticationException e) {
            String authFailedMessage = "Kerberos credentials could not be authenticated.";
            if (!Boolean.FALSE.equals(CryptoUtils.isCryptoRestricted())) {
                authFailedMessage = authFailedMessage + " This Java Runtime does not support unlimited strength encryption. This could cause Kerberos authentication to fail as it can require AES-256.";
            }
            logger.info(authFailedMessage);
            throw new InvalidCredentialsException(authFailedMessage, (Throwable)e);
        }
    }

    public void onConfigured(IdentityProviderConfigurationContext configurationContext) throws SecurityProviderCreationException {
        throw new SecurityProviderCreationException(KerberosSpnegoIdentityProvider.class.getSimpleName() + " does not currently support being loaded via IdentityProviderFactory");
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    public boolean isValidKerberosHeader(String headerValue) {
        return headerValue != null && (headerValue.startsWith("Negotiate ") || headerValue.startsWith("Kerberos "));
    }
}

