/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.kerberos;

import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.web.security.authentication.kerberos.KerberosSpnegoIdentityProvider;
import org.apache.nifi.registry.web.security.authentication.kerberos.KerberosUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;

@Configuration
public class KerberosSpnegoFactory {
    @Autowired
    private NiFiRegistryProperties properties;
    @Autowired(required=false)
    private KerberosTicketValidator kerberosTicketValidator;
    private KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider;
    private KerberosSpnegoIdentityProvider kerberosSpnegoIdentityProvider;

    @Bean
    public KerberosSpnegoIdentityProvider kerberosSpnegoIdentityProvider() throws Exception {
        if (this.kerberosSpnegoIdentityProvider == null && this.properties.isKerberosSpnegoSupportEnabled()) {
            this.kerberosSpnegoIdentityProvider = new KerberosSpnegoIdentityProvider(this.kerberosServiceAuthenticationProvider(), this.properties);
        }
        return this.kerberosSpnegoIdentityProvider;
    }

    private KerberosServiceAuthenticationProvider kerberosServiceAuthenticationProvider() throws Exception {
        if (this.kerberosServiceAuthenticationProvider == null && this.properties.isKerberosSpnegoSupportEnabled()) {
            KerberosServiceAuthenticationProvider ksap = new KerberosServiceAuthenticationProvider();
            ksap.setTicketValidator(this.kerberosTicketValidator);
            ksap.setUserDetailsService((UserDetailsService)new KerberosUserDetailsService());
            ksap.afterPropertiesSet();
            this.kerberosServiceAuthenticationProvider = ksap;
        }
        return this.kerberosServiceAuthenticationProvider;
    }
}

