/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.jwt;

import io.jsonwebtoken.JwtException;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.BearerAuthIdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.exception.IdentityAccessException;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.web.security.authentication.exception.InvalidAuthenticationException;
import org.apache.nifi.registry.web.security.authentication.jwt.JwtService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtIdentityProvider
extends BearerAuthIdentityProvider
implements IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(JwtIdentityProvider.class);
    private static final String issuer = JwtIdentityProvider.class.getSimpleName();
    private static final long expiration = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private final JwtService jwtService;

    @Autowired
    public JwtIdentityProvider(JwtService jwtService, NiFiRegistryProperties nifiProperties, Authorizer authorizer) {
        this.jwtService = jwtService;
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) throws InvalidCredentialsException, IdentityAccessException {
        String jwtAuthToken;
        if (authenticationRequest == null) {
            logger.info("Cannot authenticate null authenticationRequest, returning null.");
            return null;
        }
        Object credentials = authenticationRequest.getCredentials();
        String string = jwtAuthToken = credentials != null && credentials instanceof String ? (String)credentials : null;
        if (credentials == null) {
            logger.info("JWT not found in authenticationRequest credentials, returning null.");
            return null;
        }
        try {
            String jwtPrincipal = this.jwtService.getAuthenticationFromToken(jwtAuthToken);
            return new AuthenticationResponse(jwtPrincipal, jwtPrincipal, expiration, issuer);
        }
        catch (JwtException e) {
            throw new InvalidAuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public void onConfigured(IdentityProviderConfigurationContext configurationContext) throws SecurityProviderCreationException {
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }
}

